/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.client;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.client.OperationProgressNotifyListener;
import org.tigris.subversion.subclipse.core.util.ReentrantLock;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;

public class OperationManager
implements ISVNNotifyListener {
    private ReentrantLock lock = new ReentrantLock();
    private Set changedResources = new LinkedHashSet();
    private ISVNClientAdapter svnClient = null;
    private OperationProgressNotifyListener operationNotifyListener = null;
    private static OperationManager instance;

    private OperationManager() {
    }

    public static OperationManager getInstance() {
        if (instance == null) {
            instance = new OperationManager();
        }
        return instance;
    }

    public void beginOperation(ISVNClientAdapter aSvnClient) {
        this.lock.acquire();
        this.svnClient = aSvnClient;
        aSvnClient.addNotifyListener((ISVNNotifyListener)this);
        if (this.lock.getNestingCount() == 1) {
            this.changedResources.clear();
        }
    }

    public void beginOperation(ISVNClientAdapter aSvnClient, OperationProgressNotifyListener anOperationNotifyListener) {
        this.operationNotifyListener = anOperationNotifyListener;
        this.beginOperation(aSvnClient);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endOperation() throws SVNException {
        try {
            if (this.lock.getNestingCount() == 1) {
                this.svnClient.removeNotifyListener((ISVNNotifyListener)this);
                Iterator it = this.changedResources.iterator();
                while (it.hasNext()) {
                    IResource resource = (IResource)it.next();
                    this.handleSVNDir((IContainer)resource);
                    try {
                        resource.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                        if (Policy.DEBUG_METAFILE_CHANGES) {
                            System.out.println("[svn]" + SVNProviderPlugin.getPlugin().getAdminDirectoryName() + " dir refreshed : " + resource.getFullPath());
                        }
                        if (resource.getParent().getType() != 4) continue;
                        resource.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        throw SVNException.wrapException(e);
                    }
                }
            }
            Object var4_6 = null;
            if (this.lock.getNestingCount() == 1) {
                this.changedResources.clear();
            }
            this.lock.release();
            this.operationNotifyListener = null;
            return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (this.lock.getNestingCount() == 1) {
                this.changedResources.clear();
            }
            this.lock.release();
            this.operationNotifyListener = null;
            throw throwable;
        }
    }

    public void onNotify(File path, SVNNodeKind kind) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        Path pathEclipse = new Path(path.getAbsolutePath());
        if (kind == SVNNodeKind.UNKNOWN) {
            IContainer resource;
            IPath pathEntries = pathEclipse.removeLastSegments(1).append(SVNProviderPlugin.getPlugin().getAdminDirectoryName());
            IContainer entries = workspaceRoot.getContainerForLocation(pathEntries);
            if (entries != null) {
                this.changedResources.add(entries);
            }
            if (path.isDirectory() && (resource = workspaceRoot.getContainerForLocation((IPath)pathEclipse)) != null && resource.getType() != 8) {
                IFolder svnDir = resource.getFolder((IPath)new Path(SVNProviderPlugin.getPlugin().getAdminDirectoryName()));
                this.changedResources.add(svnDir);
            }
        } else {
            IContainer resource = null;
            IFolder svnDir = null;
            if (kind == SVNNodeKind.DIR) {
                resource = workspaceRoot.getContainerForLocation((IPath)pathEclipse);
                if (resource != null && resource.getType() != 8) {
                    if (resource.getProject() != resource) {
                        svnDir = resource.getParent().getFolder((IPath)new Path(SVNProviderPlugin.getPlugin().getAdminDirectoryName()));
                        this.changedResources.add(svnDir);
                    }
                    svnDir = resource.getFolder((IPath)new Path(SVNProviderPlugin.getPlugin().getAdminDirectoryName()));
                    this.changedResources.add(svnDir);
                }
            } else if (kind == SVNNodeKind.FILE && (resource = workspaceRoot.getFileForLocation((IPath)pathEclipse)) != null) {
                svnDir = resource.getParent().getFolder((IPath)new Path(SVNProviderPlugin.getPlugin().getAdminDirectoryName()));
                this.changedResources.add(svnDir);
            }
        }
        if (this.operationNotifyListener != null) {
            this.operationNotifyListener.onNotify(path, kind);
            if (this.operationNotifyListener.getMonitor() != null && this.operationNotifyListener.getMonitor().isCanceled()) {
                try {
                    this.svnClient.cancelOperation();
                }
                catch (SVNClientException e) {
                    SVNProviderPlugin.log(SVNException.wrapException((Exception)((Object)e)));
                }
            }
        }
    }

    public void logCommandLine(String commandLine) {
    }

    public void logRevision(long revision, String path) {
    }

    public void logCompleted(String message) {
        if (this.operationNotifyListener != null) {
            this.operationNotifyListener.logMessage(message);
        }
    }

    public void logError(String message) {
    }

    public void logMessage(String message) {
        if (this.operationNotifyListener != null) {
            this.operationNotifyListener.logMessage(message);
        }
    }

    public void setCommand(int command) {
    }

    protected boolean handleSVNDir(final IContainer svnDir) {
        if (!svnDir.exists() || !svnDir.isTeamPrivateMember()) {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        if (!svnDir.exists()) {
                            svnDir.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                        }
                        if (svnDir.exists()) {
                            svnDir.setTeamPrivateMember(true);
                        }
                        if (Policy.DEBUG_METAFILE_CHANGES) {
                            System.out.println("[svn] found a new SVN meta folder, marking as team-private: " + svnDir.getFullPath());
                        }
                    }
                }, (ISchedulingRule)svnDir.getParent(), 1, null);
            }
            catch (CoreException e) {
                SVNProviderPlugin.log(SVNException.wrapException((IResource)svnDir, Policy.bind("OperationManager.errorSettingTeamPrivateFlag"), e));
            }
        }
        return svnDir.isTeamPrivateMember();
    }
}

