/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;
import org.tigris.subversion.subclipse.core.sync.SVNStatusSyncInfo;
import org.tigris.subversion.subclipse.core.sync.SVNWorkspaceSubscriber;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.ShowOutOfDateFoldersAction;
import org.tigris.subversion.subclipse.ui.internal.ScopableSubscriberParticipant;
import org.tigris.subversion.subclipse.ui.subscriber.AddSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.CommitSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.EditConflictsSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.IgnoreSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.MarkMergedSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.OverrideAndUpdateSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.ResolveSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.RevertSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.SVNChangeSetCapability;
import org.tigris.subversion.subclipse.ui.subscriber.ShowHistorySynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.ShowPropertiesSynchronizeAction;
import org.tigris.subversion.subclipse.ui.subscriber.UpdateSynchronizeAction;

public class SVNSynchronizeParticipant
extends ScopableSubscriberParticipant
implements IChangeSetProvider {
    public static final String ID = "org.tigris.subversion.subclipse.participant";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP_1 = "context_group_1";
    private ChangeSetCapability capability;

    public SVNSynchronizeParticipant() {
    }

    public SVNSynchronizeParticipant(ISynchronizeScope scope) {
        super(scope);
        this.setSubscriber((Subscriber)SVNWorkspaceSubscriber.getInstance());
    }

    public void init(String secondaryId, IMemento memento) throws PartInitException {
        super.init(secondaryId, memento);
        this.setSubscriber((Subscriber)SVNWorkspaceSubscriber.getInstance());
    }

    protected ISynchronizeParticipantDescriptor getDescriptor() {
        return TeamUI.getSynchronizeManager().getParticipantDescriptor(ID);
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        SVNParticipantLabelDecorator labelDecorator = new SVNParticipantLabelDecorator();
        configuration.addLabelDecorator((ILabelDecorator)labelDecorator);
        configuration.setSupportedModes(15);
        configuration.setMode(4);
        configuration.addActionContribution((SynchronizePageActionGroup)new SVNParticipantActionGroup());
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", CONTEXT_MENU_CONTRIBUTION_GROUP_1);
    }

    protected boolean isViewerContributionsSupported() {
        return true;
    }

    public ChangeSetCapability getChangeSetCapability() {
        if (this.capability == null) {
            this.capability = new SVNChangeSetCapability();
        }
        return this.capability;
    }

    public IStatus refresh(IResource[] resources, IProgressMonitor monitor) {
        return this.refreshNow(resources, this.getLongTaskName(resources), monitor);
    }

    private class SVNParticipantLabelDecorator
    extends LabelProvider
    implements ILabelDecorator {
        private SVNParticipantLabelDecorator() {
        }

        public Image decorateImage(Image image, Object element) {
            return null;
        }

        public String decorateText(String text, Object element) {
            try {
                SVNStatusSyncInfo info;
                IResource resource;
                if (element instanceof ISynchronizeModelElement && (resource = ((ISynchronizeModelElement)element).getResource()) != null && (info = (SVNStatusSyncInfo)SVNWorkspaceSubscriber.getInstance().getSyncInfo(resource)) != null) {
                    return String.valueOf(text) + info.getLabel();
                }
            }
            catch (TeamException teamException) {}
            return null;
        }
    }

    private class SVNParticipantActionGroup
    extends SynchronizePageActionGroup {
        Action expandAllAction;

        private SVNParticipantActionGroup() {
        }

        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            ShowOutOfDateFoldersAction showOutOfDateFoldersAction = SVNUIPlugin.getPlugin().getShowOutOfDateFoldersAction();
            showOutOfDateFoldersAction.setSvnSynchronizeParticipant(SVNSynchronizeParticipant.this);
            this.appendToGroup("org.eclipse.team.ui.P_VIEW_MENU", "modes", (IAction)showOutOfDateFoldersAction);
            UpdateSynchronizeAction updateAction = new UpdateSynchronizeAction(Policy.bind("SyncAction.update"), configuration);
            updateAction.setId("org.tigris.subversion.subclipse.ui.syncViewUpdate");
            updateAction.setActionDefinitionId("org.tigris.subversion.subclipse.ui.update");
            updateAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Update"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)updateAction);
            CommitSynchronizeAction commitAction = new CommitSynchronizeAction(Policy.bind("SyncAction.commit"), configuration);
            commitAction.setId("org.tigris.subversion.subclipse.ui.syncViewCommit");
            commitAction.setActionDefinitionId("org.tigris.subversion.subclipse.ui.commit");
            commitAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Commit"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)commitAction);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IContributionItem)new Separator());
            OverrideAndUpdateSynchronizeAction overrideAction = new OverrideAndUpdateSynchronizeAction(Policy.bind("SyncAction.override"), configuration);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)overrideAction);
            MarkMergedSynchronizeAction markMergedAction = new MarkMergedSynchronizeAction(Policy.bind("SyncAction.markMerged"), configuration);
            markMergedAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Mark Merged"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)markMergedAction);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IContributionItem)new Separator());
            AddSynchronizeAction addAction = new AddSynchronizeAction(Policy.bind("SyncAction.add"), configuration);
            addAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Add"));
            addAction.setId("org.tigris.subversion.subclipse.ui.syncViewAdd");
            addAction.setActionDefinitionId("org.tigris.subversion.subclipse.ui.add");
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)addAction);
            IgnoreSynchronizeAction ignoreAction = new IgnoreSynchronizeAction(Policy.bind("SyncAction.ignore"), configuration);
            ignoreAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Ignore"));
            ignoreAction.setId("org.tigris.subversion.subclipse.ui.syncViewIgnore");
            ignoreAction.setActionDefinitionId("org.tigris.subversion.subclipse.ui.ignore");
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)ignoreAction);
            RevertSynchronizeAction revertAction = new RevertSynchronizeAction(Policy.bind("SyncAction.revert"), configuration);
            revertAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Revert"));
            revertAction.setId("org.tigris.subversion.subclipse.ui.syncViewRevert");
            revertAction.setActionDefinitionId("org.tigris.subversion.subclipse.ui.revert");
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)revertAction);
            ShowHistorySynchronizeAction historyAction = new ShowHistorySynchronizeAction(Policy.bind("SyncAction.history"), configuration);
            historyAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Show History"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)historyAction);
            ShowPropertiesSynchronizeAction propertiesAction = new ShowPropertiesSynchronizeAction(Policy.bind("SyncAction.properties"), configuration);
            propertiesAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Show Property"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)propertiesAction);
            EditConflictsSynchronizeAction conflictsAction = new EditConflictsSynchronizeAction(Policy.bind("SyncAction.conflicts"), configuration);
            conflictsAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Edit Conflicts"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)conflictsAction);
            ResolveSynchronizeAction resolveAction = new ResolveSynchronizeAction(Policy.bind("SyncAction.resolve"), configuration);
            resolveAction.setImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("Menu Resolve"));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", SVNSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_1, (IAction)resolveAction);
            Viewer viewer = configuration.getPage().getViewer();
            if (viewer instanceof AbstractTreeViewer) {
                this.expandAllAction = new Action(this, null, SVNUIPlugin.getPlugin().getImageDescriptor("clcl16/expandall.gif"), viewer){
                    final /* synthetic */ SVNParticipantActionGroup this$1;
                    private final /* synthetic */ Viewer val$viewer;
                    {
                        this.this$1 = sVNParticipantActionGroup;
                        this.val$viewer = viewer;
                    }

                    public void run() {
                        this.val$viewer.getControl().setRedraw(false);
                        ((AbstractTreeViewer)this.val$viewer).expandToLevel(this.val$viewer.getInput(), -1);
                        this.val$viewer.getControl().setRedraw(true);
                    }
                };
                this.expandAllAction.setToolTipText(Policy.bind("SyncAction.expandAllTooltip"));
                this.expandAllAction.setHoverImageDescriptor(SVNUIPlugin.getPlugin().getImageDescriptor("clcl16/expandall.gif"));
            }
        }

        public void fillActionBars(IActionBars actionBars) {
            IToolBarManager manager = actionBars.getToolBarManager();
            this.appendToGroup((IContributionManager)manager, "navigate", (IAction)this.expandAllAction);
        }
    }
}

