/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.rubypeople.rdt.internal.debug.core.RdtDebugCorePlugin;
import org.rubypeople.rdt.internal.debug.core.model.RubyStackFrame;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.ui.rubyeditor.ExternalRubyFileEditorInput;

public class RubySourceLocator
implements IPersistableSourceLocator,
ISourcePresentation {
    private String absoluteWorkingDirectory;

    public String getAbsoluteWorkingDirectory() {
        return this.absoluteWorkingDirectory;
    }

    public String getMemento() throws CoreException {
        return null;
    }

    public void initializeFromMemento(String string) throws CoreException {
    }

    public void initializeDefaults(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        this.absoluteWorkingDirectory = iLaunchConfiguration.getAttribute("org.rubypeople.rdt.launching.WORKING_DIRECTORY", "");
    }

    public Object getSourceElement(IStackFrame iStackFrame) {
        return this.getSourceElement(((RubyStackFrame)iStackFrame).getFileName());
    }

    public Object getSourceElement(String string) {
        return new SourceElement(string, this);
    }

    public String getEditorId(IEditorInput iEditorInput, Object object) {
        SourceElement sourceElement = (SourceElement)object;
        return sourceElement.isExternal() ? "org.rubypeople.rdt.ui.ExternalRubyEditor" : "org.rubypeople.rdt.ui.EditorRubyFile";
    }

    public IEditorInput getEditorInput(Object object) {
        SourceElement sourceElement = (SourceElement)object;
        if (!sourceElement.isExternal()) {
            return new FileEditorInput(sourceElement.getWorkspaceFile());
        }
        File file = new File(sourceElement.getFilename());
        if (file.exists()) {
            return new ExternalRubyFileEditorInput(file);
        }
        file = new File(String.valueOf(this.absoluteWorkingDirectory) + File.separator + sourceElement.getFilename());
        if (file.exists()) {
            return new ExternalRubyFileEditorInput(file);
        }
        RdtDebugCorePlugin.log((int)1, (String)RdtDebugUiMessages.getFormattedString("RdtDebugUiPlugin.couldNotOpenFile", sourceElement.getFilename()));
        return null;
    }

    public class SourceElement {
        private String filename;
        private IFile workspaceFile;

        public SourceElement(String string, RubySourceLocator rubySourceLocator2) {
            this.filename = string;
            this.workspaceFile = RdtDebugCorePlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.filename));
            if (this.workspaceFile == null) {
                this.workspaceFile = RdtDebugCorePlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(String.valueOf(rubySourceLocator2.getAbsoluteWorkingDirectory()) + "/" + this.filename));
                if (this.workspaceFile != null && !this.workspaceFile.exists()) {
                    this.workspaceFile = null;
                }
            }
        }

        public boolean isExternal() {
            return this.workspaceFile == null;
        }

        public IFile getWorkspaceFile() {
            return this.workspaceFile;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

