/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.ant.IvyPostResolveTask;
import fr.jayasoft.ivy.report.ArtifactDownloadReport;
import fr.jayasoft.ivy.report.ConfigurationResolveReport;
import fr.jayasoft.ivy.report.ResolveReport;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.xml.XmlReportParser;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;

public abstract class IvyCacheTask
extends IvyPostResolveTask {
    protected List getArtifacts() throws BuildException, ParseException, IOException {
        Collection artifacts = this.getAllArtifacts();
        ArrayList<Artifact> ret = new ArrayList<Artifact>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (!this.getArtifactFilter().accept(artifact)) continue;
            ret.add(artifact);
        }
        return ret;
    }

    private Collection getAllArtifacts() throws ParseException, IOException {
        String[] confs = this.splitConfs(this.getConf());
        LinkedHashSet<Artifact> all = new LinkedHashSet<Artifact>();
        ResolveReport report = this.getResolvedReport();
        if (report != null) {
            Message.debug("using internal report instance to get artifacts list");
            for (int i = 0; i < confs.length; ++i) {
                ConfigurationResolveReport configurationReport = report.getConfigurationReport(confs[i]);
                if (configurationReport == null) {
                    throw new BuildException("bad confs provided: " + confs[i] + " not found among " + Arrays.asList(report.getConfigurations()));
                }
                Set revisions = configurationReport.getModuleRevisionIds();
                Iterator it = revisions.iterator();
                while (it.hasNext()) {
                    ModuleRevisionId revId = (ModuleRevisionId)it.next();
                    ArtifactDownloadReport[] aReps = configurationReport.getDownloadReports(revId);
                    for (int j = 0; j < aReps.length; ++j) {
                        all.add(aReps[j].getArtifact());
                    }
                }
            }
        } else {
            Message.debug("using stored report to get artifacts list");
            XmlReportParser parser = new XmlReportParser();
            for (int i = 0; i < confs.length; ++i) {
                Artifact[] artifacts = parser.getArtifacts(this.getResolvedModuleId(), confs[i], this.getCache());
                all.addAll(Arrays.asList(artifacts));
            }
        }
        return all;
    }
}

