/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.ui.provider.NotifyChangedToViewerRefresh;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class AdapterFactoryContentProvider
implements ITreeContentProvider,
IPropertySourceProvider,
INotifyChangedListener {
    protected AdapterFactory adapterFactory;
    protected Viewer viewer;
    protected ViewerRefresh viewerRefresh;
    private static final Class IStructuredItemContentProviderClass;
    private static final Class ITreeItemContentProviderClass;
    private static final Class IItemPropertySourceClass;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.IStructuredItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IStructuredItemContentProviderClass = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemContentProviderClass = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.emf.edit.provider.IItemPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IItemPropertySourceClass = clazz3;
    }

    public AdapterFactoryContentProvider(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        if (adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)adapterFactory).addListener((INotifyChangedListener)this);
        }
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        if (this.adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)this.adapterFactory).removeListener((INotifyChangedListener)this);
        }
        if (adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)adapterFactory).addListener((INotifyChangedListener)this);
        }
        this.adapterFactory = adapterFactory;
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
    }

    public Object[] getElements(Object object) {
        IStructuredItemContentProvider structuredItemContentProvider = (IStructuredItemContentProvider)this.adapterFactory.adapt(object, (Object)IStructuredItemContentProviderClass);
        return (structuredItemContentProvider != null ? structuredItemContentProvider.getElements(object) : Collections.EMPTY_LIST).toArray();
    }

    public Object[] getChildren(Object object) {
        ITreeItemContentProvider treeItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt(object, (Object)ITreeItemContentProviderClass);
        return (treeItemContentProvider != null ? treeItemContentProvider.getChildren(object) : Collections.EMPTY_LIST).toArray();
    }

    public boolean hasChildren(Object object) {
        ITreeItemContentProvider treeItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt(object, (Object)ITreeItemContentProviderClass);
        return treeItemContentProvider != null && treeItemContentProvider.hasChildren(object);
    }

    public Object getParent(Object object) {
        ITreeItemContentProvider treeItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt(object, (Object)ITreeItemContentProviderClass);
        return treeItemContentProvider != null ? treeItemContentProvider.getParent(object) : null;
    }

    public void dispose() {
        if (this.adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)this.adapterFactory).removeListener((INotifyChangedListener)this);
        }
        this.viewer = null;
    }

    public IPropertySource getPropertySource(Object object) {
        if (object instanceof IPropertySource) {
            return (IPropertySource)object;
        }
        IItemPropertySource itemPropertySource = (IItemPropertySource)(object instanceof EObject && ((EObject)object).eClass() == null ? null : this.adapterFactory.adapt(object, (Object)IItemPropertySourceClass));
        return itemPropertySource != null ? this.createPropertySource(object, itemPropertySource) : null;
    }

    protected IPropertySource createPropertySource(Object object, IItemPropertySource itemPropertySource) {
        return new PropertySource(object, itemPropertySource);
    }

    public void notifyChanged(Notification notification) {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            if (notification instanceof IViewerNotification) {
                if (this.viewerRefresh == null) {
                    this.viewerRefresh = new ViewerRefresh(this.viewer);
                }
                if (this.viewerRefresh.addNotification((IViewerNotification)notification)) {
                    this.viewer.getControl().getDisplay().asyncExec((Runnable)this.viewerRefresh);
                }
            } else {
                NotifyChangedToViewerRefresh.handleNotifyChanged(this.viewer, notification.getNotifier(), notification.getEventType(), notification.getFeature(), notification.getOldValue(), notification.getNewValue(), notification.getPosition());
            }
        }
    }

    public static class ViewerRefresh
    implements Runnable {
        Viewer viewer;
        List notifications;
        boolean compatibility;

        public ViewerRefresh(Viewer viewer) {
            this.viewer = viewer;
        }

        public ViewerRefresh(Viewer viewer, IViewerNotification notification) {
            this.viewer = viewer;
            this.addNotification(notification);
            this.compatibility = true;
        }

        public synchronized boolean addNotification(IViewerNotification notification) {
            if (this.notifications == null) {
                this.notifications = new ArrayList();
            }
            if (this.notifications.isEmpty()) {
                this.notifications.add(notification);
                return true;
            }
            if (this.viewer instanceof StructuredViewer) {
                Iterator i = this.notifications.iterator();
                while (i.hasNext() && notification != null) {
                    IViewerNotification old = (IViewerNotification)i.next();
                    IViewerNotification merged = this.merge(old, notification);
                    if (merged == old) {
                        notification = null;
                        continue;
                    }
                    if (merged == null) continue;
                    notification = merged;
                    i.remove();
                }
                if (notification != null) {
                    this.notifications.add(notification);
                }
            }
            return false;
        }

        protected IViewerNotification merge(IViewerNotification n1, IViewerNotification n2) {
            if (n1.getElement() == null && n1.isLabelUpdate()) {
                return n1;
            }
            if (n2.getElement() == null && n2.isLabelUpdate()) {
                return n2;
            }
            if (n1.getElement() == null) {
                if (n2.isLabelUpdate()) {
                    n1 = new ViewerNotification((Notification)n1);
                }
                return n1;
            }
            if (n2.getElement() == null) {
                if (n1.isLabelUpdate()) {
                    n2 = new ViewerNotification((Notification)n2);
                }
                return n2;
            }
            if (n1.getElement() == n2.getElement()) {
                if (n1.isContentRefresh() && n1.isLabelUpdate()) {
                    return n1;
                }
                if (n2.isContentRefresh() && n2.isLabelUpdate()) {
                    return n2;
                }
                if (n1.isContentRefresh()) {
                    if (n2.isLabelUpdate()) {
                        n1 = new ViewerNotification((Notification)n1, n1.getElement(), true, true);
                    }
                    return n1;
                }
                if (n2.isContentRefresh()) {
                    if (n1.isLabelUpdate()) {
                        n2 = new ViewerNotification((Notification)n2, n2.getElement(), true, true);
                    }
                    return n2;
                }
                if (n1.isLabelUpdate()) {
                    return n1;
                }
                return n2;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
                List current;
                ViewerRefresh viewerRefresh = this;
                synchronized (viewerRefresh) {
                    current = this.notifications;
                    this.notifications = null;
                }
                if (current != null) {
                    Iterator i = current.iterator();
                    while (i.hasNext()) {
                        this.refresh((IViewerNotification)i.next());
                    }
                }
            }
        }

        protected void refresh(IViewerNotification notification) {
            if (this.compatibility && notification.getEventType() == 9) {
                return;
            }
            Object element = notification.getElement();
            if (this.viewer instanceof StructuredViewer) {
                StructuredViewer structuredViewer = (StructuredViewer)this.viewer;
                if (element != null) {
                    if (notification.isContentRefresh()) {
                        structuredViewer.refresh(element, notification.isLabelUpdate());
                    } else if (notification.isLabelUpdate()) {
                        structuredViewer.update(element, null);
                    }
                } else {
                    structuredViewer.refresh(notification.isLabelUpdate());
                }
            } else {
                this.viewer.refresh();
            }
        }
    }
}

