/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.leveldb;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.CRC32;
import org.apache.activemq.leveldb.LevelDBClient$;
import org.apache.activemq.leveldb.RecordLog$;
import org.apache.activemq.leveldb.RecordLog$LogReader$;
import org.apache.activemq.leveldb.RecordLog$log_mutex$;
import org.apache.activemq.leveldb.util.FileSupport$;
import org.apache.activemq.leveldb.util.TimeMetric;
import org.apache.activemq.util.LRUCache;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.BufferEditor;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtdispatch.BaseRetained;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0011ew!B\u0001\u0003\u0011\u000bY\u0011!\u0003*fG>\u0014H\rT8h\u0015\t\u0019A!A\u0004mKZ,G\u000e\u001a2\u000b\u0005\u00151\u0011\u0001C1di&4X-\\9\u000b\u0005\u001dA\u0011AB1qC\u000eDWMC\u0001\n\u0003\ry'oZ\u0002\u0001!\taQ\"D\u0001\u0003\r\u0015q!\u0001#\u0002\u0010\u0005%\u0011VmY8sI2{wmE\u0003\u000e!aqB\u0005\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005!A.\u00198h\u0015\u0005)\u0012\u0001\u00026bm\u0006L!a\u0006\n\u0003\r=\u0013'.Z2u!\tIB$D\u0001\u001b\u0015\tY\"!\u0001\u0003vi&d\u0017BA\u000f\u001b\u0005\raun\u001a\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0005\u0002 K%\u0011a\u0005\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006Q5!\t!K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-AqaK\u0007C\u0002\u0013\u0005A&A\tM\u001f\u001e{\u0006*R!E\u000bJ{\u0006KU#G\u0013b+\u0012!\f\t\u0003?9J!a\f\u0011\u0003\t\tKH/\u001a\u0005\u0007c5\u0001\u000b\u0011B\u0017\u0002%1{ui\u0018%F\u0003\u0012+%k\u0018)S\u000b\u001aK\u0005\f\t\u0005\bg5\u0011\r\u0011\"\u0001-\u00039)vjV0F\u001d\u0012{&+R\"P%\u0012Ca!N\u0007!\u0002\u0013i\u0013aD+P/~+e\nR0S\u000b\u000e{%\u000b\u0012\u0011\t\u000f]j!\u0019!C\u0001q\u0005yAjT$`\u0011\u0016\u000bE)\u0012*`'&SV)F\u0001:!\ty\"(\u0003\u0002<A\t\u0019\u0011J\u001c;\t\ruj\u0001\u0015!\u0003:\u0003AaujR0I\u000b\u0006#UIU0T\u0013j+\u0005\u0005C\u0004@\u001b\t\u0007I\u0011\u0001\u001d\u0002\u0017\t+fIR#S?NK%,\u0012\u0005\u0007\u00036\u0001\u000b\u0011B\u001d\u0002\u0019\t+fIR#S?NK%,\u0012\u0011\t\u000f\rk!\u0019!C\u0001q\u0005\u0011\")\u0017)B'N{&)\u0016$G\u000bJ{6+\u0013.F\u0011\u0019)U\u0002)A\u0005s\u0005\u0019\")\u0017)B'N{&)\u0016$G\u000bJ{6+\u0013.FA\u0019!q)\u0004!I\u0005\u001daunZ%oM>\u001cRA\u0012\t\u001f\u0013\u0012\u0002\"a\b&\n\u0005-\u0003#a\u0002)s_\u0012,8\r\u001e\u0005\t\u001b\u001a\u0013)\u001a!C\u0001\u001d\u0006!a-\u001b7f+\u0005y\u0005C\u0001)T\u001b\u0005\t&B\u0001*\u0015\u0003\tIw.\u0003\u0002U#\n!a)\u001b7f\u0011!1fI!E!\u0002\u0013y\u0015!\u00024jY\u0016\u0004\u0003\u0002\u0003-G\u0005+\u0007I\u0011A-\u0002\u0011A|7/\u001b;j_:,\u0012A\u0017\t\u0003?mK!\u0001\u0018\u0011\u0003\t1{gn\u001a\u0005\t=\u001a\u0013\t\u0012)A\u00055\u0006I\u0001o\\:ji&|g\u000e\t\u0005\tA\u001a\u0013)\u001a!C\u00013\u00061A.\u001a8hi\"D\u0001B\u0019$\u0003\u0012\u0003\u0006IAW\u0001\bY\u0016tw\r\u001e5!\u0011\u0015Ac\t\"\u0001e)\u0011)w\r[5\u0011\u0005\u00194U\"A\u0007\t\u000b5\u001b\u0007\u0019A(\t\u000ba\u001b\u0007\u0019\u0001.\t\u000b\u0001\u001c\u0007\u0019\u0001.\t\u000b-4E\u0011A-\u0002\u000b1LW.\u001b;\t\u000f54\u0015\u0011!C\u0001]\u0006!1m\u001c9z)\u0011)w\u000e]9\t\u000f5c\u0007\u0013!a\u0001\u001f\"9\u0001\f\u001cI\u0001\u0002\u0004Q\u0006b\u00021m!\u0003\u0005\rA\u0017\u0005\bg\u001a\u000b\n\u0011\"\u0001u\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012!\u001e\u0016\u0003\u001fZ\\\u0013a\u001e\t\u0003qvl\u0011!\u001f\u0006\u0003un\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005q\u0004\u0013AC1o]>$\u0018\r^5p]&\u0011a0\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u0001\rF\u0005I\u0011AA\u0002\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\u0002+\u0005i3\b\"CA\u0005\rF\u0005I\u0011AA\u0002\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIMBq!!\u0004G\t\u0003\ny!\u0001\u0005iCND7i\u001c3f)\u0005I\u0004bBA\n\r\u0012\u0005\u0013QC\u0001\ti>\u001cFO]5oOR\u0011\u0011q\u0003\t\u0005\u00033\tyBD\u0002 \u00037I1!!\b!\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011EA\u0012\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0004\u0011\t\u000f\u0005\u001db\t\"\u0011\u0002*\u00051Q-];bYN$B!a\u000b\u00022A\u0019q$!\f\n\u0007\u0005=\u0002EA\u0004C_>dW-\u00198\t\u0015\u0005M\u0012QEA\u0001\u0002\u0004\t)$A\u0002yIE\u00022aHA\u001c\u0013\r\tI\u0004\t\u0002\u0004\u0003:L\bbBA\u001f\r\u0012\u0005\u0013qH\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0005\u0003cA\t\u0002D%\u0019\u0011\u0011\u0005\n\t\r\u0005\u001dc\t\"\u00119\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011\u001d\tYE\u0012C!\u0003\u001b\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00026\u0005=\u0003\"CA\u001a\u0003\u0013\n\t\u00111\u0001:\u0011\u001d\t\u0019F\u0012C!\u0003+\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003W\t9\u0006\u0003\u0006\u00024\u0005E\u0013\u0011!a\u0001\u0003k9\u0011\"a\u0017\u000e\u0003\u0003E)!!\u0018\u0002\u000f1{w-\u00138g_B\u0019a-a\u0018\u0007\u0011\u001dk\u0011\u0011!E\u0003\u0003C\u001ab!a\u0018\u0002dy!\u0003\u0003CA3\u0003Wz%LW3\u000e\u0005\u0005\u001d$bAA5A\u00059!/\u001e8uS6,\u0017\u0002BA7\u0003O\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84\u0011\u001dA\u0013q\fC\u0001\u0003c\"\"!!\u0018\t\u0011\u0005M\u0011q\fC#\u0003k\"\"!!\u0011\t\u0015\u0005e\u0014qLA\u0001\n\u0003\u000bY(A\u0003baBd\u0017\u0010F\u0004f\u0003{\ny(!!\t\r5\u000b9\b1\u0001P\u0011\u0019A\u0016q\u000fa\u00015\"1\u0001-a\u001eA\u0002iC!\"!\"\u0002`\u0005\u0005I\u0011QAD\u0003\u001d)h.\u00199qYf$B!!#\u0002\u0016B)q$a#\u0002\u0010&\u0019\u0011Q\u0012\u0011\u0003\r=\u0003H/[8o!\u0019y\u0012\u0011S([5&\u0019\u00111\u0013\u0011\u0003\rQ+\b\u000f\\34\u0011\u001d\t9*a!A\u0002\u0015\f1\u0001\u001f\u00131\u0011!\tY*a\u0018\u0005\u0012\u0005u\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\u0012\u0001\u0005\u0005\b\u0003CkA\u0011AAR\u0003-)gnY8eK~cwN\\4\u0015\t\u0005\u0015\u0016Q\u0017\t\u0005\u0003O\u000b\t,\u0004\u0002\u0002**!\u00111VAW\u0003\u001dA\u0017m\u001e;ck\u001aT1!a,\t\u0003)1Wo]3t_V\u00148-Z\u0005\u0005\u0003g\u000bIK\u0001\u0004Ck\u001a4WM\u001d\u0005\b\u0003o\u000by\n1\u0001[\u0003\t\t\u0017\u0007C\u0004\u0002<6!\t!!0\u0002\u0017\u0011,7m\u001c3f?2|gn\u001a\u000b\u00045\u0006}\u0006\u0002CAa\u0003s\u0003\r!!*\u0002\u000bY\fG.^3\t\u0013\u0005\u0015Wb1A\u0005\u0002\u0005\u001d\u0017A\u0005\u0013f]\u0006\u0014G.Z0bgN,'\u000f^5p]N,\"!a\u000b\t\u0011\u0005-W\u0002)A\u0005\u0003W\t1\u0003J3oC\ndWmX1tg\u0016\u0014H/[8og\u0002B\u0011\"!\u001f\u000e\u0003\u0003%\t)a4\u0015\r\u0005EG\u0011\u001aCf!\ra\u00111\u001b\u0004\u0006\u001d\t\u0001\u0015Q[\n\u0007\u0003'\u0004b$\u0013\u0013\t\u0015\u0005e\u00171\u001bBK\u0002\u0013\u0005a*A\u0005eSJ,7\r^8ss\"Q\u0011Q\\Aj\u0005#\u0005\u000b\u0011B(\u0002\u0015\u0011L'/Z2u_JL\b\u0005C\u0006\u0002b\u0006M'Q3A\u0005\u0002\u0005\r\u0018!\u00037pON+hMZ5y+\t\t9\u0002C\u0006\u0002h\u0006M'\u0011#Q\u0001\n\u0005]\u0011A\u00037pON+hMZ5yA!9\u0001&a5\u0005\u0002\u0005-HCBAi\u0003[\fy\u000fC\u0004\u0002Z\u0006%\b\u0019A(\t\u0011\u0005\u0005\u0018\u0011\u001ea\u0001\u0003/A\u0011\"a=\u0002T\u0002\u0007I\u0011A-\u0002\u000f1|wmU5{K\"Q\u0011q_Aj\u0001\u0004%\t!!?\u0002\u00171|wmU5{K~#S-\u001d\u000b\u0005\u0003w\u0014\t\u0001E\u0002 \u0003{L1!a@!\u0005\u0011)f.\u001b;\t\u0013\u0005M\u0012Q_A\u0001\u0002\u0004Q\u0006\u0002\u0003B\u0003\u0003'\u0004\u000b\u0015\u0002.\u0002\u00111|wmU5{K\u0002B!B!\u0003\u0002T\u0002\u0007I\u0011\u0001B\u0006\u0003A\u0019WO\u001d:f]R|\u0016\r\u001d9f]\u0012,'/\u0006\u0002\u0003\u000eA!!q\u0002B\t\u001b\t\t\u0019NB\u0004\u0003\u0014\u0005M\u0007A!\u0006\u0003\u00171{w-\u00119qK:$WM]\n\u0006\u0005#\u00119B\b\t\u0005\u0005\u001f\u0011IBB\u0004\u0003\u001c\u0005M\u0007I!\b\u0003\u00131{wMU3bI\u0016\u00148c\u0002B\r\u0005?q\u0012\n\n\t\u0005\u0005C\u00119#\u0004\u0002\u0003$)!!QEAW\u00031A\u0017m\u001e;eSN\u0004\u0018\r^2i\u0013\u0011\u0011ICa\t\u0003\u0019\t\u000b7/\u001a*fi\u0006Lg.\u001a3\t\u00135\u0013IB!f\u0001\n\u0003q\u0005\"\u0003,\u0003\u001a\tE\t\u0015!\u0003P\u0011%A&\u0011\u0004BK\u0002\u0013\u0005\u0011\fC\u0005_\u00053\u0011\t\u0012)A\u00055\"9\u0001F!\u0007\u0005\u0002\tUBC\u0002B\f\u0005o\u0011I\u0004\u0003\u0004N\u0005g\u0001\ra\u0014\u0005\u00071\nM\u0002\u0019\u0001.\t\u0011\tu\"\u0011\u0004C\u0001\u0005\u007f\tAa\u001c9f]V\u0011!\u0011\t\t\u0004!\n\r\u0013b\u0001B##\n\u0001\"+\u00198e_6\f5mY3tg\u001aKG.\u001a\u0005\u000b\u0005\u0013\u0012IB1A\u0005\u0002\t}\u0012A\u00014e\u0011%\u0011iE!\u0007!\u0002\u0013\u0011\t%A\u0002gI\u0002B!B!\u0015\u0003\u001a\t\u0007I\u0011\u0001B*\u0003\u001d\u0019\u0007.\u00198oK2,\"A!\u0016\u0011\t\t]#\u0011M\u0007\u0003\u00053RAAa\u0017\u0003^\u0005A1\r[1o]\u0016d7OC\u0002\u0003`Q\t1A\\5p\u0013\u0011\u0011\u0019G!\u0017\u0003\u0017\u0019KG.Z\"iC:tW\r\u001c\u0005\n\u0005O\u0012I\u0002)A\u0005\u0005+\n\u0001b\u00195b]:,G\u000e\t\u0005\t\u0005W\u0012I\u0002\"\u0011\u0003n\u00059A-[:q_N,GCAA~\u0011!\u0011\tH!\u0007\u0005\u0002\tM\u0014\u0001E2iK\u000e\\wL]3bI~3G.^:i)\u0011\tYP!\u001e\t\u000f\t]$q\u000ea\u00015\u0006QQM\u001c3`_\u001a47/\u001a;\t\u0011\tm$\u0011\u0004C\u0001\u0005{\nAA]3bIR1\u0011Q\u0015B@\u0005\u0007CqA!!\u0003z\u0001\u0007!,A\bsK\u000e|'\u000fZ0q_NLG/[8o\u0011\u0019\u0001'\u0011\u0010a\u0001s!A!1\u0010B\r\t\u0003\u00119\t\u0006\u0003\u0003\n\n-\u0005cB\u0010\u0002\u00126\n)K\u0017\u0005\b\u0005\u0003\u0013)\t1\u0001[\u0011!\u0011yI!\u0007\u0005\u0002\tE\u0015!B2iK\u000e\\G\u0003\u0002BJ\u0005;\u0003RaHAF\u0005+\u0003ba\bBL5\nm\u0015b\u0001BMA\t1A+\u001e9mKJ\u0002BaHAF5\"9!\u0011\u0011BG\u0001\u0004Q\u0006b\u0002BQ\u00053!\t!W\u0001\u0018m\u0016\u0014\u0018NZ=B]\u0012<U\r^#oIB{7/\u001b;j_:D\u0011\"\u001cB\r\u0003\u0003%\tA!*\u0015\r\t]!q\u0015BU\u0011!i%1\u0015I\u0001\u0002\u0004y\u0005\u0002\u0003-\u0003$B\u0005\t\u0019\u0001.\t\u0011M\u0014I\"%A\u0005\u0002QD!\"!\u0001\u0003\u001aE\u0005I\u0011AA\u0002\u0011!\tiA!\u0007\u0005B\u0005=\u0001\u0002CA\n\u00053!\t%!\u0006\t\u0011\u0005\u001d\"\u0011\u0004C!\u0005k#B!a\u000b\u00038\"Q\u00111\u0007BZ\u0003\u0003\u0005\r!!\u000e\t\u0011\u0005u\"\u0011\u0004C!\u0003\u007fAq!a\u0012\u0003\u001a\u0011\u0005\u0003\b\u0003\u0005\u0002L\teA\u0011\tB`)\u0011\t)D!1\t\u0013\u0005M\"QXA\u0001\u0002\u0004I\u0004\u0002CA*\u00053!\tE!2\u0015\t\u0005-\"q\u0019\u0005\u000b\u0003g\u0011\u0019-!AA\u0002\u0005U\u0002bC'\u0003\u0012\t\u0005\t\u0015!\u0003P\u0005WA1\u0002\u0017B\t\u0005\u0003\u0005\u000b\u0011\u0002.\u00030!9\u0001F!\u0005\u0005\u0002\t=GC\u0002B\u0007\u0005#\u0014\u0019\u000e\u0003\u0004N\u0005\u001b\u0004\ra\u0014\u0005\u00071\n5\u0007\u0019\u0001.\t\u0015\t]'\u0011\u0003b\u0001\n\u0003\u0011I.\u0001\u0003j]\u001a|WC\u0001Bn!\r\u0011iN\u0012\b\u0003\u0019\u0001A\u0011B!9\u0003\u0012\u0001\u0006IAa7\u0002\u000b%tgm\u001c\u0011\t\u0011\tu\"\u0011\u0003C!\u0005\u007fA\u0001Ba\u001b\u0003\u0012\u0011\u0005#Q\u000e\u0005\n\u0005S\u0014\t\u00021A\u0005\u0002e\u000bQ\"\u00199qK:$wl\u001c4gg\u0016$\bB\u0003Bw\u0005#\u0001\r\u0011\"\u0001\u0003p\u0006\t\u0012\r\u001d9f]\u0012|vN\u001a4tKR|F%Z9\u0015\t\u0005m(\u0011\u001f\u0005\n\u0003g\u0011Y/!AA\u0002iC\u0001B!>\u0003\u0012\u0001\u0006KAW\u0001\u000fCB\u0004XM\u001c3`_\u001a47/\u001a;!\u0011)\u0011IP!\u0005C\u0002\u0013\u0005!1`\u0001\u000fM2,8\u000f[3e?>4gm]3u+\t\u0011i\u0010\u0005\u0003\u0003\u0000\u000e-QBAB\u0001\u0015\u0011\u0019\u0019a!\u0002\u0002\r\u0005$x.\\5d\u0015\u0011\u00199a!\u0003\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002\u001c)%!1QBB\u0001\u0005)\tEo\\7jG2{gn\u001a\u0005\n\u0007#\u0011\t\u0002)A\u0005\u0005{\fqB\u001a7vg\",GmX8gMN,G\u000f\t\u0005\b\u0007+\u0011\t\u0002\"\u0001Z\u0003=\t\u0007\u000f]3oI~\u0003xn]5uS>t\u0007BCB\r\u0005#\u0011\r\u0011\"\u0001\u0004\u001c\u0005aqO]5uK~\u0013WO\u001a4feV\u00111Q\u0004\t\u0005\u0003O\u001by\"\u0003\u0003\u0004\"\u0005%&!\u0007#bi\u0006\u0014\u0015\u0010^3BeJ\f\u0017pT;uaV$8\u000b\u001e:fC6D\u0011b!\n\u0003\u0012\u0001\u0006Ia!\b\u0002\u001b]\u0014\u0018\u000e^3`EV4g-\u001a:!\u0011!\u0019IC!\u0005\u0005\u0002\r-\u0012!\u00024pe\u000e,WCAA~\u0011!\u0019yC!\u0005\u0005\u0002\rE\u0012AB1qa\u0016tG\r\u0006\u0004\u00044\rU2\u0011\b\t\u0007?\t]%La7\t\u000f\r]2Q\u0006a\u0001[\u0005\u0011\u0011\u000e\u001a\u0005\t\u0007w\u0019i\u00031\u0001\u0002&\u0006!A-\u0019;b\u0011!\u0019yD!\u0005\u0005\u0002\r-\u0012!\u00024mkND\u0007\u0002\u0003B9\u0005#!\tea\u0011\u0015\t\u0005m8Q\t\u0005\b\u0005o\u001a\t\u00051\u0001[\u0011)\u0019I%a5A\u0002\u0013\u000511J\u0001\u0015GV\u0014(/\u001a8u?\u0006\u0004\b/\u001a8eKJ|F%Z9\u0015\t\u0005m8Q\n\u0005\u000b\u0003g\u00199%!AA\u0002\t5\u0001\"CB)\u0003'\u0004\u000b\u0015\u0002B\u0007\u0003E\u0019WO\u001d:f]R|\u0016\r\u001d9f]\u0012,'\u000f\t\u0005\u000b\u0007+\n\u0019\u000e1A\u0005\u0002\u0005\u001d\u0017\u0001\u0005<fe&4\u0017pX2iK\u000e\\7/^7t\u0011)\u0019I&a5A\u0002\u0013\u000511L\u0001\u0015m\u0016\u0014\u0018NZ=`G\",7m[:v[N|F%Z9\u0015\t\u0005m8Q\f\u0005\u000b\u0003g\u00199&!AA\u0002\u0005-\u0002\"CB1\u0003'\u0004\u000b\u0015BA\u0016\u0003E1XM]5gs~\u001b\u0007.Z2lgVl7\u000f\t\u0005\u000b\u0007K\n\u0019\u000e1A\u0005\u0002\u0005\u001d\u0017\u0001B:z]\u000eD!b!\u001b\u0002T\u0002\u0007I\u0011AB6\u0003!\u0019\u0018P\\2`I\u0015\fH\u0003BA~\u0007[B!\"a\r\u0004h\u0005\u0005\t\u0019AA\u0016\u0011%\u0019\t(a5!B\u0013\tY#A\u0003ts:\u001c\u0007\u0005\u0003\u0006\u0004v\u0005M'\u0019!C\u0001\u0007o\n\u0011\u0002\\8h?&tgm\\:\u0016\u0005\re\u0004cBB>\u0007{R&1\\\u0007\u0003\u0007\u0013IAaa \u0004\n\t9AK]3f\u001b\u0006\u0004\b\"CBB\u0003'\u0004\u000b\u0011BB=\u0003)awnZ0j]\u001a|7\u000fI\u0004\t\u0007\u000f\u000b\u0019\u000e#\u0002\u0004\n\u0006IAn\\4`[V$X\r\u001f\t\u0005\u0005\u001f\u0019YI\u0002\u0005\u0004\u000e\u0006M\u0007RABH\u0005%awnZ0nkR,\u0007p\u0005\u0003\u0004\fBq\u0002b\u0002\u0015\u0004\f\u0012\u000511\u0013\u000b\u0003\u0007\u0013C\u0001ba&\u0002T\u0012\u00051\u0011T\u0001\u0007I\u0016dW\r^3\u0015\t\u0005m81\u0014\u0005\b\u0007o\u0019)\n1\u0001[\u0011!\u0019y*a5\u0005\u0012\r\u0005\u0016\u0001C8o\t\u0016dW\r^3\u0015\t\u0005-21\u0015\u0005\u0007\u001b\u000eu\u0005\u0019A(\t\u0011\r\u001d\u00161\u001bC\u0001\u0007S\u000b\u0001b\u00195fG.\u001cX/\u001c\u000b\u0004s\r-\u0006\u0002CB\u001e\u0007K\u0003\r!!*\b\u0015\r=\u00161[A\u0001\u0012\u000b\u0019\t,A\u0005M_\u001e\u0014V-\u00193feB!!qBBZ\r)\u0011Y\"a5\u0002\u0002#\u00151QW\n\u0007\u0007g\u001b9L\b\u0013\u0011\u0011\u0005\u00154\u0011X([\u0005/IAaa/\u0002h\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000f!\u001a\u0019\f\"\u0001\u0004@R\u00111\u0011\u0017\u0005\t\u0003'\u0019\u0019\f\"\u0012\u0002v!Q\u0011\u0011PBZ\u0003\u0003%\ti!2\u0015\r\t]1qYBe\u0011\u0019i51\u0019a\u0001\u001f\"1\u0001la1A\u0002iC!\"!\"\u00044\u0006\u0005I\u0011QBg)\u0011\u0019yma5\u0011\u000b}\tYi!5\u0011\u000b}\u00119j\u0014.\t\u0011\u0005]51\u001aa\u0001\u0005/A\u0001ba6\u0002T\u0012\u00051\u0011\\\u0001\u0014GJ,\u0017\r^3`Y><w,\u00199qK:$WM\u001d\u000b\u0005\u0005\u001b\u0019Y\u000e\u0003\u0004Y\u0007+\u0004\rA\u0017\u0005\t\u0007?\f\u0019\u000e\"\u0001\u0004b\u0006y1M]3bi\u0016|\u0016\r\u001d9f]\u0012,'\u000f\u0006\u0003\u00026\r\r\bB\u0002-\u0004^\u0002\u0007!\f\u0003\u0006\u0004h\u0006M'\u0019!C\u0001\u0007S\fQ#\\1y?2|wmX<sSR,w\f\\1uK:\u001c\u00170\u0006\u0002\u0004lB\u0019\u0011d!<\n\u0007\r=(D\u0001\u0006US6,W*\u001a;sS\u000eD\u0011ba=\u0002T\u0002\u0006Iaa;\u0002-5\f\u0007p\u00187pO~;(/\u001b;f?2\fG/\u001a8ds\u0002B!ba>\u0002T\n\u0007I\u0011ABu\u0003Ui\u0017\r_0m_\u001e|f\r\\;tQ~c\u0017\r^3oGfD\u0011ba?\u0002T\u0002\u0006Iaa;\u0002-5\f\u0007p\u00187pO~3G.^:i?2\fG/\u001a8ds\u0002B!ba@\u0002T\n\u0007I\u0011ABu\u0003Yi\u0017\r_0m_\u001e|&o\u001c;bi\u0016|F.\u0019;f]\u000eL\b\"\u0003C\u0002\u0003'\u0004\u000b\u0011BBv\u0003]i\u0017\r_0m_\u001e|&o\u001c;bi\u0016|F.\u0019;f]\u000eL\b\u0005\u0003\u0005\u0003>\u0005MG\u0011\u0001C\u0004+\t\t)\u0004\u0003\u0005\u0005\f\u0005MG\u0011AB\u0016\u0003\u0015\u0019Gn\\:f\u0011\u001d!y!a5\u0005\u0002e\u000ba\"\u00199qK:$WM]0mS6LG\u000fC\u0004\u0005\u0014\u0005MG\u0011A-\u0002\u001d\u0005\u0004\b/\u001a8eKJ|6\u000f^1si\"AAqCAj\t\u0003!I\"\u0001\u0005oKb$x\f\\8h)\ryE1\u0004\u0005\u00071\u0012U\u0001\u0019\u0001.\t\u0011\u0011}\u00111\u001bC\u0001\tC\t\u0001\"\u00199qK:$WM]\u000b\u0005\tG!I\u0003\u0006\u0003\u0005&\u0011U\u0002\u0003\u0002C\u0014\tSa\u0001\u0001\u0002\u0005\u0005,\u0011u!\u0019\u0001C\u0017\u0005\u0005!\u0016\u0003\u0002C\u0018\u0003k\u00012a\bC\u0019\u0013\r!\u0019\u0004\t\u0002\b\u001d>$\b.\u001b8h\u0011!!9\u0004\"\bA\u0002\u0011e\u0012\u0001\u00024v]\u000e\u0004ra\bC\u001e\u0005\u001b!)#C\u0002\u0005>\u0001\u0012\u0011BR;oGRLwN\\\u0019\t\u0015\u0011\u0005\u00131\u001ba\u0001\n\u0003!\u0019%A\u0007p]~cwnZ0s_R\fG/Z\u000b\u0003\t\u000b\u0002Ra\bC$\u0003wL1\u0001\"\u0013!\u0005%1UO\\2uS>t\u0007\u0007\u0003\u0006\u0005N\u0005M\u0007\u0019!C\u0001\t\u001f\n\u0011c\u001c8`Y><wL]8uCR,w\fJ3r)\u0011\tY\u0010\"\u0015\t\u0015\u0005MB1JA\u0001\u0002\u0004!)\u0005C\u0005\u0005V\u0005M\u0007\u0015)\u0003\u0005F\u0005qqN\\0m_\u001e|&o\u001c;bi\u0016\u0004\u0003B\u0003C-\u0003'\u0014\r\u0011\"\u0003\u0005\\\u0005a!/Z1eKJ|6-Y2iKV\u0011AQ\f\t\b\t?\"\u0019g\u0014B\f\u001b\t!\tG\u0003\u0002\u001c\t%!AQ\rC1\u0005!a%+V\"bG\",\u0007\"\u0003C5\u0003'\u0004\u000b\u0011\u0002C/\u00035\u0011X-\u00193fe~\u001b\u0017m\u00195fA!AAQNAj\t\u0003!y'\u0001\u0005m_\u001e|\u0016N\u001c4p)\u0011!\t\bb\u001d\u0011\u000b}\tYIa7\t\u000f\u0011UD1\u000ea\u00015\u0006\u0019\u0001o\\:\t\u0011\u0011e\u00141\u001bC\u0005\tw\n!bZ3u?J,\u0017\rZ3s+\u0011!i\b\"\"\u0015\t\u0011}D1\u0012\u000b\u0005\t\u0003#9\tE\u0003 \u0003\u0017#\u0019\t\u0005\u0003\u0005(\u0011\u0015E\u0001\u0003C\u0016\to\u0012\r\u0001\"\f\t\u0011\u0011]Bq\u000fa\u0001\t\u0013\u0003ra\bC\u001e\u0005/!\u0019\tC\u0004\u0003\u0002\u0012]\u0004\u0019\u0001.\t\u0011\tm\u00141\u001bC\u0001\t\u001f#B\u0001\"%\u0005\u0014B)q$a#\u0003\n\"9AQ\u000fCG\u0001\u0004Q\u0006\u0002\u0003B>\u0003'$\t\u0001b&\u0015\r\u0011eE1\u0014CO!\u0015y\u00121RAS\u0011\u001d!)\b\"&A\u0002iCa\u0001\u0019CK\u0001\u0004I\u0004\"C7\u0002T\u0006\u0005I\u0011\u0001CQ)\u0019\t\t\u000eb)\u0005&\"I\u0011\u0011\u001cCP!\u0003\u0005\ra\u0014\u0005\u000b\u0003C$y\n%AA\u0002\u0005]\u0001\u0002C:\u0002TF\u0005I\u0011\u0001;\t\u0015\u0005\u0005\u00111[I\u0001\n\u0003!Y+\u0006\u0002\u0005.*\u001a\u0011q\u0003<\t\u0011\u00055\u00111\u001bC!\u0003\u001fA\u0001\"a\u0005\u0002T\u0012\u0005\u0013Q\u0003\u0005\t\u0003O\t\u0019\u000e\"\u0011\u00056R!\u00111\u0006C\\\u0011)\t\u0019\u0004b-\u0002\u0002\u0003\u0007\u0011Q\u0007\u0005\t\u0003{\t\u0019\u000e\"\u0011\u0002@!9\u0011qIAj\t\u0003B\u0004\u0002CA&\u0003'$\t\u0005b0\u0015\t\u0005UB\u0011\u0019\u0005\n\u0003g!i,!AA\u0002eB\u0001\"a\u0015\u0002T\u0012\u0005CQ\u0019\u000b\u0005\u0003W!9\r\u0003\u0006\u00024\u0011\r\u0017\u0011!a\u0001\u0003kAq!!7\u0002N\u0002\u0007q\n\u0003\u0005\u0002b\u00065\u0007\u0019AA\f\u0011%\t))DA\u0001\n\u0003#y\r\u0006\u0003\u0005R\u0012U\u0007#B\u0010\u0002\f\u0012M\u0007CB\u0010\u0003\u0018>\u000b9\u0002\u0003\u0005\u0002\u0018\u00125\u0007\u0019AAi\u0011\u001d\tY*\u0004C\t\u0003;\u0003")
public class RecordLog
implements ScalaObject,
Product,
Serializable {
    private final File directory;
    private final String logSuffix;
    private long logSize;
    private LogAppender current_appender;
    private boolean verify_checksums;
    private boolean sync;
    private final TreeMap<Object, LogInfo> log_infos;
    private final TimeMetric max_log_write_latency;
    private final TimeMetric max_log_flush_latency;
    private final TimeMetric max_log_rotate_latency;
    private Function0<BoxedUnit> on_log_rotate;
    private final LRUCache<File, LogReader> org$apache$activemq$leveldb$RecordLog$$reader_cache;
    private volatile RecordLog$log_mutex$ log_mutex$module;
    private volatile RecordLog$LogReader$ LogReader$module;

    public static final void trace(Throwable throwable) {
        RecordLog$.MODULE$.trace(throwable);
    }

    public static final void trace(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.trace(throwable, function0, seq);
    }

    public static final void trace(Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.trace(function0, seq);
    }

    public static final void debug(Throwable throwable) {
        RecordLog$.MODULE$.debug(throwable);
    }

    public static final void debug(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.debug(throwable, function0, seq);
    }

    public static final void debug(Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.debug(function0, seq);
    }

    public static final void info(Throwable throwable) {
        RecordLog$.MODULE$.info(throwable);
    }

    public static final void info(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.info(throwable, function0, seq);
    }

    public static final void info(Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.info(function0, seq);
    }

    public static final void warn(Throwable throwable) {
        RecordLog$.MODULE$.warn(throwable);
    }

    public static final void warn(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.warn(throwable, function0, seq);
    }

    public static final void warn(Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.warn(function0, seq);
    }

    public static final void error(Throwable throwable) {
        RecordLog$.MODULE$.error(throwable);
    }

    public static final void error(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.error(throwable, function0, seq);
    }

    public static final void error(Function0<String> function0, Seq<Object> seq) {
        RecordLog$.MODULE$.error(function0, seq);
    }

    public static final void org$apache$activemq$leveldb$util$Log$_setter_$log_$eq(Logger logger) {
        RecordLog$.MODULE$.org$apache$activemq$leveldb$util$Log$_setter_$log_$eq(logger);
    }

    public static final Logger log() {
        return RecordLog$.MODULE$.log();
    }

    public static final boolean $enable_assertions() {
        return RecordLog$.MODULE$.$enable_assertions();
    }

    public static final long decode_long(Buffer buffer) {
        return RecordLog$.MODULE$.decode_long(buffer);
    }

    public static final Buffer encode_long(long l) {
        return RecordLog$.MODULE$.encode_long(l);
    }

    public static final int BYPASS_BUFFER_SIZE() {
        return RecordLog$.MODULE$.BYPASS_BUFFER_SIZE();
    }

    public static final int BUFFER_SIZE() {
        return RecordLog$.MODULE$.BUFFER_SIZE();
    }

    public static final int LOG_HEADER_SIZE() {
        return RecordLog$.MODULE$.LOG_HEADER_SIZE();
    }

    public static final byte UOW_END_RECORD() {
        return RecordLog$.MODULE$.UOW_END_RECORD();
    }

    public static final byte LOG_HEADER_PREFIX() {
        return RecordLog$.MODULE$.LOG_HEADER_PREFIX();
    }

    public File directory() {
        return this.directory;
    }

    public String logSuffix() {
        return this.logSuffix;
    }

    public long logSize() {
        return this.logSize;
    }

    public void logSize_$eq(long l) {
        this.logSize = l;
    }

    public LogAppender current_appender() {
        return this.current_appender;
    }

    public void current_appender_$eq(LogAppender logAppender) {
        this.current_appender = logAppender;
    }

    public boolean verify_checksums() {
        return this.verify_checksums;
    }

    public void verify_checksums_$eq(boolean bl) {
        this.verify_checksums = bl;
    }

    public boolean sync() {
        return this.sync;
    }

    public void sync_$eq(boolean bl) {
        this.sync = bl;
    }

    public TreeMap<Object, LogInfo> log_infos() {
        return this.log_infos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final RecordLog$log_mutex$ log_mutex() {
        if (this.log_mutex$module != null) return this.log_mutex$module;
        RecordLog recordLog = this;
        synchronized (recordLog) {
            if (this.log_mutex$module == null) {
                this.log_mutex$module = new RecordLog$log_mutex$(this);
            }
            return this.log_mutex$module;
        }
    }

    public void delete(long id$1) {
        RecordLog$log_mutex$ recordLog$log_mutex$ = this.log_mutex();
        synchronized (recordLog$log_mutex$) {
            BoxedUnit boxedUnit;
            if (this.current_appender().position() != id$1) {
                Option$.MODULE$.apply((Object)this.log_infos().get(BoxesRunTime.boxToLong((long)id$1))).foreach((Function1)new Serializable(this, id$1){
                    public static final long serialVersionUID;
                    private final RecordLog $outer;
                    private final long id$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final LogInfo apply(LogInfo info2) {
                        this.$outer.onDelete(info2.file());
                        return this.$outer.log_infos().remove(BoxesRunTime.boxToLong((long)this.id$1));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.id$1 = l;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public boolean onDelete(File file) {
        return file.delete();
    }

    public int checksum(Buffer data) {
        CRC32 checksum = new CRC32();
        checksum.update(data.data, data.offset, data.length);
        return (int)(checksum.getValue() & 0xFFFFFFFFFFFFFFFFL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final RecordLog$LogReader$ LogReader() {
        if (this.LogReader$module != null) return this.LogReader$module;
        RecordLog recordLog = this;
        synchronized (recordLog) {
            if (this.LogReader$module == null) {
                this.LogReader$module = new RecordLog$LogReader$(this);
            }
            return this.LogReader$module;
        }
    }

    public LogAppender create_log_appender(long position) {
        return new LogAppender(this, this.next_log(position), position);
    }

    public Object create_appender(long position) {
        RecordLog$log_mutex$ recordLog$log_mutex$ = this.log_mutex();
        synchronized (recordLog$log_mutex$) {
            Object object = this.current_appender() == null ? BoxedUnit.UNIT : this.log_infos().put(BoxesRunTime.boxToLong((long)position), new LogInfo(this.current_appender().file(), this.current_appender().position(), this.current_appender().append_offset()));
            this.current_appender_$eq(this.create_log_appender(position));
            LogInfo logInfo = this.log_infos().put(BoxesRunTime.boxToLong((long)position), new LogInfo(this.current_appender().file(), position, 0L));
            return logInfo;
        }
    }

    public TimeMetric max_log_write_latency() {
        return this.max_log_write_latency;
    }

    public TimeMetric max_log_flush_latency() {
        return this.max_log_flush_latency;
    }

    public TimeMetric max_log_rotate_latency() {
        return this.max_log_rotate_latency;
    }

    public Object open() {
        RecordLog$log_mutex$ recordLog$log_mutex$ = this.log_mutex();
        synchronized (recordLog$log_mutex$) {
            long l;
            this.log_infos().clear();
            LevelDBClient$.MODULE$.find_sequence_files(this.directory(), this.logSuffix()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final RecordLog $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final LogInfo apply(Tuple2<Object, File> tuple2) {
                    Tuple2<Object, File> tuple22 = tuple2;
                    if (tuple22 != null) {
                        long l = BoxesRunTime.unboxToLong((Object)tuple22._1());
                        File file = (File)tuple22._2();
                        long position = l;
                        File file2 = file;
                        return this.$outer.log_infos().put(BoxesRunTime.boxToLong((long)position), new LogInfo(file2, position, file2.length()));
                    }
                    throw new MatchError(tuple22);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            if (this.log_infos().isEmpty()) {
                l = 0L;
            } else {
                LogInfo file$3 = this.log_infos().lastEntry().getValue();
                LogReader r$1 = new LogReader(this, file$3.file(), file$3.position());
                l = this.liftedTree1$1(file$3, r$1);
            }
            long appendPos = l;
            Object object = this.create_appender(appendPos);
            return object;
        }
    }

    public void close() {
        RecordLog$log_mutex$ recordLog$log_mutex$ = this.log_mutex();
        synchronized (recordLog$log_mutex$) {
            this.current_appender().release();
            return;
        }
    }

    public long appender_limit() {
        return this.current_appender().append_position();
    }

    public long appender_start() {
        return this.current_appender().position();
    }

    public File next_log(long position) {
        return LevelDBClient$.MODULE$.create_sequence_file(this.directory(), position, this.logSuffix());
    }

    public <T> T appender(Function1<LogAppender, T> func$2) {
        long intial_position$1 = this.current_appender().append_position();
        T exceptionResult1 = null;
        try {
            exceptionResult1 = this.max_log_write_latency().apply(new Serializable(this, func$2, intial_position$1){
                public static final long serialVersionUID;
                private final RecordLog $outer;
                private final Function1 func$2;
                private final long intial_position$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                /*
                 * WARNING - void declaration
                 */
                public final T apply() {
                    void var1_1;
                    Object rc = this.func$2.apply((Object)((Object)this.$outer.current_appender()));
                    Tuple2<Object, LogInfo> tuple2 = this.$outer.current_appender().append_position() != this.intial_position$1 ? this.$outer.current_appender().append(RecordLog$.MODULE$.UOW_END_RECORD(), RecordLog$.MODULE$.encode_long(this.intial_position$1)) : BoxedUnit.UNIT;
                    return var1_1;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.func$2 = function1;
                    this.intial_position$1 = l;
                }
            });
            this.current_appender().flush();
            this.max_log_rotate_latency().apply(new Serializable(this){
                public static final long serialVersionUID;
                private final RecordLog $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Object apply() {
                    RecordLog$log_mutex$ recordLog$log_mutex$ = this.$outer.log_mutex();
                    synchronized (recordLog$log_mutex$) {
                        Object object;
                        if (this.$outer.current_appender().append_offset() >= this.$outer.logSize()) {
                            this.$outer.current_appender().release();
                            this.$outer.on_log_rotate().apply$mcV$sp();
                            object = this.$outer.create_appender(this.$outer.current_appender().append_position());
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = object;
                        return boxedUnit;
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        catch (Throwable throwable) {
            this.current_appender().flush();
            this.max_log_rotate_latency().apply(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        return exceptionResult1;
    }

    public Function0<BoxedUnit> on_log_rotate() {
        return this.on_log_rotate;
    }

    public void on_log_rotate_$eq(Function0<BoxedUnit> function0) {
        this.on_log_rotate = function0;
    }

    public final LRUCache<File, LogReader> org$apache$activemq$leveldb$RecordLog$$reader_cache() {
        return this.org$apache$activemq$leveldb$RecordLog$$reader_cache;
    }

    public Option<LogInfo> log_info(long pos) {
        RecordLog$log_mutex$ recordLog$log_mutex$ = this.log_mutex();
        synchronized (recordLog$log_mutex$) {
            Option option = Option$.MODULE$.apply(this.log_infos().floorEntry(BoxesRunTime.boxToLong((long)pos))).map((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final LogInfo apply(Map.Entry<Object, LogInfo> entry) {
                    return entry.getValue();
                }
            });
            return option;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> Option<T> get_reader(long record_position, Function1<LogReader, T> func$1) {
        RecordLog$log_mutex$ recordLog$log_mutex$ = this.log_mutex();
        synchronized (recordLog$log_mutex$) {
            Option<LogInfo> info2 = this.log_info(record_position);
            Option option = info2.map((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final RecordLog $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Tuple2<LogInfo, LogAppender> apply(LogInfo info2) {
                    Tuple2 tuple2;
                    if (info2.position() == this.$outer.current_appender().position()) {
                        this.$outer.current_appender().retain();
                        tuple2 = new Tuple2((Object)info2, (Object)((Object)this.$outer.current_appender()));
                    } else {
                        tuple2 = new Tuple2((Object)info2, null);
                    }
                    return tuple2;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : recordLog$log_mutex$
            Option lookup = option;
            return lookup.map((Function1)new Serializable(this, func$1){
                public static final long serialVersionUID;
                private final RecordLog $outer;
                private final Function1 func$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final T apply(Tuple2<LogInfo, LogAppender> tuple2) {
                    LogReader logReader;
                    Tuple2<LogInfo, LogAppender> tuple22 = tuple2;
                    if (tuple22 == null) throw new MatchError(tuple22);
                    LogInfo logInfo = (LogInfo)tuple22._1();
                    LogAppender logAppender = (LogAppender)((Object)tuple22._2());
                    LogInfo info2 = logInfo;
                    LogAppender appender2 = logAppender;
                    if (appender2 == null) {
                        LRUCache<File, LogReader> lRUCache = this.$outer.org$apache$activemq$leveldb$RecordLog$$reader_cache();
                        synchronized (lRUCache) {
                            Object object;
                            LogReader reader2 = (LogReader)((Object)this.$outer.org$apache$activemq$leveldb$RecordLog$$reader_cache().get((Object)info2.file()));
                            if (reader2 == null) {
                                reader2 = new LogReader(this.$outer, info2.file(), info2.position());
                                object = this.$outer.org$apache$activemq$leveldb$RecordLog$$reader_cache().put((Object)info2.file(), (Object)((Object)reader2));
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                            reader2.retain();
                            LogReader logReader2 = reader2;
                            // MONITOREXIT @DISABLED, blocks:[0, 2, 9] lbl19 : MonitorExitStatement: MONITOREXIT : lRUCache
                            logReader = logReader2;
                        }
                    } else {
                        logReader = appender2;
                    }
                    LogAppender reader = logReader;
                    Object exceptionResult4 = null;
                    try {
                        exceptionResult4 = this.func$1.apply((Object)((Object)reader));
                        return (T)exceptionResult4;
                    }
                    finally {
                        reader.release();
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.func$1 = function1;
                }
            });
        }
    }

    public Option<Tuple3<Object, Buffer, Object>> read(long pos$2) {
        return this.get_reader(pos$2, (Function1)new Serializable(this, pos$2){
            public static final long serialVersionUID;
            private final long pos$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple3<Object, Buffer, Object> apply(LogReader logReader) {
                return logReader.read(this.pos$2);
            }
            {
                this.pos$2 = l;
            }
        });
    }

    public Option<Buffer> read(long pos$1, int length$2) {
        return this.get_reader(pos$1, (Function1)new Serializable(this, pos$1, length$2){
            public static final long serialVersionUID;
            private final long pos$1;
            private final int length$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Buffer apply(LogReader logReader) {
                return logReader.read(this.pos$1, this.length$2);
            }
            {
                this.pos$1 = l;
                this.length$2 = n;
            }
        });
    }

    public RecordLog copy(File directory, String logSuffix) {
        return new RecordLog(directory, logSuffix);
    }

    public String copy$default$2() {
        return this.logSuffix();
    }

    public File copy$default$1() {
        return this.directory();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        String string;
        String logSuffix$1;
        if (this == object) return true;
        Object object2 = object;
        if (!(object2 instanceof RecordLog)) return false;
        RecordLog recordLog = (RecordLog)object2;
        File file = recordLog.directory();
        File directory$1 = file;
        if (!this.gd3$1(directory$1, logSuffix$1 = (string = recordLog.logSuffix()))) return false;
        boolean bl = ((RecordLog)object).canEqual(this);
        if (!bl) return false;
        return true;
    }

    public String productPrefix() {
        return "RecordLog";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            case 0: {
                object = this.directory();
                break;
            }
            case 1: {
                object = this.logSuffix();
            }
        }
        return object;
    }

    public boolean canEqual(Object object) {
        return object instanceof RecordLog;
    }

    private final long liftedTree1$1(LogInfo logInfo, LogReader logReader) {
        long exceptionResult2 = 0L;
        try {
            long actualLength = logReader.verifyAndGetEndPosition();
            long x$5 = actualLength - logInfo.position();
            File x$6 = logInfo.copy$default$1();
            long x$7 = logInfo.copy$default$2();
            LogInfo updated$1 = logInfo.copy(x$6, x$7, x$5);
            this.log_infos().put(BoxesRunTime.boxToLong((long)updated$1.position()), updated$1);
            Object object = updated$1.file().length() != logInfo.length() ? FileSupport$.MODULE$.using(new RandomAccessFile(logInfo.file(), "rw"), new Serializable(this, updated$1){
                public static final long serialVersionUID;
                private final LogInfo updated$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(RandomAccessFile randomAccessFile) {
                    randomAccessFile.setLength(this.updated$1.length());
                }
                {
                    this.updated$1 = logInfo;
                }
            }) : BoxedUnit.UNIT;
            exceptionResult2 = actualLength;
            return exceptionResult2;
        }
        finally {
            logReader.release();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean gd3$1(File file, String string) {
        File file2 = file;
        File file3 = this.directory();
        if (file2 == null) {
            if (file3 != null) {
                return false;
            }
        } else if (!((Object)file2).equals(file3)) return false;
        String string2 = string;
        String string3 = this.logSuffix();
        if (string2 == null) {
            if (string3 == null) return true;
            return false;
        } else {
            if (!string2.equals(string3)) return false;
            return true;
        }
    }

    public RecordLog(File directory, String logSuffix) {
        this.directory = directory;
        this.logSuffix = logSuffix;
        Product.class.$init$((Product)this);
        directory.mkdirs();
        this.logSize = 0x6400000L;
        this.verify_checksums = false;
        this.sync = false;
        this.log_infos = new TreeMap();
        this.max_log_write_latency = new TimeMetric();
        this.max_log_flush_latency = new TimeMetric();
        this.max_log_rotate_latency = new TimeMetric();
        this.on_log_rotate = new $anonfun$1(this);
        this.org$apache$activemq$leveldb$RecordLog$$reader_cache = new $anon$1(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LogInfo
    implements ScalaObject,
    Product,
    Serializable {
        private final File file;
        private final long position;
        private final long length;

        public File file() {
            return this.file;
        }

        public long position() {
            return this.position;
        }

        public long length() {
            return this.length;
        }

        public long limit() {
            return this.position() + this.length();
        }

        public long copy$default$3() {
            return this.length();
        }

        public long copy$default$2() {
            return this.position();
        }

        public File copy$default$1() {
            return this.file();
        }

        public LogInfo copy(File file, long position, long length) {
            return new LogInfo(file, position, length);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            long l;
            long length$1;
            long l2;
            long position$1;
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof LogInfo)) return false;
            LogInfo logInfo = (LogInfo)object2;
            File file = logInfo.file();
            File file$1 = file;
            if (!this.gd1$1(file$1, position$1 = (l2 = logInfo.position()), length$1 = (l = logInfo.length()))) return false;
            boolean bl = ((LogInfo)object).canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String productPrefix() {
            return "LogInfo";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int n) {
            Comparable<File> comparable;
            int n2 = n;
            switch (n2) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
                case 0: {
                    comparable = this.file();
                    break;
                }
                case 2: {
                    comparable = BoxesRunTime.boxToLong((long)this.length());
                    break;
                }
                case 1: {
                    comparable = BoxesRunTime.boxToLong((long)this.position());
                }
            }
            return comparable;
        }

        public boolean canEqual(Object object) {
            return object instanceof LogInfo;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean gd1$1(File file, long l, long l2) {
            File file2 = file;
            File file3 = this.file();
            if (file2 == null) {
                if (file3 != null) {
                    return false;
                }
            } else if (!((Object)file2).equals(file3)) return false;
            if (l != this.position()) return false;
            if (l2 != this.length()) return false;
            return true;
        }

        public LogInfo(File file, long position, long length) {
            this.file = file;
            this.position = position;
            this.length = length;
            Product.class.$init$((Product)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LogReader
    extends BaseRetained
    implements ScalaObject,
    Product,
    Serializable {
        private final File file;
        private final long position;
        private final RandomAccessFile fd;
        private final FileChannel channel;
        public final RecordLog $outer;

        public File file() {
            return this.file;
        }

        public long position() {
            return this.position;
        }

        public RandomAccessFile open() {
            return new RandomAccessFile(this.file(), "r");
        }

        public RandomAccessFile fd() {
            return this.fd;
        }

        public FileChannel channel() {
            return this.channel;
        }

        public void dispose() {
            this.fd().close();
        }

        public void check_read_flush(long end_offset) {
        }

        public Buffer read(long record_position, int length$3) {
            Buffer buffer;
            long offset$1 = record_position - this.position();
            if (RecordLog$.MODULE$.$enable_assertions()) {
                Predef$.MODULE$.assert(offset$1 >= 0L);
            }
            this.check_read_flush(offset$1 + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE() + (long)length$3);
            if (this.org$apache$activemq$leveldb$RecordLog$LogReader$$$outer().verify_checksums()) {
                Buffer record$1 = new Buffer(RecordLog$.MODULE$.LOG_HEADER_SIZE() + length$3);
                if (this.channel().read(record$1.toByteBuffer(), offset$1) != record$1.length) {
                    if (RecordLog$.MODULE$.$enable_assertions()) {
                        Predef$.MODULE$.assert(this.record_is_not_changing$1(length$3, offset$1, record$1));
                    }
                    throw new IOException(new StringBuilder().append((Object)"short record at position: ").append((Object)BoxesRunTime.boxToLong((long)record_position)).append((Object)" in file: ").append((Object)this.file()).append((Object)", offset: ").append((Object)BoxesRunTime.boxToLong((long)offset$1)).toString());
                }
                DataByteArrayInputStream is = new DataByteArrayInputStream(record$1);
                byte prefix = is.readByte();
                if (prefix != RecordLog$.MODULE$.LOG_HEADER_PREFIX()) {
                    if (RecordLog$.MODULE$.$enable_assertions()) {
                        Predef$.MODULE$.assert(this.record_is_not_changing$1(length$3, offset$1, record$1));
                    }
                    throw new IOException(new StringBuilder().append((Object)"invalid record at position: ").append((Object)BoxesRunTime.boxToLong((long)record_position)).append((Object)" in file: ").append((Object)this.file()).append((Object)", offset: ").append((Object)BoxesRunTime.boxToLong((long)offset$1)).toString());
                }
                byte id = is.readByte();
                int expectedChecksum = is.readInt();
                int expectedLength = is.readInt();
                Buffer data = is.readBuffer(length$3);
                if (expectedLength == length$3 && expectedChecksum != this.org$apache$activemq$leveldb$RecordLog$LogReader$$$outer().checksum(data)) {
                    if (RecordLog$.MODULE$.$enable_assertions()) {
                        Predef$.MODULE$.assert(this.record_is_not_changing$1(length$3, offset$1, record$1));
                    }
                    throw new IOException(new StringBuilder().append((Object)"checksum does not match at position: ").append((Object)BoxesRunTime.boxToLong((long)record_position)).append((Object)" in file: ").append((Object)this.file()).append((Object)", offset: ").append((Object)BoxesRunTime.boxToLong((long)offset$1)).toString());
                }
                buffer = data;
            } else {
                Buffer data = new Buffer(length$3);
                if (this.channel().read(data.toByteBuffer(), offset$1 + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE()) != data.length) {
                    throw new IOException(new StringBuilder().append((Object)"short record at position: ").append((Object)BoxesRunTime.boxToLong((long)record_position)).append((Object)" in file: ").append((Object)this.file()).append((Object)", offset: ").append((Object)BoxesRunTime.boxToLong((long)offset$1)).toString());
                }
                buffer = data;
            }
            return buffer;
        }

        public Tuple3<Object, Buffer, Object> read(long record_position) {
            long offset = record_position - this.position();
            Buffer header = new Buffer(RecordLog$.MODULE$.LOG_HEADER_SIZE());
            this.channel().read(header.toByteBuffer(), offset);
            BufferEditor is = header.bigEndianEditor();
            byte prefix = is.readByte();
            if (prefix != RecordLog$.MODULE$.LOG_HEADER_PREFIX()) {
                throw new IOException("invalid record position");
            }
            byte id = is.readByte();
            int expectedChecksum = is.readInt();
            int length = is.readInt();
            Buffer data = new Buffer(length);
            if (this.channel().read(data.toByteBuffer(), offset + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE()) != length) {
                throw new IOException("short record");
            }
            if (this.org$apache$activemq$leveldb$RecordLog$LogReader$$$outer().verify_checksums() && expectedChecksum != this.org$apache$activemq$leveldb$RecordLog$LogReader$$$outer().checksum(data)) {
                throw new IOException("checksum does not match");
            }
            return new Tuple3((Object)BoxesRunTime.boxToByte((byte)id), (Object)data, (Object)BoxesRunTime.boxToLong((long)(record_position + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE() + (long)length)));
        }

        public Option<Tuple2<Object, Option<Object>>> check(long record_position) {
            int chunkSize;
            long offset = record_position - this.position();
            Buffer header = new Buffer(RecordLog$.MODULE$.LOG_HEADER_SIZE());
            this.channel().read(header.toByteBuffer(), offset);
            BufferEditor is = header.bigEndianEditor();
            byte prefix = is.readByte();
            if (prefix != RecordLog$.MODULE$.LOG_HEADER_PREFIX()) {
                return None$.MODULE$;
            }
            byte kind = is.readByte();
            int expectedChecksum = is.readInt();
            int length = is.readInt();
            Buffer chunk = new Buffer(4096);
            ByteBuffer chunkbb = chunk.toByteBuffer();
            offset += (long)RecordLog$.MODULE$.LOG_HEADER_SIZE();
            CRC32 checksumer = new CRC32();
            for (int remaining = length; remaining > 0; remaining -= chunkSize) {
                chunkSize = Predef$.MODULE$.intWrapper(remaining).min(4096);
                chunkbb.position(0);
                chunkbb.limit(chunkSize);
                this.channel().read(chunkbb, offset);
                if (chunkbb.hasRemaining()) {
                    return None$.MODULE$;
                }
                checksumer.update(chunk.data, 0, chunkSize);
                offset += (long)chunkSize;
            }
            int checksum = (int)(checksumer.getValue() & 0xFFFFFFFFFFFFFFFFL);
            if (expectedChecksum != checksum) {
                return None$.MODULE$;
            }
            None$ uow_start_pos = kind == RecordLog$.MODULE$.UOW_END_RECORD() && length == 8 ? new Some((Object)BoxesRunTime.boxToLong((long)RecordLog$.MODULE$.decode_long(chunk))) : None$.MODULE$;
            return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)(record_position + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE() + (long)length)), (Object)uow_start_pos));
        }

        public long verifyAndGetEndPosition() {
            Object object = new Object();
            long exceptionResult3 = 0L;
            try {
                long pos = this.position();
                LongRef current_uow_start$1 = new LongRef(pos);
                long limit = this.position() + this.channel().size();
                while (pos < limit) {
                    Option<Tuple2<Object, Option<Object>>> option = this.check(pos);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Tuple2 tuple2 = (Tuple2)some.x();
                        if (tuple2 != null) {
                            long l;
                            long next$1 = l = BoxesRunTime.unboxToLong((Object)tuple2._1());
                            ((Option)tuple2._2()).foreach((Function1)new Serializable(this, current_uow_start$1, next$1, object){
                                public static final long serialVersionUID;
                                private final LongRef current_uow_start$1;
                                private final long next$1;
                                private final Object nonLocalReturnKey1$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final void apply(long uow_start_pos) {
                                    this.apply$mcVJ$sp(uow_start_pos);
                                }

                                public void apply$mcVJ$sp(long v1) {
                                    if (v1 == this.current_uow_start$1.elem) {
                                        this.current_uow_start$1.elem = this.next$1;
                                        return;
                                    }
                                    throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)BoxesRunTime.boxToLong((long)this.current_uow_start$1.elem));
                                }
                                {
                                    this.current_uow_start$1 = longRef;
                                    this.next$1 = l;
                                    this.nonLocalReturnKey1$1 = object;
                                }
                            });
                            pos = next$1;
                            continue;
                        }
                        throw new MatchError(option);
                    }
                    None$ none$ = None$.MODULE$;
                    Option<Tuple2<Object, Option<Object>>> option2 = option;
                    if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                        return current_uow_start$1.elem;
                    }
                    throw new MatchError(option);
                }
                return current_uow_start$1.elem;
            }
            catch (NonLocalReturnControl nonLocalReturnControl) {
                if (nonLocalReturnControl.key() == object) {
                    exceptionResult3 = BoxesRunTime.unboxToLong((Object)nonLocalReturnControl.value());
                    return exceptionResult3;
                }
                throw nonLocalReturnControl;
            }
        }

        public LogReader copy(File file, long position) {
            return new LogReader(this.org$apache$activemq$leveldb$RecordLog$LogReader$$$outer(), file, position);
        }

        public long copy$default$2() {
            return this.position();
        }

        public File copy$default$1() {
            return this.file();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            long l;
            long position$2;
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof LogReader)) return false;
            if (((LogReader)((Object)object2)).org$apache$activemq$leveldb$RecordLog$LogReader$$$outer() != this.org$apache$activemq$leveldb$RecordLog$LogReader$$$outer()) return false;
            LogReader logReader = (LogReader)((Object)object2);
            File file = logReader.file();
            File file$2 = file;
            if (!this.gd2$1(file$2, position$2 = (l = logReader.position()))) return false;
            boolean bl = ((LogReader)((Object)object)).canEqual((Object)this);
            if (!bl) return false;
            return true;
        }

        public String productPrefix() {
            return "LogReader";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int n) {
            Comparable<File> comparable;
            int n2 = n;
            switch (n2) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
                case 0: {
                    comparable = this.file();
                    break;
                }
                case 1: {
                    comparable = BoxesRunTime.boxToLong((long)this.position());
                }
            }
            return comparable;
        }

        public boolean canEqual(Object object) {
            return object instanceof LogReader;
        }

        public RecordLog org$apache$activemq$leveldb$RecordLog$LogReader$$$outer() {
            return this.$outer;
        }

        private final boolean record_is_not_changing$1(int n, long l, Buffer buffer) {
            return BoxesRunTime.unboxToBoolean(FileSupport$.MODULE$.using(this.open(), new Serializable(this, n, l, buffer){
                public static final long serialVersionUID;
                private final int length$3;
                private final long offset$1;
                private final Buffer record$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(RandomAccessFile fd) {
                    FileChannel channel = fd.getChannel();
                    Buffer new_record = new Buffer(RecordLog$.MODULE$.LOG_HEADER_SIZE() + this.length$3);
                    channel.read(new_record.toByteBuffer(), this.offset$1);
                    Buffer buffer = this.record$1;
                    Buffer buffer2 = new_record;
                    boolean same = !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null);
                    Predef$.MODULE$.println((Object)BoxesRunTime.boxToBoolean((boolean)same));
                    return same;
                }
                {
                    this.length$3 = n;
                    this.offset$1 = l;
                    this.record$1 = buffer;
                }
            }));
        }

        private final boolean gd2$1(File file, long l) {
            File file2 = file;
            File file3 = this.file();
            return !(file2 != null ? !((Object)file2).equals(file3) : file3 != null) && l == this.position();
        }

        public LogReader(RecordLog $outer, File file, long position) {
            this.file = file;
            this.position = position;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
            this.fd = this.open();
            this.channel = this.fd().getChannel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LogAppender
    extends LogReader
    implements ScalaObject {
        private final LogInfo info = new LogInfo(super.file(), super.position(), 0L);
        private long append_offset = 0L;
        private final AtomicLong flushed_offset = new AtomicLong(0L);
        private final DataByteArrayOutputStream write_buffer;

        public LogInfo info() {
            return this.info;
        }

        @Override
        public RandomAccessFile open() {
            return new RandomAccessFile(super.file(), "rw");
        }

        @Override
        public void dispose() {
            this.force();
            super.dispose();
        }

        public long append_offset() {
            return this.append_offset;
        }

        public void append_offset_$eq(long l) {
            this.append_offset = l;
        }

        public AtomicLong flushed_offset() {
            return this.flushed_offset;
        }

        public long append_position() {
            return super.position() + this.append_offset();
        }

        public DataByteArrayOutputStream write_buffer() {
            return this.write_buffer;
        }

        public void force() {
            this.flush();
            if (this.org$apache$activemq$leveldb$RecordLog$LogAppender$$$outer().sync()) {
                this.org$apache$activemq$leveldb$RecordLog$LogAppender$$$outer().max_log_flush_latency().apply(new Serializable(this){
                    public static final long serialVersionUID;
                    private final LogAppender $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.channel().force(this.$outer.append_offset() > this.$outer.org$apache$activemq$leveldb$RecordLog$LogAppender$$$outer().logSize());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }

        public Tuple2<Object, LogInfo> append(byte id, Buffer data) {
            LogAppender logAppender = this;
            synchronized (logAppender) {
                long record_position = this.append_position();
                int data_length = data.length;
                int total_length = RecordLog$.MODULE$.LOG_HEADER_SIZE() + data_length;
                if (this.write_buffer().position() + total_length > RecordLog$.MODULE$.BUFFER_SIZE()) {
                    this.flush();
                }
                int cs = this.org$apache$activemq$leveldb$RecordLog$LogAppender$$$outer().checksum(data);
                if (false && total_length > RecordLog$.MODULE$.BYPASS_BUFFER_SIZE()) {
                    this.write_buffer().writeByte((int)RecordLog$.MODULE$.LOG_HEADER_PREFIX());
                    this.write_buffer().writeByte((int)id);
                    this.write_buffer().writeInt(cs);
                    this.write_buffer().writeInt(data_length);
                    this.append_offset_$eq(this.append_offset() + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE());
                    this.flush();
                    ByteBuffer buffer = data.toByteBuffer();
                    long pos = this.append_offset() + (long)RecordLog$.MODULE$.LOG_HEADER_SIZE();
                    int remaining = buffer.remaining();
                    this.channel().write(buffer, pos);
                    this.flushed_offset().addAndGet(remaining);
                    if (buffer.hasRemaining()) {
                        throw new IOException("Short write");
                    }
                    this.append_offset_$eq(this.append_offset() + (long)data_length);
                } else {
                    this.write_buffer().writeByte((int)RecordLog$.MODULE$.LOG_HEADER_PREFIX());
                    this.write_buffer().writeByte((int)id);
                    this.write_buffer().writeInt(cs);
                    this.write_buffer().writeInt(data_length);
                    this.write_buffer().write(data.data, data.offset, data_length);
                    this.append_offset_$eq(this.append_offset() + (long)total_length);
                }
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)record_position), (Object)this.info());
                return tuple2;
            }
        }

        public void flush() {
            this.org$apache$activemq$leveldb$RecordLog$LogAppender$$$outer().max_log_flush_latency().apply(new Serializable(this){
                public static final long serialVersionUID;
                private final LogAppender $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    LogAppender logAppender = this.$outer;
                    synchronized (logAppender) {
                        BoxedUnit boxedUnit;
                        if (this.$outer.write_buffer().position() > 0) {
                            ByteBuffer buffer = this.$outer.write_buffer().toBuffer().toByteBuffer();
                            int remaining = buffer.remaining();
                            long pos = this.$outer.append_offset() - (long)remaining;
                            this.$outer.channel().write(buffer, pos);
                            this.$outer.flushed_offset().addAndGet(remaining);
                            if (buffer.hasRemaining()) {
                                throw new IOException("Short write");
                            }
                            this.$outer.write_buffer().reset();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        @Override
        public void check_read_flush(long end_offset) {
            if (this.flushed_offset().get() < end_offset) {
                this.flush();
            }
        }

        public RecordLog org$apache$activemq$leveldb$RecordLog$LogAppender$$$outer() {
            return this.$outer;
        }

        public LogAppender(RecordLog $outer, File file, long position) {
            super($outer, file, position);
            this.channel().position($outer.logSize() - 1L);
            this.channel().write(new Buffer(1).toByteBuffer());
            this.channel().force(true);
            Object object = $outer.sync() ? this.channel().position(0L) : BoxedUnit.UNIT;
            this.write_buffer = new DataByteArrayOutputStream(RecordLog$.MODULE$.BUFFER_SIZE() + RecordLog$.MODULE$.LOG_HEADER_SIZE());
        }
    }
}

