# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from elisa.core.media_uri import MediaUri
from elisa.core.utils import defer
from elisa.core.utils.i18n import install_translation

from elisa.plugins.poblesec.link import Link
from elisa.plugins.poblesec.sections_menu import main_menu_decorate


_ = install_translation('poblesec')


def movie_decorator(controller):
    controller_path = "/poblesec/movie_menu"
    label = _("Movies")
    icon = "elisa.plugins.poblesec.video_section"
    dfr = main_menu_decorate(controller, controller_path, label, icon)
    return dfr


def movie_lib_decorator(controller):
    link = Link()
    link.controller_path = '/poblesec/database/movie/list'
    link.label = _('Library')
    controller.model.append(link)
    return defer.succeed(None)


def unclassified_videos_decorator(controller):
    tracks = Link()
    tracks.controller_path = '/poblesec/database/video/unclassified'
    tracks.label = _('Unclassified Videos')
    controller.model.append(tracks)
    return defer.succeed(None)


def tv_decorator(controller):
    controller_path = "/poblesec/tv_menu"
    label = _("TV Shows")
    icon = "elisa.plugins.poblesec.tv_section"
    dfr = main_menu_decorate(controller, controller_path, label, icon)
    return dfr


def tv_lib_decorator(controller):
    link = Link()
    link.controller_path = '/poblesec/database/tvshows/list'
    link.label = _('Library')
    controller.model.append(link)
    return defer.succeed(None)
