##
# $Id: dhcp.rb 10012 2010-08-14 04:58:27Z jduck $
##

require 'rex/proto/dhcp'

module Msf

###
#
# This mixin provides a DHCPServer
#
###
module Exploit::DHCPServer

	def initialize(info = {})
		super

		@dhcp = nil
	end

	def start_service(hash = {}, context = {})
		@dhcp = Rex::Proto::DHCP::Server.new(hash, context)
		print_status("Starting DHCP server") if datastore['VERBOSE']
		@dhcp.start
		add_socket(@dhcp.socket)
		@dhcp
	end

	def stop_service
		print_status("Stopping DHCP server") if datastore['VERBOSE']
		@dhcp.stop
	end

	attr_accessor :dhcp
end

end

