# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python tools
#
# Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

from pgm.graph.group import Group
import gobject

class Button(Group):
    """
    A Button is a Group enhanced with focusing possibilities.

    # TODO: this does not belong to Button but more into something, we would
    # call a WIDGET

    @ivar focus: is this Button focused?
    @type focus: bool
    """

    __gsignals__ = {'focus': (gobject.SIGNAL_RUN_LAST, gobject.TYPE_BOOLEAN,
                    (gobject.TYPE_BOOLEAN,))}

    def __init__(self):
        self._focus = False
        self._focus_on_clicked = True
        super(Button, self).__init__()

    def clicked(self, drawable, x, y, z, button, time, pressure):
        if self._focus_on_clicked:
            self.focus = True
        self.emit('clicked', x, y, z, button, time, pressure)
        return True

    def pressed(self):
        pass

    def focus__get(self):
        return self._focus

    def focus__set(self, value):

        if self._focus == value:
            return

        self._focus = value
        self.emit('focus', value)

