/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.internal.ui.common.JRichTooltipPanel;
import org.pushingpixels.flamingo.internal.ui.common.RichTooltipPanelUI;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class BasicRichTooltipPanelUI
extends RichTooltipPanelUI {
    protected JRichTooltipPanel richTooltipPanel;
    protected List<JLabel> titleLabels = new ArrayList<JLabel>();
    protected List<JLabel> descriptionLabels = new ArrayList<JLabel>();
    protected JLabel mainImageLabel;
    protected JSeparator footerSeparator;
    protected JLabel footerImageLabel;
    protected List<JLabel> footerLabels = new ArrayList<JLabel>();

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicRichTooltipPanelUI();
    }

    public void installUI(JComponent jComponent) {
        this.richTooltipPanel = (JRichTooltipPanel)jComponent;
        super.installUI(this.richTooltipPanel);
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.richTooltipPanel.setLayout(this.createLayoutManager());
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        super.uninstallUI(this.richTooltipPanel);
    }

    protected void installDefaults() {
        Border border = this.richTooltipPanel.getBorder();
        if (border == null || border instanceof UIResource) {
            Border border2 = UIManager.getBorder("RichTooltipPanel.border");
            if (border2 == null) {
                border2 = new BorderUIResource.CompoundBorderUIResource(new LineBorder(FlamingoUtilities.getBorderColor()), new EmptyBorder(2, 4, 3, 4));
            }
            this.richTooltipPanel.setBorder(border2);
        }
        LookAndFeel.installProperty(this.richTooltipPanel, "opaque", Boolean.TRUE);
    }

    protected void installListeners() {
    }

    protected void installComponents() {
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.richTooltipPanel);
    }

    protected void uninstallListeners() {
    }

    protected void uninstallComponents() {
        this.removeExistingComponents();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paintBackground(graphics);
        this.paint(graphics, jComponent);
    }

    protected void paintBackground(Graphics graphics) {
        Color color = FlamingoUtilities.getColor(Color.gray, "Label.disabledForeground").brighter();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, FlamingoUtilities.getLighterColor(color, 0.9), 0.0f, this.richTooltipPanel.getHeight(), FlamingoUtilities.getLighterColor(color, 0.4)));
        graphics2D.fillRect(0, 0, this.richTooltipPanel.getWidth(), this.richTooltipPanel.getHeight());
        graphics2D.setFont(FlamingoUtilities.getFont(this.richTooltipPanel, "Ribbon.font", "Button.font", "Panel.font"));
        graphics2D.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected LayoutManager createLayoutManager() {
        return new RichTooltipPanelLayout();
    }

    protected int getDescriptionTextWidth() {
        return 200;
    }

    protected int getLayoutGap() {
        return 4;
    }

    protected void removeExistingComponents() {
        for (JLabel jLabel : this.titleLabels) {
            this.richTooltipPanel.remove(jLabel);
        }
        if (this.mainImageLabel != null) {
            this.richTooltipPanel.remove(this.mainImageLabel);
        }
        for (JLabel jLabel : this.descriptionLabels) {
            this.richTooltipPanel.remove(jLabel);
        }
        if (this.footerSeparator != null) {
            this.richTooltipPanel.remove(this.footerSeparator);
        }
        if (this.footerImageLabel != null) {
            this.richTooltipPanel.remove(this.footerImageLabel);
        }
        for (JLabel jLabel : this.footerLabels) {
            this.richTooltipPanel.remove(jLabel);
        }
    }

    protected class RichTooltipPanelLayout
    implements LayoutManager {
        protected RichTooltipPanelLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            Object object;
            TextLayout textLayout;
            Insets insets = container.getInsets();
            int n = BasicRichTooltipPanelUI.this.getLayoutGap();
            FontUIResource fontUIResource = FlamingoUtilities.getFont(container, "Ribbon.font", "Button.font", "Panel.font");
            Font font = fontUIResource.deriveFont(1);
            int n2 = BasicRichTooltipPanelUI.this.getDescriptionTextWidth();
            int n3 = insets.left + 2 * n + n2 + insets.right;
            RichTooltip richTooltip = BasicRichTooltipPanelUI.this.richTooltipPanel.getTooltipInfo();
            FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, false);
            if (richTooltip.getMainImage() != null) {
                n3 += richTooltip.getMainImage().getWidth(null);
            }
            int n4 = container.getFontMetrics(fontUIResource).getHeight();
            int n5 = insets.top;
            int n6 = 0;
            AttributedString attributedString = new AttributedString(richTooltip.getTitle());
            attributedString.addAttribute(TextAttribute.FONT, font);
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), fontRenderContext);
            int n7 = 0;
            while ((textLayout = lineBreakMeasurer.nextLayout(n2)) != null) {
                n6 += n4;
                int n8 = (int)Math.ceil(textLayout.getBounds().getWidth());
                n7 = Math.max(n7, n8);
            }
            n5 += n6;
            int n9 = 0;
            for (String string : richTooltip.getDescriptionSections()) {
                AttributedString attributedString2 = new AttributedString(string);
                attributedString2.addAttribute(TextAttribute.FONT, fontUIResource);
                LineBreakMeasurer object2 = new LineBreakMeasurer(attributedString2.getIterator(), fontRenderContext);
                while ((object = object2.nextLayout(n2)) != null) {
                    n9 += n4;
                }
                n9 += n4;
            }
            if (!richTooltip.getDescriptionSections().isEmpty()) {
                n9 -= n4;
                n9 += n;
            }
            n5 = richTooltip.getMainImage() != null ? (n5 += Math.max(n9, new JLabel((Icon)new ImageIcon((Image)richTooltip.getMainImage())).getPreferredSize().height)) : (n5 += n9);
            if (richTooltip.getFooterImage() != null || richTooltip.getFooterSections().size() > 0) {
                n5 += n;
                n5 += new JSeparator((int)0).getPreferredSize().height;
                n5 += n;
                int n10 = 0;
                int n11 = n2;
                if (richTooltip.getFooterImage() != null) {
                    n11 -= richTooltip.getFooterImage().getWidth(null);
                }
                if (richTooltip.getMainImage() != null) {
                    n11 += richTooltip.getMainImage().getWidth(null);
                }
                for (String string : richTooltip.getFooterSections()) {
                    TextLayout textLayout2;
                    object = new AttributedString(string);
                    ((AttributedString)object).addAttribute(TextAttribute.FONT, fontUIResource);
                    LineBreakMeasurer lineBreakMeasurer2 = new LineBreakMeasurer(((AttributedString)object).getIterator(), fontRenderContext);
                    while ((textLayout2 = lineBreakMeasurer2.nextLayout(n11)) != null) {
                        n10 += n4;
                    }
                    n10 += n4;
                }
                n5 = richTooltip.getFooterImage() != null ? (n5 += Math.max(n10, new JLabel((Icon)new ImageIcon((Image)richTooltip.getFooterImage())).getPreferredSize().height)) : (n5 += (n10 -= n4));
            }
            n5 += insets.bottom;
            if (richTooltip.getDescriptionSections().isEmpty() && richTooltip.getMainImage() == null && richTooltip.getFooterSections().isEmpty() && richTooltip.getFooterImage() == null) {
                n3 = n7 + 1 + insets.left + insets.right;
            }
            return new Dimension(n3, n5);
        }

        public void layoutContainer(Container container) {
            Object object;
            Object object2;
            int n;
            int n2;
            TextLayout textLayout;
            BasicRichTooltipPanelUI.this.removeExistingComponents();
            FontUIResource fontUIResource = FlamingoUtilities.getFont(container, "Ribbon.font", "Button.font", "Panel.font");
            Insets insets = BasicRichTooltipPanelUI.this.richTooltipPanel.getInsets();
            int n3 = insets.top;
            RichTooltip richTooltip = BasicRichTooltipPanelUI.this.richTooltipPanel.getTooltipInfo();
            FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, false);
            int n4 = BasicRichTooltipPanelUI.this.getLayoutGap();
            int n5 = container.getFontMetrics(fontUIResource).getHeight();
            Font font = fontUIResource.deriveFont(1);
            boolean bl = BasicRichTooltipPanelUI.this.richTooltipPanel.getComponentOrientation().isLeftToRight();
            int n6 = container.getWidth() - insets.left - insets.right;
            AttributedString attributedString = new AttributedString(richTooltip.getTitle());
            attributedString.addAttribute(TextAttribute.FONT, font);
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), fontRenderContext);
            int n7 = 0;
            while ((textLayout = lineBreakMeasurer.nextLayout(n6)) != null) {
                n2 = textLayout.getCharacterCount();
                String string = richTooltip.getTitle().substring(n7, n7 + n2);
                JLabel iterator = new JLabel(string);
                iterator.setFont(font);
                BasicRichTooltipPanelUI.this.titleLabels.add(iterator);
                BasicRichTooltipPanelUI.this.richTooltipPanel.add(iterator);
                int n8 = iterator.getPreferredSize().width;
                if (bl) {
                    iterator.setBounds(insets.left, n3, n8, n5);
                } else {
                    iterator.setBounds(container.getWidth() - insets.right - n8, n3, n8, n5);
                }
                n3 += iterator.getHeight();
                n7 += n2;
            }
            n3 += n4;
            int n9 = n = bl ? insets.left : container.getWidth() - insets.right;
            if (richTooltip.getMainImage() != null) {
                BasicRichTooltipPanelUI.this.mainImageLabel = new JLabel(new ImageIcon(richTooltip.getMainImage()));
                BasicRichTooltipPanelUI.this.richTooltipPanel.add(BasicRichTooltipPanelUI.this.mainImageLabel);
                n2 = BasicRichTooltipPanelUI.this.mainImageLabel.getPreferredSize().width;
                if (bl) {
                    BasicRichTooltipPanelUI.this.mainImageLabel.setBounds(n, n3, n2, BasicRichTooltipPanelUI.this.mainImageLabel.getPreferredSize().height);
                    n += n2;
                } else {
                    BasicRichTooltipPanelUI.this.mainImageLabel.setBounds(n - n2, n3, n2, BasicRichTooltipPanelUI.this.mainImageLabel.getPreferredSize().height);
                    n -= n2;
                }
            }
            n = bl ? (n += 2 * n4) : (n -= 2 * n4);
            n2 = bl ? container.getWidth() - n - insets.right : n - insets.left;
            for (String string : richTooltip.getDescriptionSections()) {
                TextLayout textLayout2;
                AttributedString attributedString2 = new AttributedString(string);
                attributedString2.addAttribute(TextAttribute.FONT, fontUIResource);
                object2 = new LineBreakMeasurer(attributedString2.getIterator(), fontRenderContext);
                int n10 = 0;
                while ((textLayout2 = ((LineBreakMeasurer)object2).nextLayout(n2)) != null) {
                    int n11 = textLayout2.getCharacterCount();
                    String string2 = string.substring(n10, n10 + n11);
                    object = new JLabel(string2);
                    BasicRichTooltipPanelUI.this.descriptionLabels.add((JLabel)object);
                    BasicRichTooltipPanelUI.this.richTooltipPanel.add((Component)object);
                    int n12 = ((JComponent)object).getPreferredSize().width;
                    if (bl) {
                        ((Component)object).setBounds(n, n3, n12, n5);
                    } else {
                        ((Component)object).setBounds(n - n12, n3, n12, n5);
                    }
                    n3 += ((JComponent)object).getHeight();
                    n10 += n11;
                }
                n3 += n5;
            }
            n3 -= n5;
            if (BasicRichTooltipPanelUI.this.mainImageLabel != null) {
                n3 = Math.max(n3, BasicRichTooltipPanelUI.this.mainImageLabel.getY() + BasicRichTooltipPanelUI.this.mainImageLabel.getHeight());
            }
            if (richTooltip.getFooterImage() != null || richTooltip.getFooterSections().size() > 0) {
                BasicRichTooltipPanelUI.this.footerSeparator = new JSeparator(0);
                BasicRichTooltipPanelUI.this.richTooltipPanel.add(BasicRichTooltipPanelUI.this.footerSeparator);
                BasicRichTooltipPanelUI.this.footerSeparator.setBounds(insets.left, n3 += n4, container.getWidth() - insets.left - insets.right, BasicRichTooltipPanelUI.this.footerSeparator.getPreferredSize().height);
                n3 += BasicRichTooltipPanelUI.this.footerSeparator.getHeight() + n4;
                int n13 = n = bl ? insets.left : container.getWidth() - insets.right;
                if (richTooltip.getFooterImage() != null) {
                    BasicRichTooltipPanelUI.this.footerImageLabel = new JLabel(new ImageIcon(richTooltip.getFooterImage()));
                    BasicRichTooltipPanelUI.this.richTooltipPanel.add(BasicRichTooltipPanelUI.this.footerImageLabel);
                    int n14 = BasicRichTooltipPanelUI.this.footerImageLabel.getPreferredSize().width;
                    if (bl) {
                        BasicRichTooltipPanelUI.this.footerImageLabel.setBounds(n, n3, n14, BasicRichTooltipPanelUI.this.footerImageLabel.getPreferredSize().height);
                        n += n14 + 2 * n4;
                    } else {
                        BasicRichTooltipPanelUI.this.footerImageLabel.setBounds(n - n14, n3, n14, BasicRichTooltipPanelUI.this.footerImageLabel.getPreferredSize().height);
                        n -= n14 + 2 * n4;
                    }
                }
                int n15 = bl ? container.getWidth() - n - insets.right : n - insets.left;
                for (String string : richTooltip.getFooterSections()) {
                    TextLayout textLayout3;
                    object2 = new AttributedString(string);
                    ((AttributedString)object2).addAttribute(TextAttribute.FONT, fontUIResource);
                    LineBreakMeasurer lineBreakMeasurer2 = new LineBreakMeasurer(((AttributedString)object2).getIterator(), fontRenderContext);
                    int n14 = 0;
                    while ((textLayout3 = lineBreakMeasurer2.nextLayout(n15)) != null) {
                        int n16 = textLayout3.getCharacterCount();
                        object = string.substring(n14, n14 + n16);
                        JLabel jLabel = new JLabel((String)object);
                        BasicRichTooltipPanelUI.this.footerLabels.add(jLabel);
                        BasicRichTooltipPanelUI.this.richTooltipPanel.add(jLabel);
                        int n17 = jLabel.getPreferredSize().width;
                        if (bl) {
                            jLabel.setBounds(n, n3, n17, n5);
                        } else {
                            jLabel.setBounds(n - n17, n3, n17, n5);
                        }
                        n3 += jLabel.getHeight();
                        n14 += n16;
                    }
                    n3 += n5;
                }
                n3 -= n5;
            }
        }
    }
}

