/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.TaskField;

public final class Column {
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_RIGHT = 3;
    private FieldType m_fieldType;
    private int m_width;
    private int m_alignTitle;
    private int m_alignData;
    private String m_title;
    private ProjectFile m_project;

    public Column(ProjectFile projectFile) {
        this.m_project = projectFile;
    }

    public int getAlignData() {
        return this.m_alignData;
    }

    public int getAlignTitle() {
        return this.m_alignTitle;
    }

    public FieldType getFieldType() {
        return this.m_fieldType;
    }

    public String getTitle() {
        return this.getTitle(Locale.getDefault());
    }

    public String getTitle(Locale locale) {
        String string = null;
        if (this.m_title != null) {
            string = this.m_title;
        } else {
            string = this.m_fieldType instanceof TaskField ? this.m_project.getTaskFieldAlias((TaskField)this.m_fieldType) : this.m_project.getResourceFieldAlias((ResourceField)this.m_fieldType);
            if (string == null && this.m_fieldType != null) {
                string = this.m_fieldType.getName(locale);
            }
        }
        return string;
    }

    public int getWidth() {
        return this.m_width;
    }

    public void setAlignData(int n) {
        this.m_alignData = n;
    }

    public void setAlignTitle(int n) {
        this.m_alignTitle = n;
    }

    public void setFieldType(FieldType fieldType) {
        this.m_fieldType = fieldType;
    }

    public void setTitle(String string) {
        this.m_title = string;
    }

    public void setWidth(int n) {
        this.m_width = n;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("[Column type=");
        printWriter.print(this.m_fieldType);
        printWriter.print(" width=");
        printWriter.print(this.m_width);
        printWriter.print(" titleAlignment=");
        if (this.m_alignTitle == 1) {
            printWriter.print("LEFT");
        } else if (this.m_alignTitle == 2) {
            printWriter.print("CENTER");
        } else {
            printWriter.print("RIGHT");
        }
        printWriter.print(" dataAlignment=");
        if (this.m_alignData == 1) {
            printWriter.print("LEFT");
        } else if (this.m_alignData == 2) {
            printWriter.print("CENTER");
        } else {
            printWriter.print("RIGHT");
        }
        printWriter.print(" title=");
        printWriter.print(this.getTitle());
        printWriter.println("]");
        printWriter.close();
        return stringWriter.toString();
    }
}

