/*
 * Decompiled with CFR 0.152.
 */
package com.projity.exchange;

import com.projity.exchange.FileImporter;
import com.projity.job.Job;
import com.projity.job.JobRunnable;
import com.projity.server.data.DataUtil;
import com.projity.server.data.DocumentData;
import com.projity.strings.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class LocalFileImporter
extends FileImporter {
    public static final String VERSION = "1.0.0";

    public Job getImportFileJob() {
        return LocalFileImporter.getImportFileJob(this);
    }

    public static Job getImportFileJob(final FileImporter fileImporter) {
        Job job = new Job(fileImporter.getJobQueue(), "importFile", Messages.getString("LocalFileImporter.Importing"), true);
        job.addRunnable(new JobRunnable("Import", 1.0f){

            public Object run() throws Exception {
                DataUtil dataUtil = new DataUtil();
                System.out.println("Loading " + fileImporter.getFileName() + "...");
                long l = System.currentTimeMillis();
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(fileImporter.getFileName()));
                Object object = objectInputStream.readObject();
                if (object instanceof String) {
                    object = objectInputStream.readObject();
                }
                DocumentData documentData = (DocumentData)object;
                documentData.setMaster(true);
                documentData.setLocal(true);
                long l2 = System.currentTimeMillis();
                System.out.println("Loading...Done in " + (l2 - l) + " ms");
                System.out.println("Deserializing...");
                l = System.currentTimeMillis();
                fileImporter.setProject(dataUtil.deserializeLocalDocument(documentData));
                l2 = System.currentTimeMillis();
                System.out.println("Deserializing...Done in " + (l2 - l) + " ms");
                this.setProgress(1.0f);
                return null;
            }
        });
        return job;
    }

    public Job getExportFileJob() {
        return LocalFileImporter.getExportFileJob(this);
    }

    public static Job getExportFileJob(final FileImporter fileImporter) {
        Job job = new Job(fileImporter.getJobQueue(), "exportFile", Messages.getString("LocalFileImporter.Exporting"), true);
        job.addRunnable(new JobRunnable("Export", 1.0f){

            public Object run() throws Exception {
                DataUtil dataUtil = new DataUtil();
                System.out.println("Serialization...");
                long l = System.currentTimeMillis();
                DocumentData documentData = dataUtil.serializeDocument(fileImporter.getProject());
                documentData.setMaster(true);
                documentData.setLocal(true);
                long l2 = System.currentTimeMillis();
                System.out.println("Serialization...Done in " + (l2 - l) + " ms");
                File file = new File(fileImporter.getFileName());
                System.out.println("Saving " + file + "...");
                l = System.currentTimeMillis();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                objectOutputStream.writeObject(LocalFileImporter.VERSION);
                objectOutputStream.writeObject(documentData);
                objectOutputStream.close();
                l2 = System.currentTimeMillis();
                System.out.println("Saving...Done in " + (l2 - l) + " ms");
                this.setProgress(1.0f);
                return null;
            }
        });
        return job;
    }
}

