/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.multiview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.e2e.classdata.ClassDataRegistry;
import org.netbeans.modules.mobility.e2e.classdata.MethodData;
import org.netbeans.modules.mobility.e2e.classdata.MethodParameter;
import org.netbeans.modules.mobility.end2end.E2EDataObject;
import org.netbeans.modules.mobility.end2end.classdata.AbstractService;
import org.netbeans.modules.mobility.end2end.classdata.ClassService;
import org.netbeans.modules.mobility.end2end.classdata.OperationData;
import org.netbeans.modules.mobility.end2end.classdata.PortData;
import org.netbeans.modules.mobility.end2end.classdata.TypeData;
import org.netbeans.modules.mobility.end2end.classdata.WSDLService;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.end2end.ui.treeview.MethodCheckedTreeBeanView;
import org.netbeans.modules.mobility.end2end.ui.treeview.MultiStateCheckBox;
import org.netbeans.modules.mobility.end2end.util.ServiceNodeManager;
import org.netbeans.modules.mobility.end2end.util.Util;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientView;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSOperation;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSParameter;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ServicesPanel
extends SectionInnerPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private final String INVALID_OPERATION = "TXT_InvalidOperation";
    private final String INVALID_OPERATION_NULL_PARAM = "TXT_InvalidOperationNoParam";
    private final JLabel servicesLabel;
    private final MethodCheckedTreeBeanView checkedTreeView;
    private final Node waitNode;
    private final transient E2EDataObject dataObject;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final RequestProcessor.Task repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

        @Override
        public void run() {
            ServicesPanel.this.updateTree();
        }
    });
    private final RequestProcessor.Task changeTask = RequestProcessor.getDefault().create(new Runnable(){

        @Override
        public void run() {
            ServicesPanel.this.selectionChanged();
        }
    });
    private Configuration configuration;
    boolean wsdl = false;
    private FileObject serverProjectFolder;
    private transient ExplorerManager manager;
    private transient Node rootNode;
    private JButton generateButton;

    public ServicesPanel(SectionView sectionView, final E2EDataObject e2EDataObject) {
        super(sectionView);
        this.dataObject = e2EDataObject;
        this.initComponents();
        this.servicesLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 11, 5, 0);
        this.add(this.servicesLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = e2EDataObject != null ? new Insets(5, 10, 5, 0) : new Insets(5, 0, 5, 0);
        this.checkedTreeView = new MethodCheckedTreeBeanView();
        this.waitNode = this.checkedTreeView.getWaitNode();
        this.checkedTreeView.setPopupAllowed(false);
        this.checkedTreeView.setDefaultActionAllowed(false);
        this.checkedTreeView.setBorder(new LineBorder(Color.BLACK, 1, true));
        this.checkedTreeView.setRootVisible(true);
        this.getExplorerManager().setRootContext(this.waitNode);
        this.add((Component)((Object)this.checkedTreeView), gridBagConstraints);
        this.servicesLabel.setLabelFor((Component)((Object)this.checkedTreeView));
        this.generateButton.setEnabled(false);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicesPanel.class, (String)"ACSD_ServicesPanel"));
        this.checkedTreeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicesPanel.class, (String)"ACSD_Services"));
        if (e2EDataObject == null || e2EDataObject.isGenerating()) {
            this.generateButton.setEnabled(false);
        }
        if (e2EDataObject == null) {
            this.generateButton.setVisible(false);
        }
        this.checkedTreeView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (e2EDataObject != null) {
                    ServicesPanel.this.dataObject.setModified(true);
                }
                ServicesPanel.this.changeTask.schedule(100);
            }
        });
        if (e2EDataObject != null) {
            this.setConfiguration(e2EDataObject.getConfiguration());
            e2EDataObject.addPropertyChangeListener(this);
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        if (configuration != null) {
            this.wsdl = "wsdlClass".equals(configuration.getServiceType());
            Mnemonics.setLocalizedText((JLabel)this.servicesLabel, (String)NbBundle.getMessage(ServicesPanel.class, (String)(this.wsdl ? "LBL_Operations" : "LBL_Methods")));
            this.waitNode.setDisplayName(NbBundle.getMessage(ServicesPanel.class, (String)(this.wsdl ? "MSG_WaitComputingWebServices" : "MSG_WaitComputingMethods")));
            this.getExplorerManager().setRootContext(this.waitNode);
            this.repaintingTask.schedule(100);
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void removeNotify() {
        if (this.repaintingTask != null) {
            this.repaintingTask.cancel();
        }
        if (this.changeTask != null) {
            this.changeTask.cancel();
        }
        this.getExplorerManager().removePropertyChangeListener((PropertyChangeListener)this);
        if (this.dataObject != null) {
            this.dataObject.removePropertyChangeListener(this);
        }
        super.removeNotify();
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
        }
        return this.manager;
    }

    private void updateTree() {
        if (!this.wsdl) {
            this.rootNode = ServiceNodeManager.getRootNode(this.configuration, this.checkedTreeView);
        } else {
            OperationData operationData2;
            Project project = Util.getServerProject(this.configuration);
            List<AbstractService> list = this.configuration.getServices();
            WSDLService wSDLService = (WSDLService)list.get(0);
            JAXWSClientView jAXWSClientView = JAXWSClientView.getJAXWSClientView();
            this.rootNode = jAXWSClientView.createJAXWSClientView(project);
            for (Node object22 : this.rootNode.getChildren().getNodes()) {
                if (!object22.getName().equals(wSDLService.getName())) continue;
                this.rootNode = object22;
                break;
            }
            if (this.rootNode.getChildren().getNodesCount() == 0) {
                this.repaintingTask.schedule(500);
                return;
            }
            List<org.netbeans.modules.mobility.end2end.classdata.ClassData> list2 = wSDLService.getData();
            HashSet<String> hashSet = new HashSet<String>();
            List<org.netbeans.modules.mobility.end2end.classdata.ClassData> list3 = this.configuration.getServices().get(0).getData();
            if (list3 != null) {
                for (org.netbeans.modules.mobility.end2end.classdata.ClassData classData : list3) {
                    for (OperationData operationData2 : classData.getOperations()) {
                        Node[] nodeArray = new StringBuffer(classData.getType());
                        nodeArray.append('.').append(operationData2.getMethodName());
                        for (TypeData typeData : operationData2.getParameterTypes()) {
                            nodeArray.append(',').append(typeData.getType());
                        }
                        hashSet.add(nodeArray.toString());
                    }
                }
            }
            FileObject fileObject = project.getProjectDirectory().getFileObject("build/generated/wsimport/client/");
            List<ClasspathInfo> list4 = Collections.singletonList(ClasspathInfo.create((FileObject)fileObject));
            ClassDataRegistry classDataRegistry = ClassDataRegistry.getRegistry("default", list4);
            operationData2 = list2 != null && list2.size() > 0 ? (PortData)list2.get(0) : null;
            this.rootNode = new FilterNode(this.rootNode, (Children)new FilterNode.Children(this.rootNode, (PortData)((Object)operationData2)){
                final /* synthetic */ PortData val$port;
                {
                    this.val$port = portData;
                    super(node);
                }

                protected Node[] createNodes(Node node) {
                    return new Node[]{new FilterNode(node, (Children)new FilterNode.Children(node){
                        String firstWSPortName;
                        {
                            this.firstWSPortName = null;
                        }

                        protected Node[] createNodes(Node node) {
                            WSPort wSPort = (WSPort)node.getLookup().lookup(WSPort.class);
                            if (wSPort == null) {
                                return null;
                            }
                            if (this.firstWSPortName == null) {
                                this.firstWSPortName = wSPort.getName();
                            }
                            return node.getName().equals(val$port == null ? this.firstWSPortName : val$port.getName()) ? super.createNodes(node) : null;
                        }
                    })};
                }
            });
            for (Node node : this.rootNode.getChildren().getNodes()) {
                boolean bl = false;
                for (Node node2 : node.getChildren().getNodes()) {
                    boolean bl2 = false;
                    WSPort wSPort = (WSPort)node2.getLookup().lookup(WSPort.class);
                    ClassData classData = classDataRegistry.getClassData(wSPort.getJavaName());
                    HashSet<String> hashSet2 = new HashSet<String>();
                    if (classData != null) {
                        for (MethodData methodData : classData.getMethods()) {
                            StringBuffer stringBuffer = new StringBuffer(methodData.getName());
                            for (Object object : methodData.getParameters()) {
                                stringBuffer.append(',').append(((MethodParameter)object).getType().getFullyQualifiedName());
                            }
                            hashSet2.add(stringBuffer.toString());
                        }
                    }
                    for (Node node3 : node2.getChildren().getNodes()) {
                        Object object;
                        object = (WSOperation)node3.getLookup().lookup(WSOperation.class);
                        boolean bl3 = false;
                        StringBuilder stringBuilder = new StringBuilder();
                        StringBuilder stringBuilder2 = new StringBuilder();
                        if (object != null) {
                            stringBuilder.append(object.getJavaName());
                            for (Object object2 : object.getParameters()) {
                                String string = object2.getTypeName();
                                int n = string.indexOf(60);
                                stringBuilder.append(',').append(n > 0 ? string.substring(0, n) : string);
                                stringBuilder2.append(n > 0 ? string.substring(0, n) : string);
                                stringBuilder2.append(", ");
                            }
                            bl3 = hashSet2.contains(stringBuilder.toString());
                        }
                        node3.setValue("isValid", (Object)bl3);
                        if (!bl3) {
                            Object object3;
                            if (stringBuilder2.length() > 0) {
                                Object object2;
                                object3 = NbBundle.getMessage(ServicesPanel.class, (String)"TXT_InvalidOperation");
                                object2 = ((String)object3).substring(0, ((String)object3).length() - 2);
                                node3.setShortDescription(MessageFormat.format((String)object3, object.getName(), object2));
                            } else {
                                object3 = NbBundle.getMessage(ServicesPanel.class, (String)"TXT_InvalidOperationNoParam");
                                node3.setShortDescription(MessageFormat.format((String)object3, object.getName()));
                            }
                        }
                        if (bl3 && classData != null) {
                            node3.setValue("isSelected", (Object)(hashSet.contains(classData.getFullyQualifiedName() + '.' + stringBuilder.toString()) ? MultiStateCheckBox.State.SELECTED : MultiStateCheckBox.State.UNSELECTED));
                        }
                        bl2 = bl2 || bl3;
                    }
                    node2.setValue("isValid", (Object)bl2);
                    bl = bl || bl2;
                }
                node.setValue("isValid", (Object)bl);
            }
            this.checkedTreeView.updateTreeNodeStates(null);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (!ServicesPanel.this.wsdl && ServicesPanel.this.rootNode.getChildren().getNodesCount() == 0) {
                        ServicesPanel.this.waitNode.setDisplayName(NbBundle.getMessage(ServicesPanel.class, (String)"MSG_NoMethodAvailable"));
                        return;
                    }
                    ServicesPanel.this.checkedTreeView.setRootVisible(false);
                    ServicesPanel.this.checkedTreeView.setRoot(ServicesPanel.this.rootNode);
                    ServicesPanel.this.getExplorerManager().setRootContext(ServicesPanel.this.rootNode);
                    ServicesPanel.this.expandNodes(ServicesPanel.this.rootNode);
                    ServicesPanel.this.checkValid();
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    private void expandNodes(Node node) {
        if (Boolean.FALSE != node.getValue("isValid")) {
            this.checkedTreeView.expandNode(node);
        }
        for (Node node2 : node.getChildren().getNodes()) {
            this.expandNodes(node2);
        }
    }

    private void selectionChanged() {
        this.getSelectedMethods();
        this.checkValid();
        this.fireChange();
    }

    private void checkValid() {
        AbstractService abstractService = this.configuration.getServices().get(0);
        SectionView sectionView = this.getSectionView();
        if (sectionView != null) {
            if (abstractService == null || abstractService != null && abstractService.getData().size() == 0) {
                sectionView.getErrorPanel().setError(new Error(0, 2, NbBundle.getMessage(ServicesPanel.class, (String)"ERR_MissingServiceSelection"), (JComponent)((Object)this.checkedTreeView)));
                this.generateButton.setEnabled(false);
            } else {
                sectionView.getErrorPanel().clearError();
                this.generateButton.setEnabled(true);
            }
        }
    }

    public void getSelectedMethods() {
        if (!this.wsdl) {
            ArrayList<org.netbeans.modules.mobility.end2end.classdata.ClassData> arrayList = new ArrayList<org.netbeans.modules.mobility.end2end.classdata.ClassData>();
            Node[] nodeArray = this.rootNode.getChildren().getNodes();
            for (Node node : nodeArray) {
                Node[] nodeArray2;
                for (Node node2 : nodeArray2 = node.getChildren().getNodes()) {
                    Node[] nodeArray3 = node2.getChildren().getNodes();
                    ArrayList<OperationData> arrayList2 = new ArrayList<OperationData>();
                    for (Node node3 : nodeArray3) {
                        if (MultiStateCheckBox.State.SELECTED != node3.getValue("isSelected")) continue;
                        MethodData methodData = (MethodData)node3.getLookup().lookup(MethodData.class);
                        List<MethodParameter> list = methodData.getParameters();
                        ArrayList<TypeData> arrayList3 = new ArrayList<TypeData>(list.size());
                        for (MethodParameter methodParameter : list) {
                            TypeData typeData = new TypeData(methodParameter.getName(), methodParameter.getType().getFullyQualifiedName());
                            arrayList3.add(typeData);
                        }
                        OperationData operationData = new OperationData(methodData.getName());
                        operationData.setReturnType(methodData.getReturnType().getFullyQualifiedName());
                        operationData.setParameterTypes(arrayList3);
                        arrayList2.add(operationData);
                    }
                    if (arrayList2.size() == 0) continue;
                    String string = ((ClassData)node2.getLookup().lookup(ClassData.class)).getFullyQualifiedName();
                    org.netbeans.modules.mobility.end2end.classdata.ClassData classData = new org.netbeans.modules.mobility.end2end.classdata.ClassData(string);
                    classData.setOperations(arrayList2);
                    arrayList.add(classData);
                }
            }
            ClassService classService = (ClassService)this.configuration.getServices().get(0);
            classService.setData(arrayList);
            ArrayList<AbstractService> arrayList4 = new ArrayList<AbstractService>();
            arrayList4.add(classService);
            this.configuration.setServices(arrayList4);
        } else {
            ArrayList<AbstractService> arrayList = new ArrayList<AbstractService>();
            Client client = (Client)this.rootNode.getLookup().lookup(Client.class);
            if (client != null) {
                for (Node node : this.rootNode.getChildren().getNodes()) {
                    ArrayList<org.netbeans.modules.mobility.end2end.classdata.ClassData> arrayList5 = new ArrayList<org.netbeans.modules.mobility.end2end.classdata.ClassData>();
                    for (Node node4 : node.getChildren().getNodes()) {
                        WSPort wSPort = (WSPort)node4.getLookup().lookup(WSPort.class);
                        ArrayList<OperationData> arrayList6 = new ArrayList<OperationData>();
                        if (wSPort != null) {
                            for (Node node5 : node4.getChildren().getNodes()) {
                                String string = node5.getName();
                                if (MultiStateCheckBox.State.SELECTED != node5.getValue("isSelected")) continue;
                                WSOperation wSOperation = (WSOperation)node5.getLookup().lookup(WSOperation.class);
                                OperationData operationData = new OperationData(string);
                                operationData.setMethodName(wSOperation.getJavaName());
                                operationData.setReturnType(wSOperation.getReturnTypeName());
                                List list = wSOperation.getParameters();
                                ArrayList<TypeData> arrayList4 = new ArrayList<TypeData>();
                                for (WSParameter wSParameter : list) {
                                    arrayList4.add(new TypeData(wSParameter.getName(), wSParameter.getTypeName()));
                                }
                                operationData.setParameterTypes(arrayList4);
                                if (operationData == null) continue;
                                arrayList6.add(operationData);
                            }
                        }
                        if (wSPort == null || arrayList6.size() <= 0) continue;
                        PortData portData = new PortData(wSPort.getJavaName());
                        portData.setName(node4.getName());
                        portData.setOperations(arrayList6);
                        arrayList5.add(portData);
                    }
                    WSDLService wSDLService = (WSDLService)this.configuration.getServices().get(0);
                    wSDLService.setData(arrayList5);
                    wSDLService.setName(this.rootNode.getName());
                    wSDLService.setType(node.getName());
                    arrayList.add(wSDLService);
                }
            }
            this.configuration.setServices(arrayList);
        }
    }

    private void initComponents() {
        this.generateButton = new JButton();
        this.setPreferredSize(new Dimension(500, 350));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.generateButton, (String)NbBundle.getBundle(ServicesPanel.class).getString("LBL_Generate"));
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServicesPanel.this.generateButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 12, 0, 11);
        this.add(this.generateButton, gridBagConstraints);
    }

    private void generateButtonActionPerformed(ActionEvent actionEvent) {
        this.dataObject.generate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("generating".equals(propertyChangeEvent.getPropertyName())) {
            this.generateButton.setEnabled((Boolean)propertyChangeEvent.getNewValue() == false);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void setServerProjectFolder(FileObject fileObject) {
        this.serverProjectFolder = fileObject;
    }

    public void setValue(JComponent jComponent, Object object) {
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public JComponent getErrorComponent(String string) {
        return null;
    }
}

