/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.reveng;

import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.hibernate.loaders.reveng.HibernateRevengDataLoader;
import org.netbeans.modules.hibernate.loaders.reveng.HibernateRevengDataNode;
import org.netbeans.modules.hibernate.loaders.reveng.HibernateRevengMetadata;
import org.netbeans.modules.hibernate.reveng.model.HibernateReverseEngineering;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.xml.sax.InputSource;

public class HibernateRevengDataObject
extends MultiDataObject {
    private HibernateReverseEngineering revEngineering;

    public HibernateRevengDataObject(FileObject fileObject, HibernateRevengDataLoader hibernateRevengDataLoader) throws DataObjectExistsException, IOException {
        super(fileObject, (MultiFileLoader)hibernateRevengDataLoader);
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add((Node.Cookie)DataEditorSupport.create((DataObject)this, (MultiDataObject.Entry)this.getPrimaryEntry(), (CookieSet)cookieSet));
        InputSource inputSource = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkXMLSupport = new CheckXMLSupport(inputSource);
        cookieSet.add((Node.Cookie)checkXMLSupport);
        ValidateXMLSupport validateXMLSupport = new ValidateXMLSupport(inputSource);
        cookieSet.add((Node.Cookie)validateXMLSupport);
    }

    public HibernateReverseEngineering getHibernateReverseEngineering() {
        if (this.revEngineering == null) {
            try {
                this.revEngineering = HibernateRevengMetadata.getDefault().getRoot(this.getPrimaryFile());
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        assert (this.revEngineering != null);
        return this.revEngineering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReveng() {
        OutputStream outputStream = null;
        try {
            outputStream = this.getPrimaryFile().getOutputStream();
            this.getHibernateReverseEngineering().write(outputStream);
        }
        catch (FileAlreadyLockedException fileAlreadyLockedException) {
            ErrorManager.getDefault().notify(1, (Throwable)fileAlreadyLockedException);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    public void save() {
        EditorCookie editorCookie = (EditorCookie)this.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            try {
                editorCookie.saveDocument();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
    }

    protected Node createNodeDelegate() {
        return new HibernateRevengDataNode(this);
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }
}

