/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.RecentViewListAction;
import org.netbeans.swing.popupswitcher.SwitcherTable;
import org.netbeans.swing.popupswitcher.SwitcherTableItem;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class KeyboardPopupSwitcher
implements WindowFocusListener {
    private static final int TIME_TO_SHOW = 200;
    private static KeyboardPopupSwitcher instance;
    private static JWindow popup;
    private static boolean shown;
    private static Timer invokerTimer;
    private static boolean invokerTimerRunning;
    private static int hits;
    private static SwitcherTableItem[] items;
    private SwitcherTable pTable;
    private static int triggerKey;
    private static int reverseKey;
    private static int releaseKey;
    private int x;
    private int y;
    private boolean fwd = true;

    public static boolean processShortcut(KeyEvent kev) {
        boolean isCtrlShiftTab;
        ModeImpl activeMode;
        WindowManagerImpl wmi = WindowManagerImpl.getInstance();
        if (!wmi.getMainWindow().isFocused()) {
            if (!WindowManagerImpl.isSeparateWindow(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow())) {
                return false;
            }
        }
        if (Boolean.getBoolean("netbeans.winsys.ctrltab.editoronly") && !wmi.isEditorMode(activeMode = wmi.getActiveMode())) {
            return false;
        }
        boolean isCtrlTab = kev.getKeyCode() == 9 && kev.getModifiers() == 2;
        boolean bl = isCtrlShiftTab = kev.getKeyCode() == 9 && kev.getModifiers() == 3;
        if (KeyboardPopupSwitcher.isShown()) {
            assert (instance != null);
            instance.processKeyEvent(kev);
            kev.consume();
            return true;
        }
        if (isCtrlTab || isCtrlShiftTab) {
            if (!KeyboardPopupSwitcher.isAlive()) {
                RecentViewListAction rva = new RecentViewListAction();
                rva.actionPerformed(new ActionEvent(kev.getSource(), 1001, "C-TAB", kev.getModifiers()));
                return true;
            }
            KeyboardPopupSwitcher.processInterruption(kev);
            kev.consume();
            return true;
        }
        if (kev.getKeyCode() == 17 && KeyboardPopupSwitcher.isAlive()) {
            KeyboardPopupSwitcher.processInterruption(kev);
            return true;
        }
        return false;
    }

    public static void selectItem(SwitcherTableItem[] items, int releaseKey, int triggerKey, boolean forward) {
        if (invokerTimerRunning) {
            return;
        }
        KeyboardPopupSwitcher.items = items;
        KeyboardPopupSwitcher.releaseKey = releaseKey;
        KeyboardPopupSwitcher.triggerKey = triggerKey;
        invokerTimer = new Timer(200, new PopupInvoker(forward));
        invokerTimer.setRepeats(false);
        invokerTimer.start();
        invokerTimerRunning = true;
    }

    private static void cleanupInterrupter() {
        invokerTimerRunning = false;
        if (invokerTimer != null) {
            invokerTimer.stop();
        }
    }

    public static boolean isShown() {
        return shown;
    }

    private static boolean isAlive() {
        return invokerTimerRunning || shown;
    }

    private KeyboardPopupSwitcher(int initialSelection, boolean forward) {
        this.fwd = forward;
        this.pTable = new SwitcherTable(items);
        Dimension popupDim = this.pTable.getPreferredSize();
        Rectangle screen = Utilities.getUsableScreenBounds();
        this.x = screen.x + (screen.width / 2 - popupDim.width / 2);
        this.y = screen.y + (screen.height / 2 - popupDim.height / 2);
        int cols = this.pTable.getColumnCount();
        int rows = this.pTable.getRowCount();
        assert (cols > 0) : "There aren't any columns in the KeyboardPopupSwitcher's table";
        assert (rows > 0) : "There aren't any rows in the KeyboardPopupSwitcher's table";
        this.changeTableSelection(rows > initialSelection && initialSelection >= 0 ? initialSelection : initialSelection, 0);
    }

    private void showPopup() {
        if (!KeyboardPopupSwitcher.isShown()) {
            popup = new JWindow();
            popup.setAlwaysOnTop(true);
            popup.getContentPane().add((Component)this.pTable);
            popup.setLocation(this.x, this.y);
            popup.pack();
            popup.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowManager.getDefault().getMainWindow().addWindowFocusListener(KeyboardPopupSwitcher.this);
                }
            });
            shown = true;
        }
    }

    private static void processInterruption(KeyEvent kev) {
        int keyCode = kev.getKeyCode();
        if (keyCode == releaseKey && kev.getID() == 402) {
            KeyboardPopupSwitcher.cleanupInterrupter();
            hits = 0;
            RecentViewListAction rva = new RecentViewListAction();
            rva.actionPerformed(new ActionEvent(kev.getSource(), 1001, "immediately", kev.getModifiers()));
            kev.consume();
        } else if (keyCode == triggerKey && kev.getModifiers() == 2 && kev.getID() == 401) {
            kev.consume();
            KeyboardPopupSwitcher.cleanupInterrupter();
            instance = new KeyboardPopupSwitcher(++hits + 1, true);
            instance.showPopup();
        }
    }

    private void processKeyEvent(KeyEvent kev) {
        switch (kev.getID()) {
            case 401: {
                int code = kev.getKeyCode();
                if (code == reverseKey) {
                    this.fwd = false;
                } else if (code == triggerKey) {
                    int lastRowIdx = this.pTable.getRowCount() - 1;
                    int lastColIdx = this.pTable.getColumnCount() - 1;
                    int selRow = this.pTable.getSelectedRow();
                    int selCol = this.pTable.getSelectedColumn();
                    int row = selRow;
                    int col = selCol;
                    if (this.fwd) {
                        if (selRow >= lastRowIdx) {
                            row = 0;
                            col = selCol >= lastColIdx ? 0 : ++col;
                        } else if (this.pTable.getValueAt(++row, col) == null) {
                            row = 0;
                            col = 0;
                        }
                    } else if (selRow == 0) {
                        if (selCol == 0) {
                            col = lastColIdx;
                            row = this.pTable.getLastValidRow();
                        } else {
                            --col;
                            row = lastRowIdx;
                        }
                    } else {
                        --row;
                    }
                    if (row >= 0 && col >= 0) {
                        this.changeTableSelection(row, col);
                    }
                }
                kev.consume();
                break;
            }
            case 402: {
                int code = kev.getKeyCode();
                if (code == reverseKey) {
                    this.fwd = true;
                    kev.consume();
                    break;
                }
                if (code == 27) {
                    this.cancelSwitching();
                    break;
                }
                if (code != releaseKey) break;
                this.performSwitching();
            }
        }
    }

    private void changeTableSelection(int row, int col) {
        this.pTable.changeSelection(row, col, false, false);
        SwitcherTableItem item = this.pTable.getSelectedItem();
        if (item != null) {
            String statusText = item.getDescription();
            StatusDisplayer.getDefault().setStatusText(statusText != null ? statusText : "");
        }
    }

    private void cancelSwitching() {
        this.hideCurrentPopup();
        StatusDisplayer.getDefault().setStatusText("");
    }

    private void performSwitching() {
        SwitcherTableItem item;
        if (popup != null && (item = this.pTable.getSelectedItem()) != null) {
            item.activate();
        }
        this.cancelSwitching();
    }

    private synchronized void hideCurrentPopup() {
        if (popup != null) {
            SwingUtilities.invokeLater(new PopupHider(popup));
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        if (e.getOppositeWindow() != popup) {
            this.cancelSwitching();
        }
    }

    static {
        reverseKey = 16;
    }

    private class PopupHider
    implements Runnable {
        private JWindow toHide;

        public PopupHider(JWindow popup) {
            this.toHide = popup;
        }

        @Override
        public void run() {
            this.toHide.setVisible(false);
            shown = false;
            hits = 0;
            WindowManager.getDefault().getMainWindow().removeWindowFocusListener(KeyboardPopupSwitcher.this);
        }
    }

    private static class PopupInvoker
    implements ActionListener {
        private boolean forward;

        public PopupInvoker(boolean forward) {
            this.forward = forward;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (invokerTimerRunning) {
                KeyboardPopupSwitcher.cleanupInterrupter();
                instance = new KeyboardPopupSwitcher(this.forward ? hits + 1 : items.length - hits - 1, this.forward);
                instance.showPopup();
            }
        }
    }
}

