/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.codeviation.commons.patterns.Filter;

public class CollectionsUtil {
    private CollectionsUtil() {
    }

    public static <T> HashSet<T> hashSet(T ... params) {
        HashSet<T> s = new HashSet<T>(params.length);
        for (T p : params) {
            s.add(p);
        }
        return s;
    }

    public static <T> HashSet<T> hashSet(Collection<? extends T> original, Filter<T> filter) {
        HashSet<T> s = new HashSet<T>(original.size());
        for (T p : original) {
            if (!filter.accept(p)) continue;
            s.add(p);
        }
        return s;
    }

    public static <T, Q extends T> ArrayList<T> arrayList(Q ... params) {
        ArrayList<Q> s = new ArrayList<Q>(params.length);
        for (Q p : params) {
            s.add(p);
        }
        return s;
    }

    public static <T, Q extends T> ArrayList<T> arrayList(Collection<Q> original, Filter<T> filter) {
        ArrayList<Q> s = new ArrayList<Q>(original.size());
        for (Q p : original) {
            if (!filter.accept(p)) continue;
            s.add(p);
        }
        return s;
    }

    public static <T, C extends Collection<T>, Q extends T> C add(C target, Q ... params) {
        for (Q p : params) {
            target.add(p);
        }
        return target;
    }

    public static <T, C extends Collection<T>, Q extends T> C add(C target, Iterator<Q> it) {
        while (it.hasNext()) {
            target.add(it.next());
        }
        return target;
    }

    public static <T, C extends Collection<T>, Q extends T> C add(C target, Iterable<Q> it) {
        return CollectionsUtil.add(target, it.iterator());
    }

    public static <T, C extends Collection<T>, Q extends Collection<? extends T>> C add(C target, Q source, Filter<? super T> filter) {
        for (T t : source) {
            if (!filter.accept(t)) continue;
            target.add(t);
        }
        return target;
    }

    public static <T, Q extends T> void remove(Collection<T> target, Q ... params) {
        for (Q p : params) {
            target.remove(p);
        }
    }

    public static <T> void remove(Collection<T> target, Iterator<? extends T> it) {
        while (it.hasNext()) {
            target.remove(it.next());
        }
    }

    public static <T, Q extends T> Collection<Q> remove(Collection<Q> target, Filter<? super T> filter) {
        for (Q t : target) {
            if (!filter.accept(t)) continue;
            target.remove(t);
        }
        return target;
    }

    public static <T, Q extends T> Collection<T> filter(Collection<T> target, Iterable<Q> it, Filter<Q> filter) {
        for (Q t : it) {
            if (!filter.accept(t)) continue;
            target.add(t);
        }
        return target;
    }
}

