/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.naming;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.FolderName;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;

public final class NamingFactory {
    private static final Map nameMap = new WeakHashMap();

    public static synchronized FileNaming fromFile(File file) {
        LinkedList<File> list = new LinkedList<File>();
        for (File current = file; current != null; current = current.getParentFile()) {
            list.addFirst(current);
        }
        FileNaming fileName = null;
        for (int i = 0; i < list.size(); ++i) {
            File f = (File)list.get(i);
            if ("\\\\".equals(f.getPath())) {
                ++i;
                continue;
            }
            FileType type = i == list.size() - 1 ? FileType.unknown : FileType.directory;
            fileName = NamingFactory.registerInstanceOfFileNaming(fileName, f, type);
        }
        return fileName;
    }

    public static synchronized int getSize() {
        return nameMap.size();
    }

    public static synchronized FileNaming fromFile(FileNaming parentFn, File file, boolean ignoreCache) {
        return NamingFactory.registerInstanceOfFileNaming(parentFn, file, null, ignoreCache, FileType.unknown);
    }

    public static synchronized FileNaming checkCaseSensitivity(FileNaming childName, File f) throws IOException {
        if (!childName.getFile().getName().equals(f.getName())) {
            boolean isCaseSensitive;
            boolean bl = isCaseSensitive = !new File(f, "a").equals(new File(f, "A"));
            if (!isCaseSensitive) {
                FileName fn = (FileName)childName;
                fn.updateCase(f.getName());
            }
        }
        return childName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileNaming[] rename(FileNaming fNaming, String newName, ProvidedExtensions.IOHandler handler) throws IOException {
        ArrayList<FileNaming> all = new ArrayList<FileNaming>();
        FileNaming newNaming = fNaming.rename(newName, handler);
        boolean retVal = newNaming != fNaming;
        Class<NamingFactory> clazz = NamingFactory.class;
        synchronized (NamingFactory.class) {
            all.add(newNaming);
            NamingFactory.renameChildren(fNaming, all);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return retVal ? all.toArray(new FileNaming[all.size()]) : null;
        }
    }

    private static void renameChildren(FileNaming root, List<FileNaming> all) {
        assert (Thread.holdsLock(NamingFactory.class));
        for (Map.Entry entry : nameMap.entrySet()) {
            Object value = entry.getValue();
            List<Object> list = value instanceof Reference ? Collections.singletonList((Reference)value) : (value instanceof List ? (List<Object>)value : Collections.emptyList());
            block1: for (int i = 0; i < list.size(); ++i) {
                FileNaming fN;
                for (FileNaming up = fN = (FileNaming)((Reference)list.get(i)).get(); up != null; up = up.getParent()) {
                    if (!root.equals(up)) continue;
                    all.add(fN);
                    continue block1;
                }
            }
        }
    }

    public static Integer createID(File file) {
        return new Integer(file.hashCode());
    }

    private static FileNaming registerInstanceOfFileNaming(FileNaming parentName, File file, FileType type) {
        return NamingFactory.registerInstanceOfFileNaming(parentName, file, null, false, type);
    }

    private static FileNaming registerInstanceOfFileNaming(FileNaming parentName, File file, FileNaming newValue, boolean ignoreCache, FileType type) {
        FileNaming retVal;
        FileNaming cachedElement;
        assert (Thread.holdsLock(NamingFactory.class));
        Object value = nameMap.get(new Integer(file.hashCode()));
        Reference ref = (Reference)(value instanceof Reference ? value : null);
        ref = ref == null && value instanceof List ? NamingFactory.getReference((List)value, file) : ref;
        FileNaming fileNaming = cachedElement = ref != null ? (FileNaming)ref.get() : null;
        if (ignoreCache && cachedElement != null && (cachedElement.isDirectory() != file.isDirectory() || !cachedElement.getName().equals(file.getName()))) {
            cachedElement = null;
        }
        if (cachedElement != null && cachedElement.getFile().compareTo(file) == 0) {
            retVal = cachedElement;
        } else {
            retVal = newValue == null ? NamingFactory.createFileNaming(file, parentName, type) : newValue;
            WeakReference<FileNaming> refRetVal = new WeakReference<FileNaming>(retVal);
            boolean isList = value instanceof List;
            if (cachedElement != null || isList) {
                if (isList) {
                    ((List)value).add(refRetVal);
                } else {
                    ArrayList<WeakReference<FileNaming>> l = new ArrayList<WeakReference<FileNaming>>();
                    l.add(refRetVal);
                    nameMap.put(retVal.getId(), l);
                }
            } else {
                Reference r = nameMap.put(retVal.getId(), refRetVal);
            }
        }
        assert (retVal != null);
        return retVal;
    }

    private static Reference getReference(List list, File f) {
        Reference retVal = null;
        for (int i = 0; retVal == null && i < list.size(); ++i) {
            FileNaming cachedElement;
            Reference ref = (Reference)list.get(i);
            FileNaming fileNaming = cachedElement = ref != null ? (FileNaming)ref.get() : null;
            if (cachedElement == null || cachedElement.getFile().compareTo(f) != 0) continue;
            retVal = ref;
        }
        return retVal;
    }

    private static FileNaming createFileNaming(File f, FileNaming parentName, FileType type) {
        FileName retVal = null;
        if (type.equals((Object)FileType.unknown)) {
            type = f.isDirectory() ? FileType.directory : FileType.file;
        }
        switch (type) {
            case file: {
                retVal = new FileName(parentName, f);
                break;
            }
            case directory: {
                retVal = new FolderName(parentName, f);
            }
        }
        return retVal;
    }

    static enum FileType {
        file,
        directory,
        unknown;

    }
}

