/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Color;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.SimpleIndentEngine;
import org.netbeans.modules.editor.lib.ColoringMap;
import org.netbeans.modules.editor.lib.KitsTracker;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.MIMEOptionFolder;
import org.netbeans.modules.editor.options.MIMEOptionNode;
import org.netbeans.modules.editor.options.OptionSupport;
import org.netbeans.modules.editor.options.OptionUtilities;
import org.openide.ServiceType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.IndentEngine;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class BaseOptions
extends OptionSupport {
    private static final Logger LOG = Logger.getLogger(BaseOptions.class.getName());
    protected static final int LATEST_OPTIONS_VERSION = 21;
    protected static final String OPTIONS_VERSION_PROP = "optionsVersion";
    public static final String ABBREV_MAP_PROP = "abbrevMap";
    public static final String BASE = "base";
    public static final String CARET_BLINK_RATE_PROP = "caretBlinkRate";
    public static final String CARET_COLOR_INSERT_MODE_PROP = "caretColorInsertMode";
    public static final String CARET_COLOR_OVERWRITE_MODE_PROP = "caretColorOverwriteMode";
    public static final String CARET_ITALIC_INSERT_MODE_PROP = "caretItalicInsertMode";
    public static final String CARET_ITALIC_OVERWRITE_MODE_PROP = "caretItalicOverwriteMode";
    public static final String CARET_TYPE_INSERT_MODE_PROP = "caretTypeInsertMode";
    public static final String CARET_TYPE_OVERWRITE_MODE_PROP = "caretTypeOverwriteMode";
    public static final String COLORING_MAP_PROP = "coloringMap";
    public static final String EXPAND_TABS_PROP = "expandTabs";
    public static final String FIND_HIGHLIGHT_SEARCH_PROP = "findHighlightSearch";
    public static final String FIND_HISTORY_PROP = "findHistory";
    public static final String FIND_HISTORY_SIZE_PROP = "findHistorySize";
    public static final String FIND_INC_SEARCH_DELAY_PROP = "findIncSearchDelay";
    public static final String FIND_INC_SEARCH_PROP = "findIncSearch";
    public static final String FIND_MATCH_CASE_PROP = "findMatchCase";
    public static final String FIND_REG_EXP_PROP = "findRegExp";
    public static final String FIND_SMART_CASE_PROP = "findSmartCase";
    public static final String FIND_WHOLE_WORDS_PROP = "findWholeWords";
    public static final String FIND_WRAP_SEARCH_PROP = "findWrapSearch";
    public static final String FIND_BLOCK_SEARCH_PROP = "findBlockSearch";
    public static final String FONT_SIZE_PROP = "fontSize";
    public static final String HIGHLIGHT_CARET_ROW_PROP = "highlightCaretRow";
    public static final String HIGHLIGHT_MATCHING_BRACKET_PROP = "highlightMatchingBracket";
    public static final String INDENT_ENGINE_PROP = "indentEngine";
    public static final String KEY_BINDING_LIST_PROP = "keyBindingList";
    public static final String LINE_HEIGHT_CORRECTION_PROP = "lineHeightCorrection";
    public static final String LINE_NUMBER_VISIBLE_PROP = "lineNumberVisible";
    public static final String MACRO_MAP_PROP = "macroMap";
    public static final String MARGIN_PROP = "margin";
    public static final String PAIR_CHARACTERS_COMPLETION = "pairCharactersCompletion";
    public static final String SCROLL_FIND_INSETS_PROP = "scrollFindInsets";
    public static final String SCROLL_JUMP_INSETS_PROP = "scrollJumpInsets";
    public static final String SPACES_PER_TAB_PROP = "spacesPerTab";
    public static final String STATUS_BAR_CARET_DELAY_PROP = "statusBarCaretDelay";
    public static final String STATUS_BAR_VISIBLE_PROP = "statusBarVisible";
    public static final String TAB_SIZE_PROP = "tabSize";
    public static final String TEXT_LIMIT_LINE_COLOR_PROP = "textLimitLineColor";
    public static final String TEXT_LIMIT_LINE_VISIBLE_PROP = "textLimitLineVisible";
    public static final String TEXT_LIMIT_WIDTH_PROP = "textLimitWidth";
    public static final String TOOLBAR_VISIBLE_PROP = "toolbarVisible";
    public static final String TEXT_ANTIALIASING_PROP = "textAntialiasing";
    public static final String CODE_FOLDING_PROPS_PROP = "codeFoldingProps";
    protected static final String[] BASE_PROP_NAMES = new String[]{"abbrevMap", "caretBlinkRate", "caretColorInsertMode", "caretColorOverwriteMode", "caretItalicInsertMode", "caretItalicOverwriteMode", "caretTypeInsertMode", "caretTypeOverwriteMode", "coloringMap", "expandTabs", "fontSize", "highlightCaretRow", "highlightMatchingBracket", "indentEngine", "keyBindingList", "lineHeightCorrection", "macroMap", "margin", "pairCharactersCompletion", "scrollFindInsets", "scrollJumpInsets", "spacesPerTab", "statusBarCaretDelay", "statusBarVisible", "tabSize", "textLimitLineColor", "textLimitLineVisible", "textLimitWidth", "optionsVersion"};
    static final long serialVersionUID = -5469192431366914841L;
    private static final String NO_INDENT_ENGINE = "NO_INDENT_ENGINE";
    private transient int optionsVersion = 21;
    private transient MIMEOptionNode mimeNode;
    private transient MIMEOptionFolder settingsFolder;
    private transient boolean settingsFolderInitialization;
    private static final HashMap kitClass2Options = new HashMap();
    public static final String CODE_TEMPLATE_EXPAND_KEY = "code-template-expand-key";
    private static final String INDENT_ENGINE_HANDLE = "indent-engine-handle";

    public BaseOptions() {
        this(BaseKit.class, BASE);
    }

    public BaseOptions(Class kitClass, String typeName) {
        super(kitClass, typeName);
        kitClass2Options.put(kitClass, this);
    }

    public static BaseOptions getOptions(Class kitClass) {
        String mimeType;
        BaseOptions options = null;
        if (kitClass != BaseKit.class && kitClass != NbEditorKit.class && (mimeType = KitsTracker.getInstance().findMimeType(kitClass)) != null) {
            Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)mimeType));
            options = (BaseOptions)((Object)lookup.lookup(BaseOptions.class));
        }
        if (options == null) {
            for (Class c = kitClass; c != null && (options = (BaseOptions)((Object)kitClass2Options.get(c))) == null; c = c.getSuperclass()) {
                AllOptionsFolder.getDefault().loadMIMEOption(c, false);
                options = (BaseOptions)((Object)kitClass2Options.get(c));
                if (options != null) break;
            }
        }
        return options;
    }

    public boolean isTextAntialiasing() {
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((String)this.getContentType()).lookup(FontColorSettings.class);
        Map hints = (Map)fcs.getFontColors("default").getAttribute(EditorStyleConstants.RenderingHints);
        Object aa = hints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
        return aa == RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
    }

    public void setTextAntialiasing(boolean textAntialiasing) {
        this.getPreferences().putBoolean(TEXT_ANTIALIASING_PROP, textAntialiasing);
    }

    public static void setCodeTemplateExpandKey(KeyStroke ks) {
        Preferences prefs = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
        prefs.put(CODE_TEMPLATE_EXPAND_KEY, Utilities.keyToString((KeyStroke)ks));
    }

    public static KeyStroke getCodeTemplateExpandKey() {
        KeyStroke keyStroke;
        Preferences prefs = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
        String ks = prefs.get(CODE_TEMPLATE_EXPAND_KEY, null);
        if (ks != null && (keyStroke = Utilities.stringToKey((String)ks)) != null) {
            return keyStroke;
        }
        return KeyStroke.getKeyStroke(9, 0);
    }

    public Map<String, String> getDefaultAbbrevMap() {
        return this.getAbbrevMap();
    }

    public Map<String, String> getAbbrevMap() {
        Map map = (Map)Settings.getValue(this.getKitClass(), "abbrev-map", true);
        return map;
    }

    public void setAbbrevMap(Map<String, String> map, boolean saveToXML) {
        throw new UnsupportedOperationException("Use Editor Settings Storage API instead");
    }

    public void setAbbrevMap(Map map) {
        this.setAbbrevMap(map, true);
    }

    public Map<String, MultiKeyBinding> getDefaultKeyBindingsMap() {
        return OptionUtilities.makeKeyBindingsMap(this.getKBList());
    }

    private List<? extends MultiKeyBinding> getKBList() {
        List list = (List)Settings.getValue(this.getKitClass(), "key-bindings", true);
        return list;
    }

    public List getKeyBindingList() {
        ArrayList<? extends MultiKeyBinding> kb2 = new ArrayList<MultiKeyBinding>(this.getKBList());
        kb2.add(0, (MultiKeyBinding)this.getKitClass().getName());
        return kb2;
    }

    public void setKeyBindingList(List list) {
        this.setKeyBindingList(list, true);
    }

    public void setKeyBindingsDiffMap(Map<String, MultiKeyBinding> diffMap) {
        throw new UnsupportedOperationException("Use Editor Settings Storage API instead");
    }

    public void setKeyBindingList(List list, boolean saveToXML) {
        throw new UnsupportedOperationException("Use Editor Settings Storage API instead");
    }

    public Map<String, Coloring> getColoringMap() {
        return new HashMap<String, Coloring>(ColoringMap.get((String)this.getContentType()).getMap());
    }

    public void setColoringMap(Map coloringMap) {
        this.setColoringMap(coloringMap, true);
    }

    public void setColoringMap(Map<String, Coloring> coloringMap, boolean saveToXML) {
        throw new UnsupportedOperationException("Use Editor Settings Storage API instead");
    }

    public int getFontSize() {
        Coloring dc = SettingsUtil.getColoring(this.getKitClass(), "default", false);
        return dc != null ? dc.getFont().getSize() : SettingsDefaults.defaultFont.getSize();
    }

    public void setFontSize(int size) {
        throw new UnsupportedOperationException("Use Editor Settings Storage API instead");
    }

    public float getLineHeightCorrection() {
        return this.getPreferences().getFloat("line-height-correction", 1.0f);
    }

    public void setLineHeightCorrection(float f) {
        if (f <= 0.0f) {
            NbEditorUtilities.invalidArgument((String)"MSG_OutOfRange");
            return;
        }
        this.getPreferences().putFloat("line-height-correction", f);
    }

    public Map getDefaultMacrosMap() {
        return this.getMacroMap();
    }

    public Map getMacroMap() {
        Map settingsMap = (Map)super.getSettingValue("macro-map");
        HashMap<Object, List<? extends MultiKeyBinding>> ret = settingsMap == null ? new HashMap<Object, List<? extends MultiKeyBinding>>() : new HashMap(settingsMap);
        ret.put(null, this.getKBList());
        return ret;
    }

    public void setMacroDiffMap(Map diffMap) {
        throw new UnsupportedOperationException("Use Editor Settings Storage API instead");
    }

    public void setMacroMap(Map macros, boolean saveToXML) {
        throw new UnsupportedOperationException("Use Editor Settings Storage API instead");
    }

    public void setMacroMap(Map macros) {
        this.setMacroMap(macros, true);
    }

    public int getTabSize() {
        return this.getSettingInteger("tab-size");
    }

    public void setTabSize(int tabSize) {
        if (tabSize < 0) {
            NbEditorUtilities.invalidArgument((String)"MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("tab-size", tabSize, TAB_SIZE_PROP);
    }

    public void setExpandTabs(boolean expandTabs) {
        this.setSettingBoolean("expand-tabs", expandTabs, EXPAND_TABS_PROP);
    }

    public void setSpacesPerTab(int i) {
        if (i > 0) {
            this.setSettingInteger("spaces-per-tab", i, SPACES_PER_TAB_PROP);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public String getCaretTypeInsertMode() {
        return this.getPreferences().get("caret-type-insert-mode", "line-caret");
    }

    public void setCaretTypeInsertMode(String type) {
        this.getPreferences().put("caret-type-insert-mode", type);
    }

    public String getCaretTypeOverwriteMode() {
        return this.getPreferences().get("caret-type-overwrite-mode", "block-caret");
    }

    public void setCaretTypeOverwriteMode(String type) {
        this.getPreferences().put("caret-type-overwrite-mode", type);
    }

    public boolean getCaretItalicInsertMode() {
        return false;
    }

    public void setCaretItalicInsertMode(boolean b) {
        throw new UnsupportedOperationException();
    }

    public boolean getCaretItalicOverwriteMode() {
        return false;
    }

    public void setCaretItalicOverwriteMode(boolean b) {
        throw new UnsupportedOperationException();
    }

    public Color getCaretColorInsertMode() {
        return (Color)super.getSettingValue("caret-color-insert-mode");
    }

    public void setCaretColorInsertMode(Color color) {
        this.setCaretColorInsertMode(color, true);
    }

    public void setCaretColorInsertMode(Color color, boolean saveToXML) {
        super.setSettingValue("caret-color-insert-mode", color, CARET_COLOR_INSERT_MODE_PROP);
    }

    public Color getCaretColorOverwriteMode() {
        return (Color)super.getSettingValue("caret-color-overwrite-mode");
    }

    public void setCaretColorOverwriteMode(Color color) {
        this.setCaretColorOverwriteMode(color, true);
    }

    public void setCaretColorOverwriteMode(Color color, boolean saveToXML) {
        super.setSettingValue("caret-color-overwrite-mode", color, CARET_COLOR_OVERWRITE_MODE_PROP);
    }

    public int getCaretBlinkRate() {
        return this.getSettingInteger("caret-blink-rate");
    }

    public void setCaretBlinkRate(int rate) {
        if (rate < 0) {
            NbEditorUtilities.invalidArgument((String)"MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("caret-blink-rate", rate, CARET_BLINK_RATE_PROP);
    }

    public boolean getLineNumberVisible() {
        return this.getSettingBoolean("line-number-visible");
    }

    public void setLineNumberVisible(boolean b) {
        this.setSettingBoolean("line-number-visible", b, LINE_NUMBER_VISIBLE_PROP);
    }

    public Insets getScrollJumpInsets() {
        return (Insets)this.getSettingValue("scroll-jump-insets");
    }

    public void setScrollJumpInsets(Insets i) {
        this.setSettingValue("scroll-jump-insets", i, SCROLL_JUMP_INSETS_PROP);
    }

    public Insets getScrollFindInsets() {
        return (Insets)this.getSettingValue("scroll-find-insets");
    }

    public void setScrollFindInsets(Insets i) {
        this.setSettingValue("scroll-find-insets", i, SCROLL_FIND_INSETS_PROP);
    }

    public Insets getMargin() {
        return (Insets)this.getSettingValue(MARGIN_PROP);
    }

    public void setMargin(Insets i) {
        this.setSettingValue(MARGIN_PROP, i, MARGIN_PROP);
    }

    public boolean getStatusBarVisible() {
        return this.getSettingBoolean("status-bar-visible");
    }

    public void setStatusBarVisible(boolean v) {
        this.setSettingBoolean("status-bar-visible", v, STATUS_BAR_VISIBLE_PROP);
    }

    public int getStatusBarCaretDelay() {
        return this.getSettingInteger("status-bar-caret-delay");
    }

    public void setStatusBarCaretDelay(int delay) {
        if (delay < 0) {
            NbEditorUtilities.invalidArgument((String)"MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("status-bar-caret-delay", delay, STATUS_BAR_CARET_DELAY_PROP);
    }

    public boolean getFindHighlightSearch() {
        return this.getSettingBoolean("find-highlight-search");
    }

    public void setFindHighlightSearch(boolean b) {
        this.setSettingBoolean("find-highlight-search", b, FIND_HIGHLIGHT_SEARCH_PROP);
    }

    public boolean getFindBlockSearch() {
        return this.getSettingBoolean("find-block-search");
    }

    public void setFindBlockSearch(boolean b) {
        this.setSettingBoolean("find-block-search", b, FIND_BLOCK_SEARCH_PROP);
    }

    public boolean getFindIncSearch() {
        return this.getSettingBoolean("find-inc-search");
    }

    public void setFindIncSearch(boolean b) {
        this.setSettingBoolean("find-inc-search", b, FIND_INC_SEARCH_PROP);
    }

    public int getFindIncSearchDelay() {
        return this.getSettingInteger("find-inc-search-delay");
    }

    public void setFindIncSearchDelay(int delay) {
        if (delay < 0) {
            NbEditorUtilities.invalidArgument((String)"MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("find-inc-search-delay", delay, FIND_INC_SEARCH_DELAY_PROP);
    }

    public boolean getFindWrapSearch() {
        return this.getSettingBoolean("find-wrap-search");
    }

    public void setFindWrapSearch(boolean b) {
        this.setSettingBoolean("find-wrap-search", b, FIND_WRAP_SEARCH_PROP);
    }

    public boolean getFindSmartCase() {
        return this.getSettingBoolean("find-smart-case");
    }

    public void setFindSmartCase(boolean b) {
        this.setSettingBoolean("find-smart-case", b, FIND_SMART_CASE_PROP);
    }

    public Map getFindHistory() {
        return Collections.EMPTY_MAP;
    }

    public void setFindHistory(Map m) {
        throw new UnsupportedOperationException();
    }

    public int getFindHistorySize() {
        return this.getSettingInteger("find-history-size");
    }

    public void setFindHistorySize(int size) {
        this.setSettingInteger("find-history-size", size, FIND_HISTORY_SIZE_PROP);
    }

    public boolean getPairCharactersCompletion() {
        return this.getSettingBoolean("pair-characters-completion");
    }

    public void setPairCharactersCompletion(boolean v) {
        this.setSettingBoolean("pair-characters-completion", v, PAIR_CHARACTERS_COMPLETION);
    }

    public Color getTextLimitLineColor() {
        return (Color)super.getSettingValue("text-limit-line-color");
    }

    public void setTextLimitLineColor(Color color) {
        this.setTextLimitLineColor(color, true);
    }

    public void setTextLimitLineColor(Color color, boolean saveToXML) {
        super.setSettingValue("text-limit-line-color", color, TEXT_LIMIT_LINE_COLOR_PROP);
    }

    public int getTextLimitWidth() {
        return this.getSettingInteger("text-limit-width");
    }

    public void setTextLimitWidth(int width) {
        if (width <= 0) {
            NbEditorUtilities.invalidArgument((String)"MSG_OutOfRange");
            return;
        }
        this.setSettingInteger("text-limit-width", width, TEXT_LIMIT_WIDTH_PROP);
    }

    public boolean getTextLimitLineVisible() {
        return this.getSettingBoolean("text-limit-line-visible");
    }

    public void setTextLimitLineVisible(boolean visible) {
        this.setSettingBoolean("text-limit-line-visible", visible, TEXT_LIMIT_LINE_VISIBLE_PROP);
    }

    public boolean getHighlightMatchingBracket() {
        return this.getSettingBoolean("highlight-match-brace");
    }

    public void setHighlightMatchingBracket(boolean highlight) {
        this.setSettingBoolean("highlight-match-brace", highlight, HIGHLIGHT_MATCHING_BRACKET_PROP);
    }

    public boolean getHighlightCaretRow() {
        return this.getSettingBoolean("highlight-caret-row");
    }

    public void setHighlightCaretRow(boolean highlight) {
        this.setSettingBoolean("highlight-caret-row", highlight, HIGHLIGHT_CARET_ROW_PROP);
    }

    public boolean isToolbarVisible() {
        return this.getSettingBoolean(TOOLBAR_VISIBLE_PROP);
    }

    public void setToolbarVisible(boolean toolbarVisible) {
        this.setSettingBoolean(TOOLBAR_VISIBLE_PROP, toolbarVisible, TOOLBAR_VISIBLE_PROP);
    }

    public Map<String, Boolean> getCodeFoldingProps() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        Boolean val = (Boolean)this.getSettingValue("code-folding-enable");
        map.put("code-folding-enable", val);
        return map;
    }

    public void setCodeFoldingProps(Map props) {
        String name = "code-folding-enable";
        this.setSettingValue(name, props.get(name));
    }

    public void initPopupMenuItems() {
    }

    public IndentEngine getIndentEngine() {
        IndentEngine eng;
        Object o;
        Preferences prefs;
        String handle;
        if (!BASE.equals(this.getTypeName()) && (handle = (prefs = (Preferences)MimeLookup.getLookup((MimePath)MimePath.parse((String)this.getContentType())).lookup(Preferences.class)).get(INDENT_ENGINE_HANDLE, null)) != null) {
            Object instance = null;
            if (handle.equals(NO_INDENT_ENGINE)) {
                return IndentEngine.getDefault();
            }
            Lookup.Template tmp = new Lookup.Template(null, handle, null);
            Lookup.Item item = Lookup.getDefault().lookupItem(tmp);
            if (item != null && (instance = item.getInstance()) instanceof IndentEngine) {
                return (IndentEngine)instance;
            }
        }
        if ((o = this.getProperty(INDENT_ENGINE_PROP)) instanceof ServiceType.Handle) {
            eng = (IndentEngine)((ServiceType.Handle)o).getServiceType();
            if (eng != null) {
                this.setIndentEngine(eng);
                return eng;
            }
        } else if (o instanceof IndentEngine) {
            this.setIndentEngine((IndentEngine)o);
            return (IndentEngine)o;
        }
        if ((eng = this.findDefaultIndentEngine()) != null) {
            this.setIndentEngine(eng);
        }
        return eng;
    }

    public void setIndentEngine(IndentEngine eng) {
        String id = null;
        if (eng != null) {
            Lookup.Template tmp = new Lookup.Template(null, null, (Object)eng);
            Lookup.Item item = Lookup.getDefault().lookupItem(tmp);
            if (item != null) {
                id = item.getId();
            }
        }
        if (!BASE.equals(this.getTypeName())) {
            Preferences prefs = (Preferences)MimeLookup.getLookup((MimePath)MimePath.parse((String)this.getContentType())).lookup(Preferences.class);
            if (id == null) {
                id = NO_INDENT_ENGINE;
            }
            prefs.put(INDENT_ENGINE_HANDLE, id);
        }
        this.refreshIndentEngineSettings();
    }

    private void refreshIndentEngineSettings() {
        Settings.update(new Runnable(){

            @Override
            public void run() {
                Settings.touchValue(BaseOptions.this.getKitClass(), BaseOptions.INDENT_ENGINE_PROP);
                Settings.touchValue(BaseOptions.this.getKitClass(), "formatter");
            }

            public boolean asynchronous() {
                return true;
            }
        });
    }

    protected Class getDefaultIndentEngineClass() {
        return SimpleIndentEngine.class;
    }

    private IndentEngine findDefaultIndentEngine() {
        if (this.getDefaultIndentEngineClass() != null) {
            return (IndentEngine)Lookup.getDefault().lookup(this.getDefaultIndentEngineClass());
        }
        return null;
    }

    public void setOptionsVersion(int optionsVersion) {
        int oldOptionsVersion = this.optionsVersion;
        this.optionsVersion = optionsVersion;
        if (optionsVersion != oldOptionsVersion) {
            this.firePropertyChange(OPTIONS_VERSION_PROP, new Integer(oldOptionsVersion), new Integer(optionsVersion));
        }
    }

    public int getOptionsVersion() {
        return this.optionsVersion;
    }

    protected void upgradeOptions(int version, int latestVersion) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MIMEOptionFolder getMIMEFolder() {
        String name = this.getCTImpl();
        if (name == null) {
            return null;
        }
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            if (this.settingsFolderInitialization) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            this.settingsFolderInitialization = true;
            try {
                block16: {
                    FileObject fo;
                    if (this.settingsFolder != null) {
                        MIMEOptionFolder mIMEOptionFolder = this.settingsFolder;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return mIMEOptionFolder;
                    }
                    FileObject f = FileUtil.getConfigFile((String)("Editors/" + name));
                    if (f == null && (fo = FileUtil.getConfigFile((String)"Editors")) != null) {
                        try {
                            FileUtil.createFolder((FileObject)fo, (String)name);
                        }
                        catch (IOException ioe) {
                            LOG.log(Level.WARNING, null, ioe);
                        }
                        f = FileUtil.getConfigFile((String)("Editors/" + name));
                    }
                    if (f != null) {
                        MIMEOptionFolder mIMEOptionFolder;
                        try {
                            DataObject d = DataObject.find((FileObject)f);
                            DataFolder df = (DataFolder)d.getCookie(DataFolder.class);
                            if (df == null) break block16;
                            mIMEOptionFolder = this.settingsFolder = new MIMEOptionFolder(df, this);
                        }
                        catch (DataObjectNotFoundException ex) {
                            LOG.log(Level.WARNING, null, ex);
                            break block16;
                        }
                        return mIMEOptionFolder;
                    }
                }
                MIMEOptionFolder mIMEOptionFolder = null;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return mIMEOptionFolder;
            }
            finally {
                this.settingsFolderInitialization = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIMEOptionNode getMimeNode() {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            if (this.mimeNode == null) {
                this.createMIMENode(this.getTypeName());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mimeNode;
        }
    }

    private void createMIMENode(String typeName) {
        if (typeName.equals(BASE)) {
            return;
        }
        try {
            this.mimeNode = new MIMEOptionNode(this);
        }
        catch (IntrospectionException ie) {
            LOG.log(Level.WARNING, null, ie);
        }
    }

    protected void loadXMLSettings() {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal() throws IOException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
    }
}

