/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.InstalledModuleItem;
import org.netbeans.modules.autoupdate.updateprovider.InstalledUpdateProvider;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class InstalledModuleProvider
implements InstalledUpdateProvider {
    private static InstalledModuleProvider DEFAULT;
    private LookupListener lkpListener;
    private Lookup.Result<ModuleInfo> result = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
    private Map<String, ModuleInfo> moduleInfos;

    public static Map<String, ModuleInfo> getInstalledModules() {
        return InstalledModuleProvider.getDefault().getModuleInfos(false);
    }

    private synchronized Map<String, ModuleInfo> getModuleInfos(boolean force) {
        if (this.moduleInfos == null || force) {
            Collection<ModuleInfo> infos = Collections.unmodifiableCollection(this.result.allInstances());
            this.moduleInfos = new HashMap<String, ModuleInfo>();
            for (ModuleInfo info : infos) {
                this.moduleInfos.put(info.getCodeNameBase(), info);
            }
        }
        assert (this.moduleInfos != null);
        return new HashMap<String, ModuleInfo>(this.moduleInfos);
    }

    public static InstalledModuleProvider getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new InstalledModuleProvider();
        }
        return DEFAULT;
    }

    private InstalledModuleProvider() {
        this.lkpListener = new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                InstalledModuleProvider.this.clearModuleInfos();
            }
        };
        this.result.addLookupListener(this.lkpListener);
    }

    private synchronized void clearModuleInfos() {
        this.moduleInfos = null;
    }

    @Override
    public String getName() {
        return "installed-module-provider";
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Map<String, UpdateItem> getUpdateItems() throws IOException {
        HashMap<String, UpdateItem> res = new HashMap<String, UpdateItem>();
        for (ModuleInfo info : this.getModuleInfos(true).values()) {
            Date time = null;
            String installTime = null;
            if (time != null) {
                installTime = Utilities.formatDate(time);
            }
            InstalledModuleItem impl = new InstalledModuleItem(info.getCodeNameBase(), info.getSpecificationVersion() == null ? null : info.getSpecificationVersion().toString(), info, null, null, installTime);
            UpdateItem updateItem = Utilities.createUpdateItem(impl);
            res.put(info.getCodeName() + '_' + info.getSpecificationVersion(), updateItem);
        }
        return res;
    }

    @Override
    public boolean refresh(boolean force) throws IOException {
        this.getModuleInfos(false);
        return true;
    }

    @Override
    public UpdateUnitProvider.CATEGORY getCategory() {
        return UpdateUnitProvider.CATEGORY.COMMUNITY;
    }
}

