/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jrubyparser.ast.Node;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.IndexSearcher;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class RubyTypeSearcher
implements IndexSearcher {
    private static Pattern camelCasePattern = Pattern.compile("(?:\\p{javaUpperCase}(?:\\p{javaLowerCase}|\\p{Digit}|\\:|\\.|\\$)*){2,}");
    private QuerySupport.Kind cachedKind;
    private String cachedString = "/";

    private static boolean isAllUpper(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isUpperCase(c) || c == ':') continue;
            return false;
        }
        return true;
    }

    private static boolean isCamelCase(String text) {
        return camelCasePattern.matcher(text).matches();
    }

    private QuerySupport.Kind adjustKind(QuerySupport.Kind kind, String text) {
        if (text.equals(this.cachedString)) {
            return this.cachedKind;
        }
        if (kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && (RubyTypeSearcher.isAllUpper(text) && text.length() > 1 || RubyTypeSearcher.isCamelCase(text))) {
            kind = QuerySupport.Kind.CAMEL_CASE;
        }
        this.cachedString = text;
        this.cachedKind = kind;
        return kind;
    }

    public Set<? extends IndexSearcher.Descriptor> getTypes(Project project, String textForQuery, QuerySupport.Kind kind, IndexSearcher.Helper helper) {
        if (textForQuery.endsWith("::")) {
            textForQuery = textForQuery.substring(0, textForQuery.length() - 2);
        } else if (textForQuery.endsWith(":")) {
            textForQuery = textForQuery.substring(0, textForQuery.length() - 1);
        }
        RubyIndex index = RubyIndex.get(QuerySupport.findRoots((Project)project, Collections.singleton("ruby/classpath/source"), Collections.singleton("ruby/classpath/boot"), Collections.emptySet()));
        if (index == null) {
            return Collections.emptySet();
        }
        if ((kind = this.adjustKind(kind, textForQuery)) == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX) {
            textForQuery = textForQuery.toLowerCase();
        }
        String method = null;
        int methodIndex = textForQuery.indexOf(35);
        if (methodIndex != -1) {
            method = textForQuery.substring(methodIndex + 1);
            textForQuery = textForQuery.substring(0, methodIndex);
        }
        Set<IndexedClass> classes = null;
        if (method == null || textForQuery.length() > 0) {
            classes = index.getClasses(textForQuery, kind, true, false, false, null);
        }
        HashSet<RubyTypeDescriptor> result = new HashSet<RubyTypeDescriptor>();
        if (method != null) {
            Set<IndexedMethod> methods = index.getMethods(method, kind);
            block8: for (IndexedMethod m : methods) {
                if (textForQuery.length() > 0 && m.getClz() != null) {
                    String in = m.getClz();
                    switch (kind) {
                        case CASE_INSENSITIVE_REGEXP: 
                        case REGEXP: {
                            try {
                                if (in.indexOf("::") != -1 && textForQuery.indexOf("::") == -1) {
                                    boolean matches = false;
                                    for (String c : in.split("::")) {
                                        if (!c.matches(textForQuery)) continue;
                                        matches = true;
                                        break;
                                    }
                                    if (matches) break;
                                    continue block8;
                                }
                                if (in.matches(textForQuery)) break;
                                continue block8;
                            }
                            catch (Exception e) {
                                break;
                            }
                        }
                        case CASE_INSENSITIVE_PREFIX: {
                            if (in.regionMatches(true, 0, textForQuery, 0, textForQuery.length())) break;
                            continue block8;
                        }
                        case PREFIX: {
                            if (in.regionMatches(false, 0, textForQuery, 0, textForQuery.length())) break;
                            continue block8;
                        }
                        case EXACT: {
                            if (in.equalsIgnoreCase(textForQuery)) break;
                            continue block8;
                        }
                    }
                }
                result.add(new RubyTypeDescriptor(m, helper));
            }
        } else {
            for (IndexedClass cls : classes) {
                if (cls.isVirtual()) continue;
                result.add(new RubyTypeDescriptor(cls, helper));
            }
        }
        return result;
    }

    public Set<? extends IndexSearcher.Descriptor> getSymbols(Project project, String textForQuery, QuerySupport.Kind kind, IndexSearcher.Helper helper) {
        if (textForQuery.indexOf("::") != -1 || textForQuery.indexOf("#") != -1) {
            return this.getTypes(project, textForQuery, kind, helper);
        }
        RubyIndex index = RubyIndex.get(QuerySupport.findRoots((Project)project, Collections.singleton("ruby/classpath/source"), Collections.singleton("ruby/classpath/boot"), Collections.emptySet()));
        if (index == null) {
            return Collections.emptySet();
        }
        if ((kind = this.adjustKind(kind, textForQuery)) == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX) {
            textForQuery = textForQuery.toLowerCase();
        }
        if (textForQuery.length() > 0) {
            HashSet<RubyTypeDescriptor> result = new HashSet<RubyTypeDescriptor>();
            Set<IndexedClass> classes = index.getClasses(textForQuery, kind, true, false, false, null);
            Set<IndexedMethod> methods = index.getMethods(textForQuery, kind);
            for (IndexedClass cls : classes) {
                result.add(new RubyTypeDescriptor(cls, helper));
            }
            for (IndexedMethod mtd : methods) {
                result.add(new RubyTypeDescriptor(mtd, helper));
            }
            return result;
        }
        return null;
    }

    private class RubyTypeDescriptor
    extends IndexSearcher.Descriptor {
        private final IndexedElement element;
        private String projectName;
        private Icon projectIcon;
        private final IndexSearcher.Helper helper;
        private boolean isLibrary;
        private static final String RUBY_KEYWORD = "org/netbeans/modules/ruby/jruby.png";

        public RubyTypeDescriptor(IndexedElement element, IndexSearcher.Helper helper) {
            this.element = element;
            this.helper = helper;
        }

        public Icon getIcon() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.helper.getIcon((ElementHandle)this.element);
        }

        public String getTypeName() {
            return this.element.getName();
        }

        public String getProjectName() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        private void initProjectInfo() {
            FileObject fo = this.element.getFileObject();
            if (fo != null) {
                File f = FileUtil.toFile((FileObject)fo);
                Project p = FileOwnerQuery.getOwner((FileObject)fo);
                if (p != null) {
                    RubyPlatform platform = RubyPlatform.platformFor((Project)p);
                    if (platform != null) {
                        String lib = platform.getLibDir();
                        if (lib != null && f.getPath().startsWith(lib)) {
                            this.projectName = "Ruby Library";
                            this.isLibrary = true;
                        }
                    } else {
                        ProjectInformation pi = ProjectUtils.getInformation((Project)p);
                        this.projectName = pi.getDisplayName();
                        this.projectIcon = pi.getIcon();
                    }
                }
            } else {
                this.isLibrary = true;
                Logger.getLogger(RubyTypeSearcher.class.getName()).fine("No fileobject for " + this.element.toString() + " with fileurl=" + this.element.getFileUrl());
            }
            if (this.projectName == null) {
                this.projectName = "";
            }
        }

        public Icon getProjectIcon() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            if (this.isLibrary) {
                return ImageUtilities.loadImageIcon((String)RUBY_KEYWORD, (boolean)false);
            }
            return this.projectIcon;
        }

        public FileObject getFileObject() {
            return this.element.getFileObject();
        }

        public void open() {
            Node node = AstUtilities.getForeignNode(this.element);
            if (node != null) {
                GsfUtilities.open((FileObject)this.element.getFileObject(), (int)node.getPosition().getStartOffset(), (String)this.element.getName());
                return;
            }
            FileObject fileObject = this.element.getFileObject();
            if (fileObject == null) {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(RubyTypeSearcher.class, (String)"FileDeleted"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                return;
            }
            this.helper.open(fileObject, (ElementHandle)this.element);
        }

        public String getContextName() {
            StringBuilder sb = new StringBuilder();
            String require = this.element.getRequire();
            String fqn = this.element.getFqn();
            if (this.element.getName().equals(fqn)) {
                fqn = null;
            }
            if (fqn != null || require != null) {
                if (fqn != null) {
                    sb.append(fqn);
                }
                if (require != null) {
                    if (fqn != null) {
                        sb.append(" ");
                    }
                    sb.append("in ");
                    sb.append(require);
                    sb.append(".rb");
                }
                return sb.toString();
            }
            return null;
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public int getOffset() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getSimpleName() {
            return this.element.getName();
        }

        public String getOuterName() {
            return null;
        }
    }
}

