/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.LocalVarNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.modules.csl.api.InstantRenamer;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

public class RubyRenameHandler
implements InstantRenamer {
    public boolean isRenameAllowed(ParserResult info, int caretOffset, String[] explanationRetValue) {
        Node parent;
        Node root = AstUtilities.getRoot((Parser.Result)info);
        if (root == null) {
            explanationRetValue[0] = NbBundle.getMessage(RubyRenameHandler.class, (String)"NoRenameWithErrors");
            return false;
        }
        int astOffset = AstUtilities.getAstOffset((Parser.Result)info, caretOffset);
        if (astOffset == -1) {
            return false;
        }
        AstPath path = new AstPath(root, astOffset);
        Node closest = path.leaf();
        if (closest == null) {
            return false;
        }
        if (closest.getNodeType() == NodeType.LOCALVARNODE || closest.getNodeType() == NodeType.LOCALASGNNODE || closest.getNodeType() == NodeType.DVARNODE || closest.getNodeType() == NodeType.DASGNNODE || closest.getNodeType() == NodeType.BLOCKARGNODE) {
            return true;
        }
        if (closest.getNodeType() == NodeType.ARGUMENTNODE && (parent = path.leafParent()) != null && !(parent instanceof MethodDefNode)) {
            return true;
        }
        switch (closest.getNodeType()) {
            case INSTASGNNODE: 
            case INSTVARNODE: 
            case CLASSVARDECLNODE: 
            case CLASSVARNODE: 
            case CLASSVARASGNNODE: 
            case GLOBALASGNNODE: 
            case GLOBALVARNODE: 
            case CONSTDECLNODE: 
            case CONSTNODE: 
            case DEFNNODE: 
            case DEFSNODE: 
            case FCALLNODE: 
            case CALLNODE: 
            case VCALLNODE: 
            case ARGUMENTNODE: 
            case COLON2NODE: 
            case COLON3NODE: 
            case ALIASNODE: 
            case SYMBOLNODE: {
                return true;
            }
        }
        return false;
    }

    public Set<OffsetRange> getRenameRegions(ParserResult info, int caretOffset) {
        Node root = AstUtilities.getRoot((Parser.Result)info);
        if (root == null) {
            return Collections.emptySet();
        }
        HashSet<OffsetRange> regions = new HashSet<OffsetRange>();
        int astOffset = AstUtilities.getAstOffset((Parser.Result)info, caretOffset);
        if (astOffset == -1) {
            return Collections.emptySet();
        }
        AstPath path = new AstPath(root, astOffset);
        Node closest = path.leaf();
        if (closest == null) {
            return Collections.emptySet();
        }
        if (closest instanceof LocalVarNode || closest instanceof LocalAsgnNode) {
            String name = ((INameNode)closest).getName();
            Node localScope = AstUtilities.findLocalScope(closest, path);
            if (localScope == null) {
                localScope = path.leafParent();
                if (localScope.getNodeType() == NodeType.NEWLINENODE) {
                    localScope = path.leafGrandParent();
                }
                if (localScope == null) {
                    localScope = closest;
                }
            }
            this.addLocals(info, localScope, name, regions);
        } else if (closest.getNodeType() == NodeType.DVARNODE || closest.getNodeType() == NodeType.DASGNNODE) {
            String name = ((INameNode)closest).getName();
            List<Node> applicableBlocks = AstUtilities.getApplicableBlocks(path, true);
            for (Node block : applicableBlocks) {
                this.addDynamicVars(info, block, name, regions);
            }
        } else if (closest.getNodeType() == NodeType.ARGUMENTNODE || closest.getNodeType() == NodeType.BLOCKARGNODE) {
            String name = ((INameNode)closest).getName();
            Node parent = path.leafParent();
            if (parent != null && !(parent instanceof MethodDefNode)) {
                MethodDefNode method = AstUtilities.findMethod(path);
                if (method == null) {
                    method = AstUtilities.findBlock(path);
                }
                if (method == null) {
                    method = path.leafParent();
                    if (method.getNodeType() == NodeType.NEWLINENODE) {
                        method = path.leafGrandParent();
                    }
                    if (method == null) {
                        method = closest;
                    }
                }
                this.addLocals(info, (Node)method, name, regions);
            }
        }
        return regions;
    }

    private void addLocals(ParserResult info, Node node, String name, Set<OffsetRange> ranges) {
        OffsetRange range;
        if (node.getNodeType() == NodeType.LOCALVARNODE) {
            if (((INameNode)node).getName().equals(name)) {
                range = AstUtilities.getRange(node);
                if ((range = LexUtilities.getLexerOffsets((Parser.Result)info, range)) != OffsetRange.NONE) {
                    ranges.add(range);
                }
            }
        } else if (node.getNodeType() == NodeType.LOCALASGNNODE) {
            if (((INameNode)node).getName().equals(name)) {
                range = AstUtilities.getRange(node);
                range = new OffsetRange(range.getStart(), range.getStart() + name.length());
                if ((range = LexUtilities.getLexerOffsets((Parser.Result)info, range)) != OffsetRange.NONE) {
                    ranges.add(range);
                }
            }
        } else if (node.getNodeType() == NodeType.ARGSNODE) {
            OffsetRange range2;
            SourcePosition pos;
            ArgumentNode bn;
            ArgsNode an = (ArgsNode)node;
            if (an.getRequiredCount() > 0) {
                List args = an.childNodes();
                for (Node arg : args) {
                    if (!(arg instanceof ListNode)) continue;
                    List args2 = arg.childNodes();
                    for (Node arg2 : args2) {
                        OffsetRange range3;
                        if (arg2.getNodeType() == NodeType.ARGUMENTNODE) {
                            if (!((ArgumentNode)arg2).getName().equals(name)) continue;
                            range3 = AstUtilities.getRange(arg2);
                            if ((range3 = LexUtilities.getLexerOffsets((Parser.Result)info, range3)) == OffsetRange.NONE) continue;
                            ranges.add(range3);
                            continue;
                        }
                        if (arg2.getNodeType() != NodeType.LOCALASGNNODE || !((LocalAsgnNode)arg2).getName().equals(name)) continue;
                        range3 = AstUtilities.getRange(arg2);
                        range3 = new OffsetRange(range3.getStart(), range3.getStart() + name.length());
                        if ((range3 = LexUtilities.getLexerOffsets((Parser.Result)info, range3)) == OffsetRange.NONE) continue;
                        ranges.add(range3);
                    }
                }
            }
            if (an.getRest() != null && (bn = an.getRest()).getName().equals(name)) {
                pos = bn.getPosition();
                range2 = new OffsetRange(pos.getStartOffset() + 1, pos.getEndOffset());
                if ((range2 = LexUtilities.getLexerOffsets((Parser.Result)info, range2)) != OffsetRange.NONE) {
                    ranges.add(range2);
                }
            }
            if (an.getBlock() != null && (bn = an.getBlock()).getName().equals(name)) {
                pos = bn.getPosition();
                range2 = new OffsetRange(pos.getStartOffset() + 1, pos.getEndOffset());
                if ((range2 = LexUtilities.getLexerOffsets((Parser.Result)info, range2)) != OffsetRange.NONE) {
                    ranges.add(range2);
                }
            }
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            this.addLocals(info, child, name, ranges);
        }
    }

    private void addDynamicVars(ParserResult info, Node node, String name, Set<OffsetRange> ranges) {
        switch (node.getNodeType()) {
            case DVARNODE: {
                if (!((INameNode)node).getName().equals(name)) break;
                OffsetRange range = AstUtilities.getRange(node);
                if ((range = LexUtilities.getLexerOffsets((Parser.Result)info, range)) == OffsetRange.NONE) break;
                ranges.add(range);
                break;
            }
            case DASGNNODE: {
                if (!((INameNode)node).getName().equals(name)) break;
                OffsetRange range = AstUtilities.getRange(node);
                range = new OffsetRange(range.getStart(), range.getStart() + name.length());
                if ((range = LexUtilities.getLexerOffsets((Parser.Result)info, range)) == OffsetRange.NONE) break;
                ranges.add(range);
            }
        }
        List list = node.childNodes();
        block7: for (Node child : list) {
            if (child.isInvisible()) continue;
            switch (child.getNodeType()) {
                case DEFNNODE: 
                case DEFSNODE: 
                case ITERNODE: 
                case CLASSNODE: 
                case SCLASSNODE: 
                case MODULENODE: {
                    continue block7;
                }
            }
            this.addDynamicVars(info, child, name, ranges);
        }
    }
}

