/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.usages;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.IndexDocument;
import org.netbeans.modules.gsf.api.IndexDocumentFactory;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.netbeans.modules.gsfret.source.usages.IndexBatchEntry;
import org.netbeans.modules.gsfret.source.usages.IndexDocumentImpl;
import org.netbeans.modules.gsfret.source.usages.RepositoryUpdater;
import org.netbeans.modules.gsfret.source.usages.SourceAnalyser;

public class CachingIndexer {
    private static final int CACHE_INDEX_SIZE = 300;
    private static final Logger LOGGER = Logger.getLogger(RepositoryUpdater.class.getName());
    private URL root;
    private int fileCountGuess;
    private Map<Language, LanguageIndex> indices = new HashMap<Language, LanguageIndex>();

    public static CachingIndexer get(URL root, int size) {
        return new CachingIndexer(size, root);
    }

    public CachingIndexer(int fileCountGuess, URL root) {
        this.fileCountGuess = Math.min(2000, fileCountGuess);
        this.root = root;
    }

    private LanguageIndex getLanguageIndex(Language language) throws IOException {
        LanguageIndex li = this.indices.get(language);
        if (li == null) {
            ClassIndexImpl uqImpl = ClassIndexManager.get(language).createUsagesQuery(this.root, true);
            assert (uqImpl != null);
            SourceAnalyser analyzer = uqImpl.getSourceAnalyser();
            assert (analyzer != null);
            ArrayList<IndexBatchEntry> batchList = new ArrayList<IndexBatchEntry>(this.fileCountGuess);
            boolean create = analyzer.hasData();
            li = new LanguageIndex(analyzer, batchList, create, language);
            this.indices.put(language, li);
        }
        return li;
    }

    public void flush() throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "FLUSHING INDEX for root " + this.root);
        }
        for (LanguageIndex li : this.indices.values()) {
            li.flush();
        }
    }

    public void index(Language language, File file, Iterable<ParserResult> trees) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Stashing index documents for file " + file);
        }
        LanguageIndex li = this.getLanguageIndex(language);
        li.index(file, trees);
    }

    public void remove(Language language, String url) throws IOException {
        LanguageIndex li = this.getLanguageIndex(language);
        li.remove(url);
    }

    private static final class LanguageIndex
    implements IndexDocumentFactory {
        final SourceAnalyser analyzer;
        final List<IndexBatchEntry> entries;
        private int size;
        private boolean create;
        private final Language language;

        public LanguageIndex(SourceAnalyser analyzer, List<IndexBatchEntry> entries, boolean create, Language language) {
            this.analyzer = analyzer;
            this.entries = entries;
            this.create = create;
            this.language = language;
        }

        public SourceAnalyser getAnalyzer() {
            return this.analyzer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Flushing index for " + this.language.getDisplayName() + "; the number of stashed documents is " + this.entries.size());
                }
                if (this.entries.size() > 0) {
                    this.analyzer.batchStore(this.entries, this.create);
                    this.entries.clear();
                }
            }
            finally {
                this.create = false;
            }
        }

        public void index(File file, Iterable<ParserResult> trees) throws IOException {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Stashing index documents for file " + file);
            }
            Indexer indexer = this.language.getIndexer();
            assert (indexer != null) : this.language;
            if (indexer != null) {
                String fileUrl = indexer.getPersistentUrl(file);
                for (ParserResult result : trees) {
                    List<IndexDocumentImpl> documents = indexer.index(result, (IndexDocumentFactory)this);
                    if (documents == null) {
                        documents = Collections.emptyList();
                    }
                    IndexBatchEntry entry = new IndexBatchEntry(fileUrl, this.language, documents, this.analyzer);
                    this.entries.add(entry);
                }
                ++this.size;
                if (this.size == 300) {
                    this.flush();
                    this.size = 0;
                }
            }
        }

        private void remove(String fileUrl) {
            Indexer indexer = this.language.getIndexer();
            assert (indexer != null) : this.language;
            if (indexer != null) {
                IndexBatchEntry entry = new IndexBatchEntry(fileUrl, this.language, null, this.analyzer);
                this.entries.add(entry);
                ++this.size;
            }
        }

        public IndexDocument createDocument(int initialPairs) {
            return new IndexDocumentImpl(initialPairs);
        }

        public IndexDocument createDocument(int initialPairs, String overrideUrl) {
            return new IndexDocumentImpl(initialPairs, overrideUrl);
        }
    }
}

