/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.EjbRefsTablePanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityRolePanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityRoleTableModel;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class SecurityRoleTablePanel
extends DefaultTablePanel {
    private SecurityRoleTableModel model;
    private WebApp webApp;
    private DDDataObject dObj;

    public SecurityRoleTablePanel(final DDDataObject dDDataObject, final SecurityRoleTableModel securityRoleTableModel) {
        super((AbstractTableModel)securityRoleTableModel);
        this.model = securityRoleTableModel;
        this.dObj = dDDataObject;
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                dDDataObject.modelUpdatedFromUI();
                dDDataObject.setChangedFromUI(true);
                int n = SecurityRoleTablePanel.this.getTable().getSelectedRow();
                securityRoleTableModel.removeRow(n);
                dDDataObject.setChangedFromUI(false);
            }
        });
        this.editButton.addActionListener(new TableActionListener(false));
        this.addButton.addActionListener(new TableActionListener(true));
    }

    void setModel(WebApp webApp, SecurityRole[] securityRoleArray) {
        this.model.setData((CommonDDBean)webApp, (CommonDDBean[])securityRoleArray);
        this.webApp = webApp;
    }

    private class TableActionListener
    implements ActionListener {
        private boolean add;

        TableActionListener(boolean bl) {
            this.add = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.add ? -1 : SecurityRoleTablePanel.this.getTable().getSelectedRow();
            final SecurityRolePanel securityRolePanel = new SecurityRolePanel();
            Object var4_4 = null;
            SecurityRole securityRole = null;
            if (!this.add) {
                securityRole = SecurityRoleTablePanel.this.model.getSecurityRole(n);
                securityRolePanel.setRoleName(securityRole.getRoleName());
                securityRolePanel.setDescription(securityRole.getDefaultDescription());
            }
            final SecurityRole securityRole2 = securityRole;
            EditDialog editDialog = new EditDialog(securityRolePanel, NbBundle.getMessage(EjbRefsTablePanel.class, (String)"TTL_SecurityRole"), this.add){

                protected String validate() {
                    String string = securityRolePanel.getRoleName().trim();
                    if (string.length() == 0) {
                        return NbBundle.getMessage(SecurityRoleTablePanel.class, (String)"TXT_EmptySecurityRoleName");
                    }
                    SecurityRole[] securityRoleArray = SecurityRoleTablePanel.this.webApp.getSecurityRole();
                    boolean bl = false;
                    for (int i = 0; i < securityRoleArray.length; ++i) {
                        if (!string.equals(securityRoleArray[i].getRoleName()) || securityRoleArray[i] == securityRole2) continue;
                        return NbBundle.getMessage(SecurityRoleTablePanel.class, (String)"TXT_SecurityRoleNameExists", (Object)string);
                    }
                    return null;
                }
            };
            if (this.add) {
                editDialog.setValid(false);
            }
            EditDialog.DocListener docListener = new EditDialog.DocListener(editDialog);
            securityRolePanel.getRoleNameTF().getDocument().addDocumentListener((DocumentListener)docListener);
            securityRolePanel.getDescriptionTA().getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)editDialog);
            dialog.setVisible(true);
            securityRolePanel.getRoleNameTF().getDocument().removeDocumentListener((DocumentListener)docListener);
            securityRolePanel.getDescriptionTA().getDocument().removeDocumentListener((DocumentListener)docListener);
            if (editDialog.getValue().equals(EditDialog.OK_OPTION)) {
                SecurityRoleTablePanel.this.dObj.modelUpdatedFromUI();
                SecurityRoleTablePanel.this.dObj.setChangedFromUI(true);
                String string = securityRolePanel.getRoleName();
                String string2 = securityRolePanel.getDescription();
                if (this.add) {
                    SecurityRoleTablePanel.this.model.addRow(new String[]{string, string2});
                } else {
                    SecurityRoleTablePanel.this.model.editRow(n, new String[]{string, string2});
                }
                SecurityRoleTablePanel.this.dObj.setChangedFromUI(false);
            }
        }
    }
}

