/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.retriever.Retriever;
import org.netbeans.modules.xml.retriever.XMLCatalogProvider;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModelFactory;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.retriever.impl.RetrieverImpl;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.spi.project.CacheDirectoryProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class Util {
    private Util() {
    }

    public static boolean retrieveAndCache(URI locationURI, FileObject sourceFileObject, boolean newThread) {
        FileObject cacheFO;
        URI privateCatalogURI = null;
        URI privateCacheURI = null;
        Project prj = FileOwnerQuery.getOwner((FileObject)sourceFileObject);
        if (prj == null) {
            return false;
        }
        FileObject prjrtfo = prj.getProjectDirectory();
        File prjrt = FileUtil.toFile((FileObject)prjrtfo);
        if (prjrt == null) {
            return false;
        }
        CacheDirectoryProvider cdp = (CacheDirectoryProvider)prj.getLookup().lookup(CacheDirectoryProvider.class);
        String catalogstr = "private/cache/retriever/catalog.xml";
        String cachestr = "private/cache/retriever";
        try {
            if (cdp != null && cdp.getCacheDirectory() != null) {
                URI prjrturi = prjrt.toURI();
                URI cpduri = FileUtil.toFile((FileObject)cdp.getCacheDirectory()).toURI();
                String cachedirstr = Utilities.relativize(prjrturi, cpduri);
                catalogstr = cachedirstr + "/" + "retriever/catalog.xml";
                cachestr = cachedirstr + "/" + "retriever";
            }
            privateCatalogURI = new URI(catalogstr);
            privateCacheURI = new URI(cachestr);
        }
        catch (Exception e) {
            return false;
        }
        URI cacheURI = prjrt.toURI().resolve(privateCacheURI);
        File cacheFile = new File(cacheURI);
        if (!cacheFile.isDirectory()) {
            cacheFile.mkdirs();
        }
        if ((cacheFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)cacheFile))) == null) {
            return false;
        }
        Retriever ret = Retriever.getDefault();
        try {
            ((RetrieverImpl)ret).setNewThread(newThread);
            FileObject result = ret.retrieveResource(cacheFO, privateCatalogURI, locationURI);
        }
        catch (UnknownHostException ex) {
            Object result = null;
        }
        catch (IOException ex) {
            Object result = null;
        }
        catch (URISyntaxException ex) {
            Object result = null;
        }
        XMLCatalogProvider catProv = (XMLCatalogProvider)prj.getLookup().lookup(XMLCatalogProvider.class);
        FileObject publicCatFO = null;
        FileObject peerCatFO = null;
        if (catProv != null) {
            URI peercatURI;
            URI peerCatURI;
            URI pubcatURI;
            URI publicCatURI = catProv.getProjectWideCatalog();
            if (publicCatURI != null && (pubcatURI = prjrt.toURI().resolve(publicCatURI)) != null) {
                File pubcatFile = new File(pubcatURI);
                if (!pubcatFile.isFile()) {
                    try {
                        pubcatFile.createNewFile();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                publicCatFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)pubcatFile));
            }
            if ((peerCatURI = catProv.getCatalog(sourceFileObject)) != null && (peercatURI = prjrt.toURI().resolve(peerCatURI)) != null) {
                File peercatFile = new File(peercatURI);
                if (!peercatFile.isFile()) {
                    try {
                        peercatFile.createNewFile();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                peerCatFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)peercatFile));
            }
        }
        URI cacheCatFullURI = FileUtil.toFile((FileObject)prjrtfo).toURI().resolve(privateCatalogURI);
        CatalogWriteModel catWriter = null;
        try {
            catWriter = publicCatFO == null ? CatalogWriteModelFactory.getInstance().getCatalogWriteModelForProject(sourceFileObject) : CatalogWriteModelFactory.getInstance().getCatalogWriteModelForCatalogFile(publicCatFO);
        }
        catch (CatalogModelException ex) {
            // empty catch block
        }
        if (catWriter == null) {
            return true;
        }
        try {
            catWriter.addNextCatalog(cacheCatFullURI, true);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (publicCatFO != peerCatFO) {
            catWriter = null;
            try {
                catWriter = peerCatFO == null ? CatalogWriteModelFactory.getInstance().getCatalogWriteModelForProject(sourceFileObject) : CatalogWriteModelFactory.getInstance().getCatalogWriteModelForCatalogFile(peerCatFO);
            }
            catch (CatalogModelException ex) {
                // empty catch block
            }
            if (catWriter == null) {
                return true;
            }
            try {
                catWriter.addNextCatalog(cacheCatFullURI, true);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return true;
    }

    public static FileObject getProjectCatalogFileObject(Project prj, boolean create) throws IOException {
        String fileName;
        URI caturi;
        if (prj == null) {
            return null;
        }
        FileObject result = null;
        FileObject myProjectRootFileObject = prj.getProjectDirectory();
        XMLCatalogProvider catProv = (XMLCatalogProvider)prj.getLookup().lookup(XMLCatalogProvider.class);
        if (catProv != null && (caturi = catProv.getProjectWideCatalog()) != null) {
            caturi = FileUtil.toFile((FileObject)myProjectRootFileObject).toURI().resolve(caturi);
            File catFile = new File(caturi);
            if (!catFile.isFile()) {
                catFile.createNewFile();
            }
            result = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)catFile));
        }
        if (result == null && (result = myProjectRootFileObject.getFileObject(fileName = "catalog.xml")) == null && create) {
            result = myProjectRootFileObject.createData(fileName);
        }
        return result;
    }
}

