/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.ExceptionListener;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.dlg.ConnectPanel;
import org.netbeans.modules.db.explorer.dlg.ConnectProgressDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.netbeans.modules.db.explorer.node.ConnectionNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ConnectAction
extends BaseAction {
    private static final Logger LOGGER = Logger.getLogger(ConnectAction.class.getName());
    ConnectionDialog dlg;
    boolean advancedPanel = false;
    boolean okPressed = false;

    public String getName() {
        return NbBundle.getMessage(ConnectAction.class, (String)"Connect");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ConnectAction.class);
    }

    protected boolean enable(Node[] activatedNodes) {
        Lookup lookup;
        ConnectionNode node;
        boolean enabled = false;
        if (activatedNodes.length == 1 && (node = (ConnectionNode)((Object)(lookup = activatedNodes[0].getLookup()).lookup(ConnectionNode.class))) != null) {
            DatabaseConnection dbconn = (DatabaseConnection)lookup.lookup(DatabaseConnection.class);
            enabled = dbconn.getConnector().isDisconnected();
        }
        return enabled;
    }

    public void performAction(Node[] activatedNodes) {
        ConnectionNode node = (ConnectionNode)((Object)activatedNodes[0].getLookup().lookup(ConnectionNode.class));
        new ConnectionDialogDisplayer().showDialog(node, false);
    }

    public static final class ConnectionDialogDisplayer
    extends ConnectionDialogMediator {
        ConnectionDialog dlg;
        boolean advancedPanel = false;
        boolean okPressed = false;
        boolean failed = false;
        final ExceptionListener excListener = new ExceptionListener(){

            @Override
            public void exceptionOccurred(Exception exc) {
                if (exc instanceof DDLException) {
                    LOGGER.log(Level.INFO, null, exc.getCause());
                } else {
                    LOGGER.log(Level.INFO, null, exc);
                }
                String message = null;
                if (exc instanceof ClassNotFoundException) {
                    message = MessageFormat.format(NbBundle.getMessage(ConnectAction.class, (String)"EXC_ClassNotFound"), exc.getMessage());
                } else {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append(DbUtilities.formatError(NbBundle.getMessage(ConnectAction.class, (String)"ERR_UnableToConnect"), exc.getMessage()));
                    if (exc instanceof DDLException && exc.getCause() instanceof SQLException) {
                        for (SQLException sqlEx = ((SQLException)exc.getCause()).getNextException(); sqlEx != null; sqlEx = sqlEx.getNextException()) {
                            buffer.append("\n\n").append(sqlEx.getMessage());
                        }
                    }
                    message = buffer.toString();
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
            }
        };

        public void showDialog(ConnectionNode model, boolean showDialog) {
            DatabaseConnection dbcon = (DatabaseConnection)model.getLookup().lookup(DatabaseConnection.class);
            this.showDialog(dbcon, showDialog);
        }

        public void showDialog(final DatabaseConnection dbcon, boolean showDialog) {
            final DatabaseConnector connector = dbcon.getConnector();
            String user = dbcon.getUser();
            String pwd = dbcon.getPassword();
            boolean remember = dbcon.rememberPassword();
            dbcon.addExceptionListener(this.excListener);
            if (user == null || !remember || showDialog) {
                final ConnectPanel basePanel = new ConnectPanel(this, dbcon);
                final SchemaPanel schemaPanel = new SchemaPanel(this, dbcon);
                PropertyChangeListener argumentListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        if (event.getPropertyName().equals("argumentChanged")) {
                            schemaPanel.setSchemas(Collections.EMPTY_LIST, "");
                            schemaPanel.resetProgress();
                            try {
                                Connection conn = dbcon.getConnection();
                                if (DatabaseConnection.isVitalConnection(conn, null)) {
                                    conn.close();
                                }
                            }
                            catch (SQLException exc) {
                                Exceptions.printStackTrace((Throwable)exc);
                            }
                        }
                    }
                };
                basePanel.addPropertyChangeListener(argumentListener);
                PropertyChangeListener connectionListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        if (event.getPropertyName().equals("connecting")) {
                            ConnectionDialogDisplayer.this.fireConnectionStarted();
                        }
                        if (event.getPropertyName().equals("failed")) {
                            ConnectionDialogDisplayer.this.fireConnectionFailed();
                        }
                        if (event.getPropertyName().equals("connected")) {
                            if (ConnectionDialogDisplayer.this.advancedPanel && !ConnectionDialogDisplayer.this.okPressed) {
                                if (ConnectionDialogDisplayer.this.retrieveSchemas(schemaPanel, dbcon, dbcon.getSchema())) {
                                    dbcon.setSchema(dbcon.getSchema());
                                }
                                ConnectionDialogDisplayer.this.dlg.setSelectedComponent(schemaPanel);
                                ConnectionDialogDisplayer.this.fireConnectionFinished();
                                return;
                            }
                            ConnectionDialogDisplayer.this.fireConnectionFinished();
                            dbcon.setSchema(dbcon.getSchema());
                            try {
                                connector.finishConnect(null, dbcon, dbcon.getConnection());
                            }
                            catch (DatabaseException exc) {
                                LOGGER.log(Level.INFO, exc.getLocalizedMessage(), exc);
                                DbUtilities.reportError(NbBundle.getMessage(ConnectAction.class, (String)"ERR_UnableToInitializeConnection"), exc.getMessage());
                                return;
                            }
                            DatabaseConnection realDbcon = ConnectionList.getDefault().getConnection(dbcon);
                            if (realDbcon != null) {
                                realDbcon.setPassword(dbcon.getPassword());
                                realDbcon.setRememberPassword(dbcon.rememberPassword());
                            }
                            dbcon.setRememberPassword(basePanel.rememberPassword());
                            if (ConnectionDialogDisplayer.this.dlg != null) {
                                ConnectionDialogDisplayer.this.dlg.close();
                            }
                            dbcon.fireConnectionComplete();
                        } else {
                            ConnectionDialogDisplayer.this.okPressed = false;
                        }
                    }
                };
                dbcon.addPropertyChangeListener(connectionListener);
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        if (event.getSource() == DialogDescriptor.OK_OPTION) {
                            ConnectionDialogDisplayer.this.okPressed = true;
                            dbcon.setUser(basePanel.getUser());
                            dbcon.setPassword(basePanel.getPassword());
                            dbcon.setUser(basePanel.getUser());
                            dbcon.setPassword(basePanel.getPassword());
                            dbcon.setRememberPassword(basePanel.rememberPassword());
                            if (!DatabaseConnection.isVitalConnection(dbcon.getConnection(), null)) {
                                dbcon.connectAsync();
                            } else {
                                dbcon.setSchema(schemaPanel.getSchema());
                                dbcon.setSchema(schemaPanel.getSchema());
                                try {
                                    connector.finishConnect(null, dbcon, dbcon.getConnection());
                                }
                                catch (DatabaseException exc) {
                                    LOGGER.log(Level.INFO, exc.getLocalizedMessage(), exc);
                                    DbUtilities.reportError(NbBundle.getMessage(ConnectAction.class, (String)"ERR_UnableToInitializeConnection"), exc.getMessage());
                                    return;
                                }
                                DatabaseConnection realDbcon = ConnectionList.getDefault().getConnection(dbcon);
                                if (realDbcon != null) {
                                    realDbcon.setPassword(dbcon.getPassword());
                                    realDbcon.setRememberPassword(basePanel.rememberPassword());
                                }
                                dbcon.setRememberPassword(basePanel.rememberPassword());
                                if (ConnectionDialogDisplayer.this.dlg != null) {
                                    ConnectionDialogDisplayer.this.dlg.close();
                                }
                                dbcon.fireConnectionComplete();
                            }
                            return;
                        }
                    }
                };
                ChangeListener changeTabListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        if (((JTabbedPane)e.getSource()).getSelectedComponent().equals(schemaPanel)) {
                            ConnectionDialogDisplayer.this.advancedPanel = true;
                            dbcon.setUser(basePanel.getUser());
                            dbcon.setPassword(basePanel.getPassword());
                        } else {
                            ConnectionDialogDisplayer.this.advancedPanel = false;
                        }
                    }
                };
                this.dlg = new ConnectionDialog(this, basePanel, remember ? schemaPanel : null, basePanel.getTitle(), new HelpCtx("db_save_password"), actionListener, changeTabListener);
                this.dlg.setVisible(true);
            } else {
                try {
                    DialogDescriptor descriptor = null;
                    ProgressHandle progress = null;
                    progress = ProgressHandleFactory.createHandle((String)"handle");
                    JComponent progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progress);
                    progressComponent.setPreferredSize(new Dimension(350, 20));
                    ConnectProgressDialog panel = new ConnectProgressDialog(progressComponent);
                    panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectAction.class, (String)"ACS_ConnectingDialogTextA11yDesc"));
                    descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(ConnectAction.class, (String)"ConnectingDialogTitle"), true, new Object[]{DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.CANCEL_OPTION, 0, null, null);
                    final Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
                    PropertyChangeListener connectionListener = new PropertyChangeListener(){

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Override
                        public void propertyChange(PropertyChangeEvent event) {
                            if (event.getPropertyName().equals("connected")) {
                                try {
                                    connector.finishConnect(null, dbcon, dbcon.getConnection());
                                    if (dialog == null) return;
                                    dialog.setVisible(false);
                                    return;
                                }
                                catch (DatabaseException exc) {
                                    LOGGER.log(Level.INFO, exc.getLocalizedMessage(), exc);
                                    DbUtilities.reportError(NbBundle.getMessage(ConnectAction.class, (String)"ERR_UnableToInitializeConnection"), exc.getMessage());
                                    return;
                                }
                            } else {
                                if (!event.getPropertyName().equals("failed")) return;
                                if (dialog != null) {
                                    dialog.setVisible(false);
                                }
                                ConnectionDialogDisplayer.this.failed = true;
                            }
                        }
                    };
                    this.failed = false;
                    dbcon.addPropertyChangeListener(connectionListener);
                    dbcon.connectAsync();
                    progress.start();
                    progress.switchToIndeterminate();
                    dialog.setVisible(true);
                    progress.finish();
                    dialog.dispose();
                    if (this.failed) {
                        this.showDialog(dbcon, true);
                    } else {
                        dbcon.fireConnectionComplete();
                    }
                }
                catch (Exception exc) {
                    String message = MessageFormat.format(NbBundle.getMessage(ConnectAction.class, (String)"ERR_UnableToConnect"), exc.getMessage());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                    this.showDialog(dbcon, true);
                }
            }
            dbcon.removeExceptionListener(this.excListener);
        }

        @Override
        protected boolean retrieveSchemas(SchemaPanel schemaPanel, DatabaseConnection dbcon, String defaultSchema) {
            this.fireConnectionStep(NbBundle.getMessage(ConnectAction.class, (String)"ConnectionProgress_Schemas"));
            ArrayList<String> schemas = new ArrayList<String>();
            try {
                ResultSet rs;
                DatabaseMetaData dbMetaData = dbcon.getConnection().getMetaData();
                if (dbMetaData.supportsSchemasInTableDefinitions() && (rs = dbMetaData.getSchemas()) != null) {
                    while (rs.next()) {
                        schemas.add(rs.getString(1).trim());
                    }
                }
            }
            catch (SQLException exc) {
                String message = NbBundle.getMessage(ConnectAction.class, (String)"ERR_UnableObtainSchemas", (Object)exc.getMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
            }
            return schemaPanel.setSchemas(schemas, defaultSchema);
        }
    }
}

