/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.execution;

import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.spi.toolchain.ErrorParserProvider;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public abstract class ErrorParser
implements ErrorParserProvider.ErrorParser {
    protected FileObject relativeTo;
    protected final ExecutionEnvironment execEnv;

    public ErrorParser(ExecutionEnvironment execEnv, FileObject relativeTo) {
        this.relativeTo = relativeTo;
        this.execEnv = execEnv;
    }

    protected FileObject resolveFile(String fileName) {
        if (Utilities.isWindows()) {
            if (fileName.startsWith("/cygdrive/")) {
                fileName = fileName.substring("/cygdrive/".length());
                fileName = "" + fileName.charAt(0) + ':' + fileName.substring(1);
            } else if (fileName.length() > 3 && fileName.charAt(0) == '/' && fileName.charAt(2) == '/') {
                fileName = "" + fileName.charAt(1) + ':' + fileName.substring(2);
            }
            if (fileName.startsWith("/") || fileName.startsWith(".")) {
                return null;
            }
            fileName = fileName.replace('/', '\\');
        }
        fileName = HostInfoProvider.getMapper((ExecutionEnvironment)this.execEnv).getLocalPath(fileName, true);
        File file = CndFileUtils.normalizeFile((File)new File(fileName));
        return FileUtil.toFileObject((File)file);
    }

    protected FileObject resolveRelativePath(FileObject relativeDir, String relativePath) {
        FileObject myObj;
        if (ToolUtils.isPathAbsolute(relativePath)) {
            if (this.execEnv.isRemote() || Utilities.isWindows()) {
                String absPath1 = relativePath;
                String absPath2 = null;
                if (absPath1.startsWith("/usr/lib")) {
                    absPath2 = absPath1.substring(4);
                }
                List<CompilerSet> compilerSets = CompilerSetManager.get(this.execEnv).getCompilerSets();
                for (CompilerSet set : compilerSets) {
                    Tool cCompiler = set.getTool(PredefinedToolKind.CCompiler);
                    if (cCompiler == null) continue;
                    String includePrefix = cCompiler.getIncludeFilePathPrefix();
                    File file = new File(includePrefix + absPath1);
                    if (!CndFileUtils.exists((File)file) && absPath2 != null) {
                        file = new File(includePrefix + absPath2);
                    }
                    if (!CndFileUtils.exists((File)file)) continue;
                    FileObject fo = FileUtil.toFileObject((File)CndFileUtils.normalizeFile((File)file));
                    return fo;
                }
            }
            if ((myObj = this.resolveFile(relativePath)) != null) {
                return myObj;
            }
            if (relativePath.startsWith(File.separator)) {
                relativePath = relativePath.substring(1);
            }
            try {
                FileSystem fs = relativeDir.getFileSystem();
                myObj = fs.findResource(relativePath);
                if (myObj != null) {
                    return myObj;
                }
                myObj = fs.getRoot();
                if (myObj != null) {
                    relativeDir = myObj;
                }
            }
            catch (FileStateInvalidException ex) {
                // empty catch block
            }
        }
        myObj = relativeDir;
        String delims = Utilities.isWindows() ? File.separator + '/' : File.separator;
        StringTokenizer st = new StringTokenizer(relativePath, delims);
        while (myObj != null && st.hasMoreTokens()) {
            String nameExt = st.nextToken();
            if ("..".equals(nameExt)) {
                myObj = myObj.getParent();
                continue;
            }
            if (".".equals(nameExt)) continue;
            myObj = myObj.getFileObject(nameExt, null);
        }
        return myObj;
    }
}

