/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.repository.translator.RepositoryTranslatorImpl;

public class IntToStringCache {
    protected final List<String> cache;
    protected final int version;
    protected final long timestamp;
    private final Object oneItemCacheLock = new Lock();
    private String oneItemCacheString;
    private int oneItemCacheInt;

    public IntToStringCache() {
        this(System.currentTimeMillis());
    }

    public IntToStringCache(long timestamp) {
        this.cache = new ArrayList<String>();
        this.version = RepositoryTranslatorImpl.getVersion();
        this.timestamp = timestamp;
    }

    public IntToStringCache(DataInput stream) throws IOException {
        assert (stream != null);
        this.cache = new ArrayList<String>();
        this.version = stream.readInt();
        this.timestamp = stream.readLong();
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            String value = stream.readUTF();
            value = value.equals("") ? null : this.getFileKey(value);
            this.cache.add(value);
        }
    }

    public void write(DataOutput stream) throws IOException {
        assert (this.cache != null);
        assert (stream != null);
        stream.writeInt(this.version);
        stream.writeLong(this.timestamp);
        int size = this.cache.size();
        stream.writeInt(size);
        for (int i = 0; i < size; ++i) {
            String value = this.cache.get(i);
            if (value == null) {
                stream.writeUTF("");
                continue;
            }
            stream.writeUTF(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getId(String value) {
        Object object;
        String prevString = null;
        int prevInt = 0;
        Object object2 = this.oneItemCacheLock;
        synchronized (object2) {
            prevString = this.oneItemCacheString;
            prevInt = this.oneItemCacheInt;
        }
        if (value.equals(prevString)) {
            return prevInt;
        }
        int id = this.cache.indexOf(value);
        if (id == -1) {
            object = this.cache;
            synchronized (object) {
                id = this.cache.indexOf(value);
                if (id == -1) {
                    id = this.makeId(value);
                }
            }
        }
        object = this.oneItemCacheLock;
        synchronized (object) {
            this.oneItemCacheString = value;
            this.oneItemCacheInt = id;
        }
        return id;
    }

    protected int makeId(String value) {
        value = this.getFileKey(value);
        this.cache.add(value);
        return this.cache.indexOf(value);
    }

    public String getValueById(int id) {
        return this.cache.get(id);
    }

    public boolean containsId(int id) {
        return 0 <= id && id < this.cache.size();
    }

    public boolean containsValue(String value) {
        return this.cache.contains(value);
    }

    public int size() {
        return this.cache.size();
    }

    public int getVersion() {
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    protected String getFileKey(String str) {
        return str;
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

