/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs.statistics;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.testbench.Stats;

public class FileStatistics {
    private Map<Key, ChunkStatistics> map;

    public FileStatistics() {
        if (Stats.fileStatisticsLevel > 0) {
            this.map = new HashMap<Key, ChunkStatistics>();
        }
    }

    private ChunkStatistics getStat(Key key) {
        ChunkStatistics stat = this.map.get(key);
        if (stat == null) {
            stat = new ChunkStatistics();
            this.map.put(key, stat);
        }
        return stat;
    }

    public int getReadCount(Key key) {
        return Stats.fileStatisticsLevel == 0 ? 0 : this.getStat((Key)key).readCount;
    }

    public void incrementReadCount(Key key) {
        if (Stats.fileStatisticsLevel > 0) {
            ++this.getStat((Key)key).readCount;
        }
    }

    public int getWriteCount(Key key) {
        return Stats.fileStatisticsLevel == 0 ? 0 : this.getStat((Key)key).writeCount;
    }

    public void incrementWriteCount(Key key, int oldSize, int newSize) {
        if (Stats.fileStatisticsLevel > 0) {
            ChunkStatistics stat = this.getStat(key);
            ++stat.writeCount;
            if (oldSize > 0 && newSize != oldSize) {
                ++stat.resized;
            }
        }
    }

    public void removeNotify(Key key) {
        if (Stats.fileStatisticsLevel > 0) {
            this.map.remove(key);
        }
    }

    private static class ChunkStatistics {
        public int readCount;
        public int writeCount;
        public int resized;

        private ChunkStatistics() {
        }
    }
}

