/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.indirection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.indirection.WeavedAttributeValueHolderInterface;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.indirection.BasicIndirectionPolicy;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedMethodInvoker;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;

public class WeavedObjectBasicIndirectionPolicy
extends BasicIndirectionPolicy {
    protected String setMethodName = null;
    protected Method setMethod = null;

    public WeavedObjectBasicIndirectionPolicy(String setMethodName) {
        this.setMethodName = setMethodName;
    }

    public Object getRealAttributeValueFromObject(Object object, Object attribute) {
        Object value = super.getRealAttributeValueFromObject(object, attribute);
        this.updateValueInObject(object, value, attribute);
        return value;
    }

    protected Method getSetMethod() {
        if (this.setMethod == null) {
            ForeignReferenceMapping sourceMapping = (ForeignReferenceMapping)this.mapping;
            Class[] parameterTypes = new Class[]{sourceMapping.getReferenceClass()};
            try {
                this.setMethod = Helper.getDeclaredMethod(sourceMapping.getDescriptor().getJavaClass(), this.setMethodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                throw DescriptorException.errorAccessingSetMethodOfEntity(sourceMapping.getDescriptor().getJavaClass(), this.setMethodName, sourceMapping.getDescriptor(), e);
            }
        }
        return this.setMethod;
    }

    public void updateValueInObject(Object object, Object value, Object attributeValue) {
        this.setRealAttributeValueInObject(object, value);
        ((WeavedAttributeValueHolderInterface)attributeValue).setIsCoordinatedWithProperty(true);
    }

    public void setRealAttributeValueInObject(Object target, Object attributeValue) {
        block8: {
            Object[] parameters = new Object[]{attributeValue};
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getSetMethod(), target, parameters));
                        break block8;
                    }
                    catch (PrivilegedActionException exception) {
                        Exception throwableException = exception.getException();
                        if (throwableException instanceof IllegalAccessException) {
                            throw DescriptorException.illegalAccessWhileSettingValueThruMethodAccessor(this.setMethod.getName(), attributeValue, throwableException);
                        }
                        throw DescriptorException.targetInvocationWhileSettingValueThruMethodAccessor(this.setMethod.getName(), attributeValue, throwableException);
                    }
                }
                PrivilegedAccessHelper.invokeMethod(this.getSetMethod(), target, parameters);
            }
            catch (IllegalAccessException exception) {
                throw DescriptorException.illegalAccessWhileSettingValueThruMethodAccessor(this.setMethod.getName(), attributeValue, exception);
            }
            catch (IllegalArgumentException exception) {
                throw DescriptorException.illegalArgumentWhileSettingValueThruMethodAccessor(this.setMethod.getName(), attributeValue, exception);
            }
            catch (InvocationTargetException exception) {
                throw DescriptorException.targetInvocationWhileSettingValueThruMethodAccessor(this.setMethod.getName(), attributeValue, exception);
            }
        }
    }
}

