/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyClass;
import org.jruby.nb.ast.ArrayNode;
import org.jruby.nb.ast.BlockAcceptingNode;
import org.jruby.nb.ast.IArgumentNode;
import org.jruby.nb.ast.IterNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallSite;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.InterpretedBlock;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class CallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    private final Node receiverNode;
    private Node argsNode;
    private Node iterNode;
    public CallSite callAdapter;

    @Deprecated
    public CallNode(ISourcePosition position, Node receiverNode, String name, Node argsNode) {
        this(position, receiverNode, name, argsNode, null);
    }

    public CallNode(ISourcePosition position, Node receiverNode, String name, Node argsNode, Node iterNode) {
        super(position, NodeType.CALLNODE);
        assert (receiverNode != null) : "receiverNode is not null";
        this.receiverNode = receiverNode;
        this.setArgsNode(argsNode);
        this.iterNode = iterNode;
        this.callAdapter = MethodIndex.getCallSite(name);
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitCallNode(this);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node iterNode) {
        this.iterNode = iterNode;
        this.callAdapter = MethodIndex.getCallSite(this.callAdapter.methodName);
        return this;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public Node setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
        return argsNode;
    }

    @Override
    public String getName() {
        return this.callAdapter.methodName;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode, this.iterNode);
    }

    @Override
    public String toString() {
        return "CallNode: " + this.getName() + " @ " + this.getPosition();
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        assert (false) : "No longer called";
        return null;
    }

    public Block getBlock(ThreadContext context, IRubyObject self) {
        IterNode iter = (IterNode)this.iterNode;
        iter.getScope().determineModule();
        return InterpretedBlock.newInterpretedClosure(context, iter.getBlockBody(), self);
    }

    public Block getBlock(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return RuntimeHelpers.getBlockFromBlockPassBody(runtime, this.iterNode.interpret(runtime, context, self, aBlock), aBlock);
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value, Block block, boolean checkArity) {
        IRubyObject receiver = this.receiverNode.interpret(runtime, context, self, block);
        if (this.argsNode == null) {
            RuntimeHelpers.invoke(context, receiver, this.getName(), new IRubyObject[]{value}, CallType.NORMAL, Block.NULL_BLOCK);
        } else {
            RubyArray args = (RubyArray)this.argsNode.interpret(runtime, context, self, block);
            args.append(value);
            RuntimeHelpers.invoke(context, receiver, this.getName(), args.toJavaArray(), CallType.NORMAL, Block.NULL_BLOCK);
        }
        return runtime.getNil();
    }

    @Override
    public String definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.receiverNode.definition(runtime, context, self, aBlock) != null) {
            try {
                IRubyObject receiver = this.receiverNode.interpret(runtime, context, self, aBlock);
                RubyClass metaClass = receiver.getMetaClass();
                DynamicMethod method = metaClass.searchMethod(this.getName());
                Visibility visibility = method.getVisibility();
                if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || metaClass.getRealClass().isInstance(self)) && !method.isUndefined()) {
                    return ASTInterpreter.getArgumentDefinition(runtime, context, this.getArgsNode(), "method", self, aBlock);
                }
            }
            catch (JumpException excptn) {
                // empty catch block
            }
        }
        return null;
    }
}

