/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.io.IOException;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.ant.UpdateImplementation;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpdateProjectImpl
implements UpdateImplementation {
    private static final boolean TRANSPARENT_UPDATE = Boolean.getBoolean("j2seproject.transparentUpdate");
    private static final String BUILD_NUMBER = System.getProperty("netbeans.buildnumber");
    private static final String MINIMUM_ANT_VERSION_ELEMENT = "minimum-ant-version";
    private final Project project;
    private final AntProjectHelper helper;
    private final AuxiliaryConfiguration cfg;
    private boolean alreadyAskedInWriteAccess;
    private Boolean isCurrent;
    private Element cachedElement;

    UpdateProjectImpl(Project project, AntProjectHelper helper, AuxiliaryConfiguration cfg) {
        assert (project != null && helper != null && cfg != null);
        this.project = project;
        this.helper = helper;
        this.cfg = cfg;
    }

    public boolean isCurrent() {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean run() {
                UpdateProjectImpl updateProjectImpl = UpdateProjectImpl.this;
                synchronized (updateProjectImpl) {
                    if (UpdateProjectImpl.this.isCurrent == null) {
                        if (UpdateProjectImpl.this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/1", true) != null || UpdateProjectImpl.this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/2", true) != null) {
                            UpdateProjectImpl.this.isCurrent = Boolean.FALSE;
                        } else {
                            UpdateProjectImpl.this.isCurrent = Boolean.TRUE;
                        }
                    }
                    return UpdateProjectImpl.this.isCurrent;
                }
            }
        });
    }

    public boolean canUpdate() {
        if (TRANSPARENT_UPDATE) {
            return true;
        }
        if (this.alreadyAskedInWriteAccess) {
            return false;
        }
        boolean canUpdate = this.showUpdateDialog();
        if (!canUpdate) {
            this.alreadyAskedInWriteAccess = true;
            ProjectManager.mutex().postReadRequest(new Runnable(){

                @Override
                public void run() {
                    UpdateProjectImpl.this.alreadyAskedInWriteAccess = false;
                }
            });
        }
        return canUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUpdate(EditableProperties props) throws IOException {
        this.helper.putPrimaryConfigurationData(this.getUpdatedSharedConfigurationData(), true);
        this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/1", true);
        this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/2", true);
        ProjectManager.getDefault().saveProject(this.project);
        UpdateProjectImpl updateProjectImpl = this;
        synchronized (updateProjectImpl) {
            this.isCurrent = Boolean.TRUE;
        }
    }

    public synchronized Element getUpdatedSharedConfigurationData() {
        if (this.cachedElement == null) {
            Element oldRoot = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/1", true);
            if (oldRoot != null) {
                Document doc = oldRoot.getOwnerDocument();
                Element newRoot = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "data");
                XMLUtil.copyDocument((Element)oldRoot, (Element)newRoot, (String)"http://www.netbeans.org/ns/j2se-project/3");
                Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "source-roots");
                Element root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
                root.setAttribute("id", "src.dir");
                sourceRoots.appendChild(root);
                newRoot.appendChild(sourceRoots);
                Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "test-roots");
                root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
                root.setAttribute("id", "test.src.dir");
                testRoots.appendChild(root);
                newRoot.appendChild(testRoots);
                this.cachedElement = newRoot;
            } else {
                oldRoot = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2se-project/2", true);
                if (oldRoot != null) {
                    Document doc = oldRoot.getOwnerDocument();
                    Element newRoot = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "data");
                    XMLUtil.copyDocument((Element)oldRoot, (Element)newRoot, (String)"http://www.netbeans.org/ns/j2se-project/3");
                    this.cachedElement = newRoot;
                }
            }
        }
        if (this.cachedElement != null) {
            UpdateProjectImpl.deleteMinAntVersion(this.cachedElement);
        }
        return this.cachedElement;
    }

    public synchronized EditableProperties getUpdatedProjectProperties() {
        EditableProperties cachedProperties = this.helper.getProperties("nbproject/project.properties");
        UpdateProjectImpl.ensureValueExists(cachedProperties, "javadoc.additionalparam", "");
        UpdateProjectImpl.ensureValueExists(cachedProperties, "build.generated.dir", "${build.dir}/generated");
        UpdateProjectImpl.ensureValueExists(cachedProperties, "meta.inf.dir", "${src.dir}/META-INF");
        UpdateProjectImpl.ensureValueExists(cachedProperties, "annotation.processing.enabled", "true");
        UpdateProjectImpl.ensureValueExists(cachedProperties, "annotation.processing.enabled.in.editor", "false");
        UpdateProjectImpl.ensureValueExists(cachedProperties, "annotation.processing.run.all.processors", "true");
        UpdateProjectImpl.ensureValueExists(cachedProperties, "annotation.processing.processors.list", "");
        UpdateProjectImpl.ensureValueExists(cachedProperties, "annotation.processing.source.output", "${build.generated.sources.dir}/ap-source-output");
        UpdateProjectImpl.ensureValueExists(cachedProperties, "annotation.processing.processor.options", "");
        UpdateProjectImpl.ensureValueExists(cachedProperties, "javac.processorpath", "${javac.classpath}");
        UpdateProjectImpl.ensureValueExists(cachedProperties, "javac.test.processorpath", "${javac.test.classpath}");
        return cachedProperties;
    }

    private static void ensureValueExists(EditableProperties prop, String property, String defaultValue) {
        if (prop.get((Object)property) == null) {
            prop.put(property, defaultValue);
        }
    }

    private static void deleteMinAntVersion(Element root) {
        NodeList list = root.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", MINIMUM_ANT_VERSION_ELEMENT);
        if (list.getLength() == 1) {
            Node me = list.item(0);
            me.getParentNode().removeChild(me);
        }
    }

    private boolean showUpdateDialog() {
        JButton updateOption = new JButton(NbBundle.getMessage(UpdateProjectImpl.class, (String)"CTL_UpdateOption"));
        updateOption.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UpdateProjectImpl.class, (String)"AD_UpdateOption"));
        return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(UpdateProjectImpl.class, (String)"TXT_ProjectUpdate", (Object)BUILD_NUMBER), NbBundle.getMessage(UpdateProjectImpl.class, (String)"TXT_ProjectUpdateTitle"), -1, 2, new Object[]{updateOption, NotifyDescriptor.CANCEL_OPTION}, (Object)updateOption)) == updateOption;
    }
}

