/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.CyclicDependencyException;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionListenerForDepMgmt;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.resolver.conflict.ConflictResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.ManagedVersionMap;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArtifactCollector
implements ArtifactCollector,
LogEnabled {
    private ConflictResolver defaultConflictResolver;
    private Logger logger;

    @Override
    public ArtifactResolutionResult collect(Set<Artifact> artifacts, Artifact originatingArtifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List<ResolutionListener> listeners) {
        return this.collect(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, filter, listeners);
    }

    @Override
    public ArtifactResolutionResult collect(Set<Artifact> artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List<ResolutionListener> listeners) {
        return this.collect(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, listeners, null);
    }

    @Override
    public ArtifactResolutionResult collect(Set<Artifact> artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List<ResolutionListener> listeners, List<ConflictResolver> conflictResolvers) {
        ArtifactResolutionResult result = new ArtifactResolutionResult();
        result.ListOriginatingArtifact(originatingArtifact);
        if (conflictResolvers == null) {
            conflictResolvers = Collections.singletonList(this.defaultConflictResolver);
        }
        LinkedHashMap<Object, List<ResolutionNode>> resolvedArtifacts = new LinkedHashMap<Object, List<ResolutionNode>>();
        ResolutionNode root = new ResolutionNode(originatingArtifact, remoteRepositories);
        try {
            root.addDependencies(artifacts, remoteRepositories, filter);
        }
        catch (CyclicDependencyException e) {
            result.addCircularDependencyException(e);
            return result;
        }
        catch (OverConstrainedVersionException e) {
            result.addVersionRangeViolation(e);
            return result;
        }
        ManagedVersionMap versionMap = this.getManagedVersionsMap(originatingArtifact, managedVersions);
        try {
            this.recurse(result, root, resolvedArtifacts, versionMap, localRepository, remoteRepositories, source, filter, listeners, conflictResolvers);
        }
        catch (CyclicDependencyException e) {
            this.logger.debug("While recursing: " + e.getMessage(), e);
            result.addCircularDependencyException(e);
        }
        catch (OverConstrainedVersionException e) {
            this.logger.debug("While recursing: " + e.getMessage(), e);
            result.addVersionRangeViolation(e);
        }
        catch (ArtifactResolutionException e) {
            this.logger.debug("While recursing: " + e.getMessage(), e);
            result.addErrorArtifactException(e);
        }
        LinkedHashSet<ResolutionNode> set = new LinkedHashSet<ResolutionNode>();
        for (List nodes : resolvedArtifacts.values()) {
            for (ResolutionNode node : nodes) {
                if (node.equals(root) || !node.isActive()) continue;
                Artifact artifact = node.getArtifact();
                try {
                    if (!node.filterTrail(filter) || !node.isChildOfRootNode() && artifact.isOptional()) continue;
                    artifact.setDependencyTrail(node.getDependencyTrail());
                    set.add(node);
                }
                catch (OverConstrainedVersionException e) {
                    result.addVersionRangeViolation(e);
                }
            }
        }
        result.setArtifactResolutionNodes(set);
        return result;
    }

    private ManagedVersionMap getManagedVersionsMap(Artifact originatingArtifact, Map managedVersions) {
        ManagedVersionMap versionMap = managedVersions != null && managedVersions instanceof ManagedVersionMap ? (ManagedVersionMap)managedVersions : new ManagedVersionMap(managedVersions);
        Artifact managedOriginatingArtifact = (Artifact)versionMap.get(originatingArtifact.getDependencyConflictId());
        if (managedOriginatingArtifact != null) {
            if (managedVersions instanceof ManagedVersionMap) {
                versionMap = new ManagedVersionMap(managedVersions);
            }
            versionMap.remove(originatingArtifact.getDependencyConflictId());
        }
        return versionMap;
    }

    private void recurse(ArtifactResolutionResult result, ResolutionNode node, Map<Object, List<ResolutionNode>> resolvedArtifacts, ManagedVersionMap managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List<ResolutionListener> listeners, List<ConflictResolver> conflictResolvers) throws ArtifactResolutionException {
        List<ResolutionNode> previousNodes;
        this.fireEvent(1, listeners, node);
        Object key = node.getKey();
        if (managedVersions.containsKey(key)) {
            this.manageArtifact(node, managedVersions, listeners);
        }
        if ((previousNodes = resolvedArtifacts.get(key)) != null) {
            for (ResolutionNode previous : previousNodes) {
                try {
                    ResolutionNode farthest;
                    ResolutionNode nearest;
                    if (!previous.isActive()) continue;
                    VersionRange previousRange = previous.getArtifact().getVersionRange();
                    VersionRange currentRange = node.getArtifact().getVersionRange();
                    if (previousRange != null && currentRange != null) {
                        VersionRange newRange = previousRange.restrict(currentRange);
                        if (newRange.isSelectedVersionKnown(previous.getArtifact())) {
                            this.fireEvent(11, listeners, node, previous.getArtifact(), newRange);
                        }
                        previous.getArtifact().setVersionRange(newRange);
                        node.getArtifact().setVersionRange(currentRange.restrict(previousRange));
                        ResolutionNode[] resetNodes = new ResolutionNode[]{previous, node};
                        for (int j = 0; j < 2; ++j) {
                            ArtifactVersion selectedVersion;
                            Artifact resetArtifact = resetNodes[j].getArtifact();
                            if (resetArtifact.getVersion() != null || resetArtifact.getVersionRange() == null) continue;
                            List<ArtifactVersion> versions = resetArtifact.getAvailableVersions();
                            if (versions == null) {
                                try {
                                    versions = source.retrieveAvailableVersions(resetArtifact, localRepository, remoteRepositories);
                                    resetArtifact.setAvailableVersions(versions);
                                }
                                catch (ArtifactMetadataRetrievalException e) {
                                    resetArtifact.setDependencyTrail(node.getDependencyTrail());
                                    throw new ArtifactResolutionException("Unable to get dependency information: " + e.getMessage(), resetArtifact, remoteRepositories, e);
                                }
                            }
                            if ((selectedVersion = resetArtifact.getVersionRange().matchVersion(resetArtifact.getAvailableVersions())) == null) {
                                throw new OverConstrainedVersionException(" Unable to find a version in " + resetArtifact.getAvailableVersions() + " to match the range " + resetArtifact.getVersionRange(), resetArtifact);
                            }
                            resetArtifact.selectVersion(selectedVersion.toString());
                            this.fireEvent(10, listeners, resetNodes[j]);
                        }
                    }
                    ResolutionNode resolved = null;
                    Iterator<ConflictResolver> j = conflictResolvers.iterator();
                    while (resolved == null && j.hasNext()) {
                        ConflictResolver conflictResolver = j.next();
                        resolved = conflictResolver.resolveConflict(previous, node);
                    }
                    if (resolved == null) {
                        result.addVersionRangeViolation(new ArtifactResolutionException("Cannot resolve artifact version conflict between " + previous.getArtifact().getVersion() + " and " + node.getArtifact().getVersion(), previous.getArtifact()));
                    }
                    if (resolved != previous && resolved != node) {
                        result.addVersionRangeViolation(new ArtifactResolutionException("Conflict resolver returned unknown resolution node: ", resolved.getArtifact()));
                    }
                    if (resolved == previous) {
                        nearest = previous;
                        farthest = node;
                    } else {
                        nearest = node;
                        farthest = previous;
                    }
                    if (this.checkScopeUpdate(farthest, nearest, listeners)) {
                        nearest.disable();
                        farthest.getArtifact().setVersion(nearest.getArtifact().getVersion());
                        this.fireEvent(5, listeners, nearest, farthest.getArtifact());
                        continue;
                    }
                    farthest.disable();
                    this.fireEvent(5, listeners, farthest, nearest.getArtifact());
                }
                catch (OverConstrainedVersionException e) {
                    result.addVersionRangeViolation(e);
                }
            }
        } else {
            previousNodes = new ArrayList<ResolutionNode>();
            resolvedArtifacts.put(key, previousNodes);
        }
        previousNodes.add(node);
        if (node.isActive()) {
            this.fireEvent(4, listeners, node);
        }
        if (node.isActive() && !Artifact.SCOPE_SYSTEM.equals(node.getArtifact().getScope())) {
            this.fireEvent(2, listeners, node);
            Iterator<ResolutionNode> i = node.getChildrenIterator();
            while (i.hasNext()) {
                ResolutionNode child = i.next();
                try {
                    if (child.isResolved() || child.getArtifact().isOptional() && !child.isChildOfRootNode()) continue;
                    Artifact artifact = child.getArtifact();
                    try {
                        Object childKey = child.getKey();
                        if (managedVersions.containsKey(childKey)) {
                            this.manageArtifact(child, managedVersions, listeners);
                            Artifact ma = (Artifact)managedVersions.get(childKey);
                            ArtifactFilter managedExclusionFilter = ma.getDependencyFilter();
                            if (null != managedExclusionFilter) {
                                if (null != artifact.getDependencyFilter()) {
                                    AndArtifactFilter aaf = new AndArtifactFilter();
                                    aaf.add(artifact.getDependencyFilter());
                                    aaf.add(managedExclusionFilter);
                                    artifact.setDependencyFilter(aaf);
                                } else {
                                    artifact.setDependencyFilter(managedExclusionFilter);
                                }
                            }
                        }
                        if (artifact.getVersion() == null) {
                            ArtifactVersion version;
                            if (!artifact.isSelectedVersionKnown()) {
                                List<ArtifactVersion> versions = artifact.getAvailableVersions();
                                if (versions == null) {
                                    versions = source.retrieveAvailableVersions(artifact, localRepository, remoteRepositories);
                                    artifact.setAvailableVersions(versions);
                                }
                                Collections.sort(versions);
                                VersionRange versionRange = artifact.getVersionRange();
                                version = versionRange.matchVersion(versions);
                                if (version == null) {
                                    artifact.setDependencyTrail(node.getDependencyTrail());
                                    if (versions.isEmpty()) {
                                        throw new OverConstrainedVersionException("No versions are present in the repository for the artifact with a range " + versionRange, artifact, remoteRepositories);
                                    }
                                    throw new OverConstrainedVersionException("Couldn't find a version in " + versions + " to match range " + versionRange, artifact, remoteRepositories);
                                }
                            } else {
                                version = artifact.getSelectedVersion();
                            }
                            artifact.selectVersion(version.toString());
                            this.fireEvent(10, listeners, child);
                        }
                        artifact.setDependencyTrail(node.getDependencyTrail());
                        ResolutionGroup rGroup = source.retrieve(artifact, localRepository, remoteRepositories);
                        if (rGroup == null) continue;
                        child.addDependencies(rGroup.getArtifacts(), rGroup.getResolutionRepositories(), filter);
                    }
                    catch (CyclicDependencyException e) {
                        this.fireEvent(8, listeners, new ResolutionNode(e.getArtifact(), remoteRepositories, child));
                    }
                    catch (ArtifactMetadataRetrievalException e) {
                        artifact.setDependencyTrail(node.getDependencyTrail());
                        throw new ArtifactResolutionException("Unable to get dependency information: " + e.getMessage(), artifact, remoteRepositories, e);
                    }
                    this.recurse(result, child, resolvedArtifacts, managedVersions, localRepository, remoteRepositories, source, filter, listeners, conflictResolvers);
                }
                catch (OverConstrainedVersionException e) {
                    result.addVersionRangeViolation(e);
                }
                catch (ArtifactResolutionException e) {
                    result.addMetadataResolutionException(e);
                }
            }
            this.fireEvent(3, listeners, node);
        }
    }

    private void manageArtifact(ResolutionNode node, ManagedVersionMap managedVersions, List<ResolutionListener> listeners) {
        Artifact artifact = (Artifact)managedVersions.get(node.getKey());
        if (!(artifact.getVersion() == null || node.isChildOfRootNode() && node.getArtifact().getVersion() != null)) {
            this.fireEvent(12, listeners, node, artifact);
            node.getArtifact().setVersion(artifact.getVersion());
        }
        if (!(artifact.getScope() == null || node.isChildOfRootNode() && node.getArtifact().getScope() != null)) {
            this.fireEvent(13, listeners, node, artifact);
            node.getArtifact().setScope(artifact.getScope());
        }
        if (Artifact.SCOPE_SYSTEM.equals(node.getArtifact().getScope()) && node.getArtifact().getFile() == null && artifact.getFile() != null) {
            this.fireEvent(14, listeners, node, artifact);
            node.getArtifact().setFile(artifact.getFile());
        }
    }

    boolean checkScopeUpdate(ResolutionNode farthest, ResolutionNode nearest, List<ResolutionListener> listeners) {
        boolean updateScope = false;
        Artifact farthestArtifact = farthest.getArtifact();
        Artifact nearestArtifact = nearest.getArtifact();
        if (Artifact.SCOPE_RUNTIME.equals(farthestArtifact.getScope()) && (Artifact.SCOPE_TEST.equals(nearestArtifact.getScope()) || Artifact.SCOPE_PROVIDED.equals(nearestArtifact.getScope()))) {
            updateScope = true;
        }
        if (Artifact.SCOPE_COMPILE.equals(farthestArtifact.getScope()) && !Artifact.SCOPE_COMPILE.equals(nearestArtifact.getScope())) {
            updateScope = true;
        }
        if (nearest.getDepth() < 2 && updateScope) {
            updateScope = false;
            this.fireEvent(9, listeners, nearest, farthestArtifact);
        }
        if (updateScope) {
            this.fireEvent(6, listeners, nearest, farthestArtifact);
            nearestArtifact.setScope(farthestArtifact.getScope());
        }
        return updateScope;
    }

    private void fireEvent(int event, List<ResolutionListener> listeners, ResolutionNode node) {
        this.fireEvent(event, listeners, node, null);
    }

    private void fireEvent(int event, List<ResolutionListener> listeners, ResolutionNode node, Artifact replacement) {
        this.fireEvent(event, listeners, node, replacement, null);
    }

    private void fireEvent(int event, List<ResolutionListener> listeners, ResolutionNode node, Artifact replacement, VersionRange newRange) {
        block15: for (ResolutionListener listener : listeners) {
            switch (event) {
                case 1: {
                    listener.testArtifact(node.getArtifact());
                    continue block15;
                }
                case 2: {
                    listener.startProcessChildren(node.getArtifact());
                    continue block15;
                }
                case 3: {
                    listener.endProcessChildren(node.getArtifact());
                    continue block15;
                }
                case 4: {
                    listener.includeArtifact(node.getArtifact());
                    continue block15;
                }
                case 5: {
                    listener.omitForNearer(node.getArtifact(), replacement);
                    continue block15;
                }
                case 8: {
                    listener.omitForCycle(node.getArtifact());
                    continue block15;
                }
                case 6: {
                    listener.updateScope(node.getArtifact(), replacement.getScope());
                    continue block15;
                }
                case 9: {
                    listener.updateScopeCurrentPom(node.getArtifact(), replacement.getScope());
                    continue block15;
                }
                case 12: {
                    ResolutionListenerForDepMgmt asImpl;
                    if (listener instanceof ResolutionListenerForDepMgmt) {
                        asImpl = (ResolutionListenerForDepMgmt)((Object)listener);
                        asImpl.manageArtifactVersion(node.getArtifact(), replacement);
                        continue block15;
                    }
                    listener.manageArtifact(node.getArtifact(), replacement);
                    continue block15;
                }
                case 13: {
                    ResolutionListenerForDepMgmt asImpl;
                    if (listener instanceof ResolutionListenerForDepMgmt) {
                        asImpl = (ResolutionListenerForDepMgmt)((Object)listener);
                        asImpl.manageArtifactScope(node.getArtifact(), replacement);
                        continue block15;
                    }
                    listener.manageArtifact(node.getArtifact(), replacement);
                    continue block15;
                }
                case 14: {
                    ResolutionListenerForDepMgmt asImpl;
                    if (listener instanceof ResolutionListenerForDepMgmt) {
                        asImpl = (ResolutionListenerForDepMgmt)((Object)listener);
                        asImpl.manageArtifactSystemPath(node.getArtifact(), replacement);
                        continue block15;
                    }
                    listener.manageArtifact(node.getArtifact(), replacement);
                    continue block15;
                }
                case 10: {
                    listener.selectVersionFromRange(node.getArtifact());
                    continue block15;
                }
                case 11: {
                    if (!node.getArtifact().getVersionRange().hasRestrictions() && !replacement.getVersionRange().hasRestrictions()) continue block15;
                    listener.restrictRange(node.getArtifact(), replacement, newRange);
                    continue block15;
                }
            }
            throw new IllegalStateException("Unknown event: " + event);
        }
    }

    @Override
    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

