/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.library;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.modules.j2ee.persistence.wizard.library.VolumeContentModel;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class J2SEVolumeCustomizer
extends JPanel
implements Customizer {
    private String volumeType;
    private LibraryImplementation impl;
    private VolumeContentModel model;
    private static File lastFolder = null;
    private JButton addButton;
    private JList content;
    private JButton downButton;
    private JScrollPane jScrollPane1;
    private JLabel message;
    private JButton removeButton;
    private JButton upButton;
    private JButton addURLButton;

    J2SEVolumeCustomizer(String string) {
        this.volumeType = string;
        this.initComponents();
        this.postInitComponents();
        this.setName(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)("TXT_" + string)));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addButton.requestFocus();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.addButton.setEnabled(bl);
        if (this.addURLButton != null) {
            this.addURLButton.setEnabled(bl);
        }
        int[] nArray = this.content.getSelectedIndices();
        this.removeButton.setEnabled(bl && nArray.length > 0);
        this.downButton.setEnabled(bl && nArray.length > 0 && nArray[nArray.length - 1] < this.model.getSize() - 1);
        this.upButton.setEnabled(bl && nArray.length > 0 && nArray[0] > 0);
    }

    private void postInitComponents() {
        this.content.setCellRenderer(new ContentRenderer());
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        if (this.volumeType.equals("classpath")) {
            this.addButton.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_AddClassPath"));
            this.addButton.setMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_AddClassPath").charAt(0));
            this.message.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_ContentClassPath"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_ContentClassPath").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_AddClassPath"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_ContentClassPath"));
        } else if (this.volumeType.equals("javadoc")) {
            this.addButton.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_AddJavadoc"));
            this.addButton.setMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_AddJavadoc").charAt(0));
            this.message.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_ContentJavadoc"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_ContentJavadoc").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_AddJavadoc"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_ContentJavadoc"));
        } else if (this.volumeType.equals("src")) {
            this.addButton.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_AddSources"));
            this.addButton.setMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_AddSources").charAt(0));
            this.message.setText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_ContentSources"));
            this.message.setDisplayedMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_ContentSources").charAt(0));
            this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_AddSources"));
            this.message.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"AD_ContentSources"));
        }
        this.content.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int[] nArray = J2SEVolumeCustomizer.this.content.getSelectedIndices();
                J2SEVolumeCustomizer.this.removeButton.setEnabled(nArray.length > 0);
                J2SEVolumeCustomizer.this.downButton.setEnabled(nArray.length > 0 && nArray[nArray.length - 1] < J2SEVolumeCustomizer.this.model.getSize() - 1);
                J2SEVolumeCustomizer.this.upButton.setEnabled(nArray.length > 0 && nArray[0] > 0);
            }
        });
    }

    private void initComponents() {
        this.message = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.content = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(null);
        this.message.setLabelFor(this.content);
        Mnemonics.setLocalizedText((JLabel)this.message, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_ContentMessage"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 2, 6);
        this.add((Component)this.message, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.content);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_AddContent"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                J2SEVolumeCustomizer.this.addResource(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(null);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_RemoveContent"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                J2SEVolumeCustomizer.this.removeResource(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 6, 6);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(null);
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_UpContent"));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                J2SEVolumeCustomizer.this.upResource(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 6);
        this.add((Component)this.upButton, gridBagConstraints);
        this.upButton.getAccessibleContext().setAccessibleDescription(null);
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getBundle(J2SEVolumeCustomizer.class).getString("CTL_DownContent"));
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                J2SEVolumeCustomizer.this.downResource(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 6, 6);
        this.add((Component)this.downButton, gridBagConstraints);
        this.downButton.getAccessibleContext().setAccessibleDescription(null);
    }

    private void downResource(ActionEvent actionEvent) {
        int[] nArray = this.content.getSelectedIndices();
        if (nArray.length == 0 || nArray[0] < 0 || nArray[nArray.length - 1] >= this.model.getSize() - 1) {
            return;
        }
        this.model.moveDown(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = nArray[i] + 1;
        }
        this.content.setSelectedIndices(nArray);
    }

    private void upResource(ActionEvent actionEvent) {
        int[] nArray = this.content.getSelectedIndices();
        if (nArray.length == 0 || nArray[0] <= 0) {
            return;
        }
        this.model.moveUp(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = nArray[i] - 1;
        }
        this.content.setSelectedIndices(nArray);
    }

    private void removeResource(ActionEvent actionEvent) {
        int[] nArray = this.content.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        this.model.removeResources(nArray);
        if (nArray[nArray.length - 1] - nArray.length + 1 < this.model.getSize()) {
            this.content.setSelectedIndex(nArray[nArray.length - 1] - nArray.length + 1);
        } else if (nArray[0] >= 1) {
            this.content.setSelectedIndex(nArray[0] - 1);
        }
    }

    private void addResource(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (this.volumeType.equals("classpath")) {
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.setDialogTitle(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_OpenClasses"));
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setFileFilter(new SimpleFileFilter(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_Classpath"), new String[]{"ZIP", "JAR"}));
            jFileChooser.setApproveButtonText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_SelectCP"));
            jFileChooser.setApproveButtonMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_SelectCP").charAt(0));
        } else if (this.volumeType.equals("javadoc")) {
            jFileChooser.setDialogTitle(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_OpenJavadoc"));
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setFileFilter(new SimpleFileFilter(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_Javadoc"), new String[]{"ZIP", "JAR"}));
            jFileChooser.setApproveButtonText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_SelectJD"));
            jFileChooser.setApproveButtonMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_SelectJD").charAt(0));
        } else if (this.volumeType.equals("src")) {
            jFileChooser.setDialogTitle(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_OpenSources"));
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setFileFilter(new SimpleFileFilter(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_Sources"), new String[]{"ZIP", "JAR"}));
            jFileChooser.setApproveButtonText(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"CTL_SelectSRC"));
            jFileChooser.setApproveButtonMnemonic(NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"MNE_SelectSRC").charAt(0));
        }
        if (lastFolder != null) {
            jFileChooser.setCurrentDirectory(lastFolder);
        }
        if (jFileChooser.showOpenDialog(this) == 0) {
            try {
                lastFolder = jFileChooser.getCurrentDirectory();
                if (jFileChooser.isMultiSelectionEnabled()) {
                    this.addFiles(jFileChooser.getSelectedFiles());
                } else {
                    File file = jFileChooser.getSelectedFile();
                    this.addFiles(new File[]{file});
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
    }

    private void addFiles(File[] fileArray) throws MalformedURLException {
        Object object;
        int n;
        int n2 = this.model.getSize();
        for (n = 0; n < fileArray.length; ++n) {
            Serializable serializable;
            object = fileArray[n];
            if (!((File)object).exists() && (serializable = ((File)object).getParentFile()) != null && ((File)object).getName().equals(((File)serializable).getName()) && ((File)serializable).exists()) {
                object = serializable;
            }
            if (FileUtil.isArchiveFile((URL)(serializable = ((File)object).toURI().toURL()))) {
                serializable = FileUtil.getArchiveRoot((URL)serializable);
            } else if (!((URL)serializable).toExternalForm().endsWith("/")) {
                try {
                    serializable = new URL(((URL)serializable).toExternalForm() + "/");
                }
                catch (MalformedURLException malformedURLException) {
                    Exceptions.printStackTrace((Throwable)malformedURLException);
                }
            }
            if (this.volumeType.equals("javadoc") && !PersistenceLibrarySupport.isValidLibraryJavadocRoot((URL)serializable)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_InvalidJavadocRoot", (Object)((File)object).getPath()), 0));
                continue;
            }
            this.model.addResource((URL)serializable);
        }
        n = this.model.getSize() - 1;
        if (n2 <= n) {
            object = new int[n - n2 + 1];
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i] = n2 + i;
            }
            this.content.setSelectedIndices((int[])object);
        }
    }

    @Override
    public void setObject(Object object) {
        if (object instanceof LibraryImplementation) {
            LibrariesSupport.createLibraryImplementation((String)"j2se", (String[])PersistenceLibrarySupport.VOLUME_TYPES);
            this.impl = (LibraryImplementation)object;
            this.model = new VolumeContentModel(this.impl, this.volumeType);
            this.content.setModel(this.model);
            if (this.model.getSize() > 0) {
                this.content.setSelectedIndex(0);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static class ContentRenderer
    extends DefaultListCellRenderer {
        private ContentRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Serializable serializable;
            String string = null;
            Color color = null;
            String string2 = null;
            if (object instanceof URL) {
                FileObject fileObject;
                serializable = (URL)object;
                if ("jar".equals(((URL)serializable).getProtocol())) {
                    serializable = FileUtil.getArchiveFile((URL)serializable);
                }
                if ((fileObject = URLMapper.findFileObject((URL)serializable)) == null) {
                    string = ((URL)serializable).toExternalForm();
                    color = new Color(164, 0, 0);
                    string2 = NbBundle.getMessage(J2SEVolumeCustomizer.class, (String)"TXT_BrokenFile");
                } else {
                    string = FileUtil.getFileDisplayName((FileObject)fileObject);
                }
            }
            if ((serializable = super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2)) instanceof JComponent) {
                if (color != null) {
                    ((JComponent)serializable).setForeground(color);
                }
                if (string2 != null) {
                    ((JComponent)serializable).setToolTipText(string2);
                }
            }
            return serializable;
        }
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String string, String[] stringArray) {
            this.description = string;
            this.extensions = Arrays.asList(stringArray);
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n <= 0 || n == string.length() - 1) {
                return false;
            }
            String string2 = string.substring(n + 1).toUpperCase();
            return this.extensions.contains(string2);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

