/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl.pm;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.introduce.CopyFinder;
import org.netbeans.modules.java.hints.jackpot.impl.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.Hacks;

public class Pattern {
    private final CompilationInfo info;
    private final String pattern;
    private final Tree patternTree;
    private final Iterable<Tree> antipatterns;
    private final Map<String, TypeMirror> constraintsHack;

    public Pattern(CompilationInfo compilationInfo, String string, Tree tree, Iterable<Tree> iterable, Map<String, TypeMirror> map) {
        this.info = compilationInfo;
        this.pattern = string;
        this.patternTree = tree;
        this.antipatterns = iterable;
        this.constraintsHack = map;
    }

    public static Pattern compile(CompilationInfo compilationInfo, String string) {
        HashMap<String, TypeMirror> hashMap = new HashMap<String, TypeMirror>();
        string = Pattern.parseOutTypesFromPattern(compilationInfo, string, hashMap);
        return Pattern.compile(compilationInfo, string, hashMap, Collections.emptyList());
    }

    public static Pattern compile(CompilationInfo compilationInfo, String string, Map<String, TypeMirror> map, Iterable<? extends String> iterable) {
        return Pattern.compile(compilationInfo, string, Collections.<String>emptyList(), map, iterable);
    }

    public static Pattern compile(CompilationInfo compilationInfo, String string, Iterable<String> iterable, Map<String, TypeMirror> map, Iterable<? extends String> iterable2) {
        Scope[] scopeArray = new Scope[1];
        Tree tree = Pattern.parseAndAttribute(compilationInfo, string, map, scopeArray, iterable2);
        LinkedList<Tree> linkedList = new LinkedList<Tree>();
        for (String string2 : iterable) {
            ExpressionTree expressionTree = compilationInfo.getTreeUtilities().parseExpression(string2, new SourcePositions[1]);
            compilationInfo.getTreeUtilities().attributeTree((Tree)expressionTree, scopeArray[0]);
            linkedList.add(expressionTree);
        }
        return new Pattern(compilationInfo, string, tree, linkedList, map);
    }

    public Map<String, TreePath> match(TreePath treePath) {
        CopyFinder.VariableAssignments variableAssignments = CopyFinder.computeVariables(this.info, new TreePath(new TreePath(this.info.getCompilationUnit()), this.patternTree), treePath, new AtomicBoolean(), this.constraintsHack);
        if (variableAssignments == null) {
            return null;
        }
        return variableAssignments.variables;
    }

    public boolean checkAntipatterns(TreePath treePath) {
        for (Tree tree : this.antipatterns) {
            if (CopyFinder.computeVariables(this.info, new TreePath(new TreePath(this.info.getCompilationUnit()), tree), treePath, new AtomicBoolean(), this.constraintsHack) == null) continue;
            return false;
        }
        return true;
    }

    public Map<String, TypeMirror> getConstraints() {
        return this.constraintsHack;
    }

    public String getPatternCode() {
        return this.pattern;
    }

    public Tree getPattern() {
        return this.patternTree;
    }

    private static String parseOutTypesFromPattern(CompilationInfo compilationInfo, String string, Map<String, TypeMirror> map) {
        java.util.regex.Pattern pattern = java.util.regex.Pattern.compile("(\\$.)(\\{([^}]*)\\})?");
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = pattern.matcher(string);
        int n = 0;
        while (matcher.find()) {
            stringBuffer.append(string.substring(n, matcher.start()));
            n = matcher.end();
            String string2 = matcher.group(1);
            String string3 = matcher.group(3);
            stringBuffer.append(string2);
            map.put(string2, string3 != null ? Hacks.parseFQNType(compilationInfo, string3) : null);
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static Tree parseAndAttribute(CompilationInfo compilationInfo, String string, Map<String, TypeMirror> map, Scope[] scopeArray, Iterable<? extends String> iterable) {
        scopeArray[0] = Utilities.constructScope(compilationInfo, map, iterable);
        if (scopeArray[0] == null) {
            return null;
        }
        return Utilities.parseAndAttribute(compilationInfo, string, scopeArray[0]);
    }
}

