/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public final class RemoveUselessCast
implements ErrorRule<Void> {
    @Override
    public Set<String> getCodes() {
        return Collections.singleton("compiler.warn.redundant.cast");
    }

    @Override
    public List<Fix> run(CompilationInfo compilationInfo, String string, int n, TreePath treePath, ErrorRule.Data<Void> data) {
        TreePath treePath2 = compilationInfo.getTreeUtilities().pathFor(n + 1);
        if (treePath2 != null && treePath2.getLeaf().getKind() == Tree.Kind.TYPE_CAST) {
            TreePathHandle treePathHandle = TreePathHandle.create((TreePath)treePath2, (CompilationInfo)compilationInfo);
            return Collections.singletonList(new FixImpl(compilationInfo.getJavaSource(), treePathHandle));
        }
        return Collections.emptyList();
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return RemoveUselessCast.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(RemoveUselessCast.class, (String)"LBL_Remove_Useless_Cast_Fix");
    }

    public String getDescription() {
        return NbBundle.getMessage(RemoveUselessCast.class, (String)"DSC_Remove_Useless_Cast_Fix");
    }

    private static final class FixImpl
    implements Fix {
        private JavaSource js;
        private TreePathHandle handle;

        public FixImpl(JavaSource javaSource, TreePathHandle treePathHandle) {
            this.js = javaSource;
            this.handle = treePathHandle;
        }

        public String getText() {
            return NbBundle.getMessage(RemoveUselessCast.class, (String)"LBL_FIX_Remove_redundant_cast");
        }

        public ChangeInfo implement() throws IOException {
            this.js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath treePath = FixImpl.this.handle.resolve((CompilationInfo)workingCopy);
                    if (treePath != null) {
                        TypeCastTree typeCastTree = (TypeCastTree)treePath.getLeaf();
                        workingCopy.rewrite((Tree)typeCastTree, (Tree)typeCastTree.getExpression());
                    }
                }
            }).commit();
            return null;
        }
    }
}

