/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.imports.ComputeImports;
import org.netbeans.modules.java.editor.imports.JavaFixAllImports;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class StaticImport
extends AbstractHint {
    private final AtomicBoolean cancel = new AtomicBoolean();

    public StaticImport() {
        super(false, false, AbstractHint.HintSeverity.CURRENT_LINE_WARNING, new String[0]);
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(StaticImport.class, (String)"DSC_StaticImport");
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.MEMBER_SELECT);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        String string;
        List<FixImpl> list;
        Iterable<String> iterable;
        if (treePath == null || treePath.getLeaf().getKind() != Tree.Kind.MEMBER_SELECT) {
            return null;
        }
        this.cancel.set(false);
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 == null || treePath2.getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION) {
            return null;
        }
        Element element = compilationInfo.getTrees().getElement(treePath);
        if (element == null || !element.getModifiers().contains((Object)Modifier.STATIC) || element.getKind() != ElementKind.METHOD) {
            return null;
        }
        if (!StaticImport.supportsStaticImports(compilationInfo)) {
            return null;
        }
        Element element2 = element.getEnclosingElement();
        if (element2 == null) {
            return null;
        }
        String string2 = element.getSimpleName().toString();
        if (!StaticImport.isValidStaticMethod(compilationInfo, ((Object)Utilities.getElementName((Element)element2, (boolean)true)).toString(), string2)) {
            iterable = this.guessCandidates(compilationInfo, ((MemberSelectTree)treePath.getLeaf()).getExpression().toString(), string2);
            if (iterable.isEmpty()) {
                return null;
            }
            list = new ArrayList<FixImpl>();
            for (String string3 : iterable) {
                list.add(new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), string3, string2));
            }
        } else {
            String string3;
            iterable = StaticImport.getContainingClass(treePath);
            if (iterable == null) {
                return null;
            }
            Element element3 = compilationInfo.getTrees().getElement((TreePath)iterable);
            if (element3.getKind() != ElementKind.CLASS) {
                return null;
            }
            string3 = null;
            string = StaticImport.getMethodFqn(element);
            if (!StaticImport.isSubTypeOrInnerOfSubType(compilationInfo, element3, element2) && !StaticImport.isStaticallyImported(compilationInfo, string)) {
                if (StaticImport.hasMethodNameClash(compilationInfo, element3, string2) || StaticImport.hasStaticImportSimpleNameClash(compilationInfo, string2)) {
                    return null;
                }
                string3 = string;
            }
            list = Collections.singletonList(new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), string3, string2));
        }
        iterable = NbBundle.getMessage(StaticImport.class, (String)"ERR_StaticImport");
        int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), treePath.getLeaf());
        int n2 = (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), treePath.getLeaf());
        string = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)((Object)iterable), list, (FileObject)compilationInfo.getFileObject(), (int)n, (int)n2);
        if (this.cancel.get()) {
            return null;
        }
        return Collections.singletonList(string);
    }

    @Override
    public String getId() {
        return StaticImport.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(StaticImport.class, (String)"DN_StaticImport");
    }

    @Override
    public void cancel() {
        this.cancel.set(true);
    }

    public static boolean supportsStaticImports(CompilationInfo compilationInfo) {
        return compilationInfo.getSourceVersion().compareTo(SourceVersion.RELEASE_5) >= 0;
    }

    private static boolean hasMethodWithSimpleName(CompilationInfo compilationInfo, Element element, final String string) {
        Iterable iterable = compilationInfo.getElementUtilities().getMembers(element.asType(), new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element element, TypeMirror typeMirror) {
                return element.getKind() == ElementKind.METHOD && element.getSimpleName().toString().equals(string);
            }
        });
        return iterable.iterator().hasNext();
    }

    public static boolean hasStaticImportSimpleNameClash(CompilationInfo compilationInfo, String string) {
        for (ImportTree importTree : compilationInfo.getCompilationUnit().getImports()) {
            if (!importTree.isStatic()) continue;
            String string2 = importTree.getQualifiedIdentifier().toString();
            if (string2.endsWith(".*")) {
                TypeElement typeElement = compilationInfo.getElements().getTypeElement(string2.substring(0, string2.length() - 2));
                if (typeElement == null) continue;
                for (Element element : typeElement.getEnclosedElements()) {
                    String string3;
                    Set<Modifier> set = element.getModifiers();
                    if (element.getKind() != ElementKind.METHOD || !set.contains((Object)Modifier.STATIC) || set.contains((Object)Modifier.PRIVATE) || !string.equals(string3 = element.getSimpleName().toString())) continue;
                    return true;
                }
                continue;
            }
            int n = string2.lastIndexOf(".");
            if (n == -1 || n >= string2.length() - 1 || !string2.substring(n).equals(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSubTypeOrInnerOfSubType(CompilationInfo compilationInfo, Element element, Element element2) {
        boolean bl = compilationInfo.getTypes().isSubtype(element.asType(), element2.asType());
        boolean bl2 = element.getEnclosingElement().getKind() == ElementKind.CLASS;
        return bl || bl2 && compilationInfo.getTypes().isSubtype(element.getEnclosingElement().asType(), element2.asType());
    }

    public static boolean hasMethodNameClash(CompilationInfo compilationInfo, Element element, String string) {
        assert (element != null);
        assert (element.getKind() == ElementKind.CLASS);
        if (StaticImport.hasMethodWithSimpleName(compilationInfo, element, string)) {
            return true;
        }
        Element element2 = element.getEnclosingElement();
        return element2 != null && element2.getKind() == ElementKind.CLASS && StaticImport.hasMethodWithSimpleName(compilationInfo, element2, string);
    }

    public static String getMethodFqn(Element element) {
        assert (element.getKind() == ElementKind.METHOD);
        return Utilities.getElementName((Element)element.getEnclosingElement(), (boolean)true) + "." + element.getSimpleName();
    }

    public static TreePath getContainingClass(TreePath treePath) {
        while (treePath != null && treePath.getLeaf().getKind() != Tree.Kind.CLASS) {
            treePath = treePath.getParentPath();
        }
        return treePath;
    }

    private static boolean isStaticallyImported(CompilationInfo compilationInfo, String string) {
        for (ImportTree importTree : compilationInfo.getCompilationUnit().getImports()) {
            if (!importTree.isStatic()) continue;
            String string2 = importTree.getQualifiedIdentifier().toString();
            if (string2.endsWith(".*") && string.startsWith(string2.substring(0, string2.length() - 1))) {
                return true;
            }
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidStaticMethod(CompilationInfo compilationInfo, String string, String string2) {
        TypeElement typeElement = compilationInfo.getElements().getTypeElement(string);
        if (typeElement == null) {
            return false;
        }
        for (Element element : typeElement.getEnclosedElements()) {
            String string3;
            Set<Modifier> set = element.getModifiers();
            if (element.getKind() != ElementKind.METHOD || !set.contains((Object)Modifier.STATIC) || set.contains((Object)Modifier.PRIVATE) || !string2.equals(string3 = element.getSimpleName().toString())) continue;
            return true;
        }
        return false;
    }

    private Collection<String> guessCandidates(CompilationInfo compilationInfo, String string, String string2) {
        Logger.getLogger(StaticImport.class.getName()).log(Level.FINE, "GUESS {0}.{1}", new Object[]{string, string2});
        ComputeImports.Pair pair = new ComputeImports().computeCandidates(compilationInfo);
        HashSet<String> hashSet = new HashSet<String>();
        if (pair == null || pair.a == null) {
            return hashSet;
        }
        for (String string3 : ((Map)pair.a).keySet()) {
            if (!string.equals(string3)) continue;
            for (TypeElement typeElement : (List)((Map)pair.a).get(string3)) {
                String string4 = typeElement.getQualifiedName().toString();
                String string5 = string4 + "." + string2;
                System.out.println(string5);
                if (hashSet.contains(string5) || !StaticImport.isValidStaticMethod(compilationInfo, string4, string2)) continue;
                hashSet.add(string5);
            }
        }
        return hashSet;
    }

    public static final class FixImpl
    implements Fix,
    Task<WorkingCopy> {
        private final TreePathHandle handle;
        private final String fqn;
        private final String sn;

        public FixImpl(TreePathHandle treePathHandle, String string, String string2) {
            this.handle = treePathHandle;
            this.fqn = string;
            this.sn = string2;
        }

        public String getText() {
            if (this.fqn == null) {
                return NbBundle.getMessage(StaticImport.class, (String)"HINT_StaticImport", (Object)this.sn);
            }
            return NbBundle.getMessage(StaticImport.class, (String)"HINT_StaticImport2", (Object)this.fqn);
        }

        public ChangeInfo implement() throws Exception {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.handle.getFileObject());
            javaSource.runModificationTask((Task)this).commit();
            return null;
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            if (workingCopy.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                return;
            }
            TreePath treePath = this.handle.resolve((CompilationInfo)workingCopy);
            if (treePath == null || treePath.getLeaf().getKind() != Tree.Kind.MEMBER_SELECT) {
                return;
            }
            TreePath treePath2 = treePath.getParentPath();
            if (treePath2 == null || treePath2.getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION) {
                return;
            }
            Element element = workingCopy.getTrees().getElement(treePath);
            if (element == null || !element.getModifiers().contains((Object)Modifier.STATIC)) {
                return;
            }
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            workingCopy.rewrite(treePath.getLeaf(), (Tree)treeMaker.Identifier((CharSequence)this.sn));
            if (this.fqn == null) {
                return;
            }
            CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
            CompilationUnitTree compilationUnitTree2 = JavaFixAllImports.addImports((CompilationUnitTree)compilationUnitTree, Collections.singletonList(this.fqn), (TreeMaker)treeMaker, (boolean)true);
            workingCopy.rewrite((Tree)compilationUnitTree, (Tree)compilationUnitTree2);
        }
    }
}

