/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints;

import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.openide.util.NbBundle;

public class AddressBreakpoint
extends CndBreakpoint
implements Comparable {
    public static final String PROP_ADDRESS_VALUE = "address";
    public static final String PROP_REFRESH = "refresh";
    private String address;

    private AddressBreakpoint(String address) {
        this.address = address;
    }

    public static AddressBreakpoint create(String address) {
        AddressBreakpoint b = new AddressBreakpoint(address);
        b.setPrintText(NbBundle.getBundle(AddressBreakpoint.class).getString("CTL_Address_Breakpoint_Print_Text"));
        return b;
    }

    public String getAddress() {
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddress(String newAddress) {
        String old;
        AddressBreakpoint addressBreakpoint = this;
        synchronized (addressBreakpoint) {
            if (newAddress.equals(this.address)) {
                return;
            }
            old = this.address;
            this.address = newAddress;
        }
        this.firePropertyChange(PROP_ADDRESS_VALUE, old, newAddress);
    }

    @Override
    public int getLineNumber() {
        return 1;
    }

    public String toString() {
        return "AddressBreakpoint " + this.address;
    }

    public void refresh() {
        this.firePropertyChange(PROP_REFRESH, null, null);
    }

    public int compareTo(Object o) {
        if (o instanceof AddressBreakpoint) {
            return this.address.compareTo(((AddressBreakpoint)o).address);
        }
        return -1;
    }
}

