/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import javax.swing.tree.TreePath;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.WizardOperator;
import org.netbeans.jellytools.actions.NewFileAction;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JEditorPaneOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;

public class NewFileWizardOperator
extends WizardOperator {
    private JLabelOperator _lblProject;
    private JLabelOperator _lblCategories;
    private JLabelOperator _lblFileTypes;
    private JTreeOperator _treeCategories;
    private JListOperator _lstFileTypes;
    private JLabelOperator _lblDescription;
    private JEditorPaneOperator _txtDescription;
    private JComboBoxOperator _cboProject;

    public NewFileWizardOperator() {
        super(Bundle.getString((String)"org.netbeans.modules.project.ui.Bundle", (String)"LBL_NewFileWizard_Subtitle"));
    }

    public NewFileWizardOperator(String title) {
        super(title);
    }

    public static NewFileWizardOperator invoke() {
        new NewFileAction().perform();
        return new NewFileWizardOperator();
    }

    public static NewFileWizardOperator invoke(String title) {
        new NewFileAction().perform();
        return new NewFileWizardOperator(title);
    }

    public static NewFileWizardOperator invoke(Node node, String category, String filetype) {
        new NewFileAction().perform(node);
        String wizardTitle = Bundle.getString((String)"org.netbeans.modules.project.ui.Bundle", (String)"LBL_NewFileWizard_Title");
        NewFileWizardOperator nfwo = new NewFileWizardOperator(wizardTitle);
        nfwo.selectCategory(category);
        nfwo.selectFileType(filetype);
        nfwo.next();
        return new NewFileWizardOperator();
    }

    public void selectProject(String project) {
        this.cboProject().selectItem(project);
    }

    public void selectCategory(String category) {
        try {
            new Waiter(new Waitable(){

                public Object actionProduced(Object param) {
                    return NewFileWizardOperator.this.treeCategories().isSelectionEmpty() ? null : Boolean.TRUE;
                }

                public String getDescription() {
                    return "Wait node is selected";
                }
            }).waitAction(null);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted.", (Throwable)e);
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            // empty catch block
        }
        new Node(this.treeCategories(), category).select();
    }

    public void selectFileType(String filetype) {
        this.lstFileTypes().selectItem(filetype);
    }

    public JLabelOperator lblProject() {
        if (this._lblProject == null) {
            this._lblProject = new JLabelOperator((ContainerOperator)this, Bundle.getString((String)"org.netbeans.modules.project.ui.Bundle", (String)"LBL_TargetChooser_Project_Label"));
        }
        return this._lblCategories;
    }

    public JLabelOperator lblCategories() {
        if (this._lblCategories == null) {
            this._lblCategories = new JLabelOperator((ContainerOperator)this, Bundle.getString((String)"org.netbeans.modules.project.ui.Bundle", (String)"CTL_Categories"));
        }
        return this._lblCategories;
    }

    public JLabelOperator lblFileTypes() {
        if (this._lblFileTypes == null) {
            this._lblFileTypes = new JLabelOperator((ContainerOperator)this, Bundle.getString((String)"org.netbeans.modules.project.ui.Bundle", (String)"CTL_Files"));
        }
        return this._lblFileTypes;
    }

    public JComboBoxOperator cboProject() {
        if (this._cboProject == null) {
            this._cboProject = new JComboBoxOperator((ContainerOperator)this);
        }
        return this._cboProject;
    }

    public String getSelectedProject() {
        return this.cboProject().getSelectedItem().toString();
    }

    public JTreeOperator treeCategories() {
        if (this._treeCategories == null) {
            this._treeCategories = new JTreeOperator((ContainerOperator)this);
            this._treeCategories.setComparator((Operator.StringComparator)new Operator.DefaultStringComparator(true, true));
        }
        return this._treeCategories;
    }

    public TreePath getSelectedCategory() {
        return this.treeCategories().getSelectionPath();
    }

    public JListOperator lstFileTypes() {
        if (this._lstFileTypes == null) {
            this._lstFileTypes = new JListOperator((ContainerOperator)this, 1);
            this._lstFileTypes.setComparator((Operator.StringComparator)new Operator.DefaultStringComparator(true, true));
        }
        return this._lstFileTypes;
    }

    public String getSelectedFileType() {
        return this.lstFileTypes().getSelectedValue().toString();
    }

    public JLabelOperator lblDescription() {
        if (this._lblDescription == null) {
            this._lblDescription = new JLabelOperator((ContainerOperator)this, Bundle.getString((String)"org.netbeans.modules.project.ui.Bundle", (String)"CTL_Description"));
        }
        return this._lblDescription;
    }

    public JEditorPaneOperator txtDescription() {
        if (this._txtDescription == null) {
            this._txtDescription = new JEditorPaneOperator((ContainerOperator)this);
        }
        return this._txtDescription;
    }

    public String getDescription() {
        return this.txtDescription().getText();
    }

    public void verify() {
        this.lblCategories();
        this.lblFileTypes();
        this.cboProject();
        this.treeCategories();
        this.lstFileTypes();
        this.lblDescription();
        this.txtDescription();
    }
}

