/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.netbeans.modules.nativeexecution.api.util.ShellValidationSupport;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.windows.PathConverter;
import org.netbeans.modules.nativeexecution.support.windows.SimpleConverter;
import org.openide.util.Utilities;

public final class WindowsSupport {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private static final WindowsSupport instance = new WindowsSupport();
    private final boolean isWindows = Utilities.isWindows();
    private Shell activeShell = null;
    private String REG_EXE;
    private PathConverter pathConverter = null;
    private Charset charset;

    private WindowsSupport() {
        this.init();
        if (this.activeShell == null) {
            log.fine("WindowsSupport: no shell found");
        } else {
            log.log(Level.FINE, "WindowsSupport: found {0} shell in {1}", new Object[]{this.activeShell.type, this.activeShell.bindir.getAbsolutePath()});
        }
    }

    public static WindowsSupport getInstance() {
        return instance;
    }

    public String getShell() {
        return this.activeShell == null ? null : this.activeShell.shell;
    }

    public synchronized void init() {
        this.init(null);
    }

    public void init(String searchDir) {
        if (!this.isWindows) {
            return;
        }
        this.pathConverter = new SimpleConverter();
        this.activeShell = this.findShell(searchDir);
        this.initCharset();
    }

    private Shell findShell(String searchDir) {
        String[] msysRegKeys;
        String[][] cygwinRegKeys;
        Shell shell = null;
        Shell candidate = null;
        String reg_exe = "reg.exe";
        try {
            String windir = System.getenv("WINDIR");
            File sys32 = new File(windir, "System32");
            reg_exe = new File(sys32, "reg.exe").getPath();
        }
        catch (Throwable th) {
            System.out.println(th);
        }
        this.REG_EXE = reg_exe;
        for (String[] regKey : cygwinRegKeys = new String[][]{{"HKLM\\SOFTWARE\\cygwin\\setup\\", "rootdir", ".*rootdir.*REG_SZ(.*)"}, {"HKLM\\SOFTWARE\\Wow6432Node\\cygwin\\setup\\", "rootdir", ".*rootdir.*REG_SZ(.*)"}, {"HKLM\\SOFTWARE\\Cygnus Solutions\\Cygwin\\mounts v2\\/", "native", ".*native.*REG_SZ(.*)"}, {"HKLM\\SOFTWARE\\Wow6432Node\\Cygnus Solutions\\Cygwin\\mounts v2\\/", "native", ".*native.*REG_SZ(.*)"}}) {
            shell = this.initShell(Shell.ShellType.CYGWIN, this.queryWindowsRegistry(regKey[0], regKey[1], regKey[2]));
            if (shell == null) continue;
            return shell;
        }
        for (String regKey : msysRegKeys = new String[]{"HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\MSYS-1.0_is1", "HKLM\\SOFTWARE\\Wow6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\MSYS-1.0_is1"}) {
            shell = this.initShell(Shell.ShellType.MSYS, this.queryWindowsRegistry(regKey, "Inno Setup: App Path", ".*REG_SZ(.*)"));
            if (shell == null) continue;
            return shell;
        }
        String paths = System.getenv("PATH");
        if (searchDir != null && searchDir.length() > 0) {
            paths = searchDir + ';' + paths;
        }
        if (paths != null) {
            for (String path : paths.split(";")) {
                File sh = new File(path, "sh.exe");
                File parent = sh.getParentFile();
                if (!sh.exists() || !sh.canRead() || !"bin".equals(parent.getName())) continue;
                if (new File(parent, "cygcheck.exe").exists()) {
                    ShellValidationSupport.ShellValidationStatus validationStatus;
                    if (candidate == null) {
                        candidate = new Shell(Shell.ShellType.CYGWIN, sh.getAbsolutePath(), parent);
                    }
                    if (!(validationStatus = ShellValidationSupport.getValidationStatus(candidate)).isValid() || validationStatus.hasWarnings()) continue;
                    return candidate;
                }
                if (!new File(parent, "msysinfo").exists()) continue;
                return new Shell(Shell.ShellType.MSYS, sh.getAbsolutePath(), parent);
            }
        }
        return candidate;
    }

    public int getWinPID(int shellPID) {
        ProcessBuilder pb = null;
        File psFile = new File(this.getActiveShell().bindir, "ps.exe");
        if (!psFile.exists()) {
            return shellPID;
        }
        String psCommand = psFile.getAbsolutePath();
        switch (this.getActiveShell().type) {
            case CYGWIN: {
                pb = new ProcessBuilder(psCommand, "-W", "-p", Integer.toString(shellPID));
                break;
            }
            case MSYS: {
                pb = new ProcessBuilder(psCommand, "-W");
                break;
            }
            default: {
                return shellPID;
            }
        }
        try {
            Process p = pb.start();
            List<String> output = ProcessUtils.readProcessOutput(p);
            Pattern pat = Pattern.compile("[I]*[\t ]*([0-9]+)[\t ]*([0-9]+)[\t ]*([0-9]+)[\t ]*([0-9]+).*");
            for (String s : output) {
                Integer pid;
                Matcher m = pat.matcher(s);
                if (!m.matches() || (pid = Integer.valueOf(Integer.parseInt(m.group(1)))) != shellPID) continue;
                return Integer.parseInt(m.group(4));
            }
        }
        catch (IOException ex) {
            return shellPID;
        }
        return shellPID;
    }

    private String queryWindowsRegistry(String key, String param, String regExpr) {
        try {
            ProcessBuilder pb = new ProcessBuilder(this.REG_EXE, "query", key, "/v", param);
            Process p = pb.start();
            Pattern pattern = Pattern.compile(regExpr);
            try {
                p.waitFor();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            List<String> out = ProcessUtils.readProcessOutput(p);
            for (String s : out) {
                Matcher m = pattern.matcher(s);
                if (!m.matches()) continue;
                return m.group(1).trim();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (key.toLowerCase().startsWith("hklm")) {
            return this.queryWindowsRegistry("HKCU" + key.substring(4), param, regExpr);
        }
        return null;
    }

    public String convertToCygwinPath(String winPath) {
        return this.convert(PathConverter.PathType.WINDOWS, PathConverter.PathType.CYGWIN, winPath, true);
    }

    public String convertFromCygwinPath(String cygwinPath) {
        return this.convert(PathConverter.PathType.CYGWIN, PathConverter.PathType.WINDOWS, cygwinPath, true);
    }

    public String convertToMSysPath(String winPath) {
        return this.convert(PathConverter.PathType.WINDOWS, PathConverter.PathType.MSYS, winPath, true);
    }

    public String convertFromMSysPath(String msysPath) {
        return this.convert(PathConverter.PathType.MSYS, PathConverter.PathType.WINDOWS, msysPath, true);
    }

    public String convertToShellPath(String path) {
        return this.activeShell == null ? null : this.convert(PathConverter.PathType.WINDOWS, this.activeShell.type.toPathType(), path, true);
    }

    public String convertToWindowsPath(String path) {
        return this.activeShell == null ? null : this.convert(this.activeShell.type.toPathType(), PathConverter.PathType.WINDOWS, path, true);
    }

    public String convertToAllShellPaths(String paths) {
        return this.activeShell == null ? null : this.convert(PathConverter.PathType.WINDOWS, this.activeShell.type.toPathType(), paths, false);
    }

    private String convert(PathConverter.PathType from, PathConverter.PathType to, String path, boolean isSinglePath) {
        if (to == null || from == null) {
            return null;
        }
        if (!(from != PathConverter.PathType.CYGWIN && to != PathConverter.PathType.CYGWIN || this.activeShell != null && this.activeShell.type == Shell.ShellType.CYGWIN)) {
            return null;
        }
        return isSinglePath ? this.pathConverter.convert(from, to, path) : this.pathConverter.convertAll(from, to, path);
    }

    public Charset getShellCharset() {
        return this.charset;
    }

    private Shell initShell(Shell.ShellType type, String root) {
        if (root == null) {
            return null;
        }
        File sh = new File(root + "/bin/sh.exe");
        if (!sh.exists() || !sh.canRead()) {
            return null;
        }
        return new Shell(type, sh.getAbsolutePath(), sh.getParentFile().getAbsoluteFile());
    }

    public Shell getActiveShell() {
        return this.activeShell;
    }

    private void initCharset() {
        this.charset = Charset.defaultCharset();
        if (this.activeShell == null || this.activeShell.type != Shell.ShellType.CYGWIN) {
            return;
        }
        try {
            ProcessBuilder shellBuilder = new ProcessBuilder(this.activeShell.shell, "--login", "-s");
            Process shellProcess = shellBuilder.start();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(shellProcess.getOutputStream()));
            writer.write("echo $LANG\n");
            writer.close();
            String shellOutput = ProcessUtils.readProcessOutputLine(shellProcess);
            if (shellOutput.length() > 0) {
                if (shellOutput.contains(".")) {
                    shellOutput = shellOutput.substring(shellOutput.indexOf(46) + 1);
                }
                try {
                    this.charset = Charset.forName(shellOutput);
                    return;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            String cygwinVersion = null;
            ProcessBuilder pb = new ProcessBuilder(this.activeShell.bindir + "\\uname.exe", "-r");
            Process process = pb.start();
            process.waitFor();
            String output = ProcessUtils.readProcessOutputLine(process);
            Pattern p = Pattern.compile("^([0-9\\.]*).*");
            Matcher m = p.matcher(output);
            if (m.matches()) {
                cygwinVersion = m.group(1);
            }
            if (cygwinVersion == null) {
                return;
            }
            if (cygwinVersion.startsWith("1.7")) {
                this.charset = Charset.forName("UTF-8");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

