/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.PasswordManager;
import org.netbeans.modules.nativeexecution.api.util.ValidateablePanel;
import org.netbeans.modules.nativeexecution.support.Authentication;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.netbeans.modules.nativeexecution.support.RemoteUserInfo;
import org.netbeans.modules.nativeexecution.support.ui.AuthTypeSelectorDlg;
import org.netbeans.modules.nativeexecution.support.ui.AuthenticationSettingsPanel;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ConnectionManager {
    private static final java.util.logging.Logger log = org.netbeans.modules.nativeexecution.support.Logger.getInstance();
    private static final boolean USE_JZLIB = Boolean.getBoolean("jzlib");
    private static final int JSCH_CONNECTION_TIMEOUT = Integer.getInteger("jsch.connection.timeout", 10000);
    private static final int SOCKET_CREATION_TIMEOUT = Integer.getInteger("socket.connection.timeout", 10000);
    private static final boolean UNIT_TEST_MODE = Boolean.getBoolean("nativeexecution.mode.unittest");
    private static final RequestProcessor connectorThread = new RequestProcessor("ConnectionManager queue", 1);
    private static final HashMap<ExecutionEnvironment, Session> sessions = new HashMap();
    private static final HashMap<ExecutionEnvironment, JSch> jschPool = new HashMap();
    private static List<ConnectionListener> connectionListeners = new CopyOnWriteArrayList<ConnectionListener>();
    private static HashMap<ExecutionEnvironment, ConnectToAction> connectionActions = new HashMap();
    private static final ConnectionManager instance = new ConnectionManager();

    private ConnectionManager() {
        if (log.isLoggable(Level.FINEST)) {
            JSch.setLogger((Logger)new Logger(){

                public boolean isEnabled(int level) {
                    return true;
                }

                public void log(int level, String message) {
                    log.log(Level.FINEST, "JSCH: {0}", message);
                }
            });
        }
    }

    public void addConnectionListener(ConnectionListener listener) {
        connectionListeners.add(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        connectionListeners.remove(listener);
    }

    private void fireConnected(ExecutionEnvironment execEnv) {
        for (ConnectionListener connectionListener : connectionListeners) {
            connectionListener.connected(execEnv);
        }
    }

    private void fireDisconnected(ExecutionEnvironment execEnv) {
        for (ConnectionListener connectionListener : connectionListeners) {
            connectionListener.disconnected(execEnv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectedTo(ExecutionEnvironment execEnv) {
        if (execEnv.isLocal()) {
            return true;
        }
        HashMap<ExecutionEnvironment, Session> hashMap = sessions;
        synchronized (hashMap) {
            if (sessions.containsKey(execEnv)) {
                return sessions.get(execEnv).isConnected();
            }
            return false;
        }
    }

    public void connectTo(ExecutionEnvironment env) throws IOException, CancellationException {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalThreadStateException("Should never be called from AWT thread");
        }
        if (this.isConnectedTo(env)) {
            return;
        }
        int attempts = 2;
        while (attempts > 0 && !this.doConnect(env, true)) {
            if (!UNIT_TEST_MODE) continue;
            --attempts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doConnect(ExecutionEnvironment env, boolean fetchHostInfo) throws IOException, CancellationException {
        ConnectionTask connectionTask = new ConnectionTask(env);
        Future connectionTaskResult = connectorThread.submit((Callable)connectionTask);
        ProgressHandle ph = ProgressHandleFactory.createHandle((String)ConnectionManager.loc("ConnectionManager.Connecting", ((Object)env).toString()), (Cancellable)connectionTask);
        ph.start();
        Session session = null;
        try {
            session = (Session)connectionTaskResult.get();
        }
        catch (InterruptedException ex) {
            throw new CancellationException("Connection cancelled for " + env);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            ph.finish();
        }
        if (connectionTask.cancelled) {
            throw new CancellationException("Connection cancelled for " + env);
        }
        if (connectionTask.problem != null) {
            if (connectionTask.problem == Problem.AUTH_FAIL) {
                log.log(Level.FINE, "JSch problem connecting to {0}: {1}", new Object[]{env, connectionTask.problem});
                if (!UNIT_TEST_MODE) {
                    PasswordManager.getInstance().clearPassword(env);
                }
                return false;
            }
            throw new IOException(env.getDisplayName() + ": " + connectionTask.problem.name());
        }
        assert (session != null);
        HashMap<ExecutionEnvironment, Session> ex = sessions;
        synchronized (ex) {
            sessions.put(env, session);
        }
        if (fetchHostInfo) {
            HostInfo hostInfo = HostInfoUtils.getHostInfo(env);
            log.log(Level.FINE, "New connection established: {0} - {1}", new String[]{((Object)env).toString(), hostInfo.getOS().getName()});
        }
        this.fireConnected(env);
        return true;
    }

    public static ConnectionManager getInstance() {
        return instance;
    }

    public synchronized AsynchronousAction getConnectToAction(ExecutionEnvironment execEnv, Runnable onConnect) {
        if (connectionActions.containsKey(execEnv)) {
            return connectionActions.get(execEnv);
        }
        ConnectToAction action = new ConnectToAction(execEnv, onConnect);
        connectionActions.put(execEnv, action);
        return action;
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(ConnectionManager.class, (String)key, (Object[])params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession(ExecutionEnvironment execEnv, boolean restoreLostConnection) {
        HashMap<ExecutionEnvironment, Session> hashMap = sessions;
        synchronized (hashMap) {
            if (sessions.containsKey(execEnv)) {
                int attempts = 3;
                while (attempts-- > 0) {
                    Session session = sessions.get(execEnv);
                    if (!restoreLostConnection || session.isConnected()) {
                        return session;
                    }
                    try {
                        this.reconnect(execEnv);
                    }
                    catch (IOException ex) {
                        return null;
                    }
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect(ExecutionEnvironment env) throws IOException {
        HashMap<ExecutionEnvironment, Session> hashMap = sessions;
        synchronized (hashMap) {
            this.disconnectImpl(env);
            this.connectTo(env);
        }
    }

    public void disconnect(ExecutionEnvironment env) {
        this.disconnectImpl(env);
        PasswordManager.getInstance().onExplicitDisconnect(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectImpl(ExecutionEnvironment env) {
        HashMap<ExecutionEnvironment, Session> hashMap = sessions;
        synchronized (hashMap) {
            JSch jsch;
            Session session = sessions.remove(env);
            if (session != null) {
                session.disconnect();
                this.fireDisconnected(env);
            }
            if ((jsch = jschPool.get(env)) != null) {
                jschPool.remove(env);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdown() {
        ArrayList<ExecutionEnvironment> connectedEnvs;
        log.fine("Shutting down Connection Manager");
        HashMap<ExecutionEnvironment, Session> hashMap = sessions;
        synchronized (hashMap) {
            connectedEnvs = new ArrayList<ExecutionEnvironment>(sessions.keySet());
        }
        for (ExecutionEnvironment env : connectedEnvs) {
            ConnectionManager.getInstance().disconnect(env);
        }
    }

    public ValidateablePanel getConfigurationPanel(ExecutionEnvironment env) {
        Authentication auth = Authentication.getFor(env);
        AuthenticationSettingsPanel panel = new AuthenticationSettingsPanel(auth, env != null);
        return panel;
    }

    public void forget(ExecutionEnvironment env) {
        if (env == null) {
            return;
        }
        Authentication.getFor(env).remove();
        jschPool.remove(env);
    }

    private static boolean initJsch(ExecutionEnvironment env) {
        Authentication auth = Authentication.getFor(env);
        if (!auth.isDefined()) {
            AuthTypeSelectorDlg dlg = new AuthTypeSelectorDlg();
            if (!dlg.initAuthentication(auth)) {
                return false;
            }
        } else {
            auth.apply();
        }
        return true;
    }

    static {
        ConnectionManagerAccessor.setDefault(new ConnectionManagerAccessorImpl());
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                ConnectionManager.shutdown();
            }
        }));
    }

    private static final class ConnectionManagerAccessorImpl
    extends ConnectionManagerAccessor {
        private ConnectionManagerAccessorImpl() {
        }

        @Override
        public Session getConnectionSession(ExecutionEnvironment env, boolean restoreLostConnection) {
            return instance.getSession(env, restoreLostConnection);
        }

        @Override
        public void reconnect(ExecutionEnvironment env) throws IOException {
            instance.reconnect(env);
        }

        @Override
        public void changeAuth(ExecutionEnvironment env, Authentication auth) {
            JSch jsch = (JSch)jschPool.get(env);
            if (jsch != null) {
                try {
                    jsch.removeAllIdentity();
                }
                catch (JSchException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                try {
                    String knownHosts = auth.getKnownHosts();
                    if (knownHosts != null) {
                        jsch.setKnownHosts(knownHosts);
                    }
                }
                catch (JSchException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                switch (auth.getType()) {
                    case SSH_KEY: {
                        try {
                            jsch.addIdentity(auth.getKey());
                            break;
                        }
                        catch (JSchException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
        }

        @Override
        public boolean doConnect(ExecutionEnvironment execEnv, boolean fetchHostInfo) throws IOException, CancellationException {
            return instance.doConnect(execEnv, fetchHostInfo);
        }
    }

    private static enum Problem {
        ENV_PREPARE_ERROR,
        AUTH_FAIL,
        HOST_UNREACHABLE,
        CONNECTION_FAILED,
        CONNECTION_TIMEOUT;

    }

    private static class ConnectToAction
    extends AbstractAction
    implements AsynchronousAction {
        private static final ConnectionManager cm = ConnectionManager.getInstance();
        private final ExecutionEnvironment env;
        private final Runnable onConnect;

        private ConnectToAction(ExecutionEnvironment execEnv, Runnable onConnect) {
            this.env = execEnv;
            this.onConnect = onConnect;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NativeTaskExecutorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConnectToAction.this.invoke();
                    }
                    catch (Throwable ex) {
                        log.warning(ex.getMessage());
                    }
                }
            }, "Connecting to " + ((Object)this.env).toString());
        }

        @Override
        public synchronized void invoke() throws IOException, CancellationException {
            if (cm.isConnectedTo(this.env)) {
                return;
            }
            cm.connectTo(this.env);
            this.onConnect.run();
        }
    }

    private static final class ConnectionTask
    implements Callable<Session>,
    Cancellable {
        private final ExecutionEnvironment env;
        private volatile boolean cancelled = false;
        private volatile Problem problem = null;

        private ConnectionTask(ExecutionEnvironment env) {
            this.env = env;
        }

        @Override
        public Session call() throws Exception {
            Session newSession = null;
            try {
                try {
                    this.env.prepareForConnection();
                }
                catch (Throwable th) {
                    this.problem = Problem.ENV_PREPARE_ERROR;
                    return null;
                }
                if (this.cancelled) {
                    return null;
                }
                if (!this.isReachable()) {
                    this.problem = Problem.HOST_UNREACHABLE;
                    return null;
                }
                if (this.cancelled) {
                    return null;
                }
                RemoteUserInfo userInfo = new RemoteUserInfo(this.env, !UNIT_TEST_MODE);
                JSch jsch = (JSch)jschPool.get(this.env);
                if (jsch == null) {
                    jsch = new JSch();
                    jschPool.put(this.env, jsch);
                    if (!ConnectionManager.initJsch(this.env)) {
                        jschPool.remove(this.env);
                        this.cancelled = true;
                        return null;
                    }
                }
                newSession = jsch.getSession(this.env.getUser(), this.env.getHostAddress(), this.env.getSSHPort());
                newSession.setUserInfo((UserInfo)userInfo);
                if (USE_JZLIB) {
                    newSession.setConfig("compression.s2c", "zlib@openssh.com,zlib,none");
                    newSession.setConfig("compression.c2s", "zlib@openssh.com,zlib,none");
                    newSession.setConfig("compression_level", "9");
                }
                try {
                    newSession.connect(JSCH_CONNECTION_TIMEOUT);
                }
                catch (JSchException e) {
                    log.log(Level.FINE, "JSchException connecting to " + this.env, e);
                    if (e.getMessage().equals("Auth fail")) {
                        this.problem = Problem.AUTH_FAIL;
                        return null;
                    }
                    if (e.getMessage().equals("Auth cancel")) {
                        this.cancelled = true;
                        return null;
                    }
                    if (e.getMessage().contains("java.net.SocketTimeoutException") || e.getMessage().contains("timeout")) {
                        this.problem = Problem.CONNECTION_TIMEOUT;
                        return null;
                    }
                    this.problem = Problem.CONNECTION_FAILED;
                }
                catch (CancellationException ex) {
                    log.log(Level.FINE, "CancellationException", ex);
                    this.cancelled = true;
                    return null;
                }
            }
            catch (Throwable th) {
                Exceptions.printStackTrace((Throwable)th);
                this.problem = Problem.CONNECTION_FAILED;
            }
            return newSession;
        }

        public Problem getProblem() {
            return this.problem;
        }

        private boolean isReachable() throws IOException {
            Callable<Boolean> checker = new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean call() throws Exception {
                    Socket socket = new Socket();
                    InetSocketAddress addressToConnect = new InetSocketAddress(ConnectionTask.this.env.getHostAddress(), ConnectionTask.this.env.getSSHPort());
                    try {
                        socket.connect(addressToConnect, SOCKET_CREATION_TIMEOUT);
                    }
                    catch (Exception ioe) {
                        Boolean bl = false;
                        return bl;
                    }
                    finally {
                        socket.close();
                    }
                    return true;
                }
            };
            Future<Boolean> task = NativeTaskExecutorService.submit(checker, "Host " + this.env.getHost() + " availability test");
            while (!this.cancelled && !task.isDone()) {
                try {
                    task.get(500L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                }
                catch (TimeoutException ex) {}
            }
            boolean result = false;
            if (task.isDone()) {
                try {
                    result = task.get();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return result;
        }

        public boolean cancel() {
            this.cancelled = true;
            return true;
        }
    }
}

