/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.SetupProvider;
import org.netbeans.modules.cnd.dwarfdump.Offset2LineService;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public class RemoteJarServiceProvider
implements SetupProvider {
    private static final Class<?> service = Offset2LineService.class;
    private static final String prefix = "/modules/";
    private static final String relativePath;
    private static final String localAbsPath;

    private static String[] findPaths() {
        try {
            String path = service.getProtectionDomain().getCodeSource().getLocation().getPath();
            path = path.replace('\\', '/');
            path = path.substring(path.lastIndexOf(prefix) + 1);
            if (path.indexOf(33) > 0) {
                path = path.substring(0, path.indexOf(33));
            }
            String relPath = path;
            String absPath = null;
            File file = InstalledFileLocator.getDefault().locate(relPath, null, false);
            if (file != null) {
                absPath = file.getAbsolutePath();
            }
            return new String[]{relPath, absPath};
        }
        catch (Throwable thr) {
            Exceptions.printStackTrace((Throwable)thr);
            return new String[]{null, null};
        }
    }

    public Map<String, String> getBinaryFiles(ExecutionEnvironment env) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (relativePath != null && localAbsPath != null) {
            result.put(relativePath, localAbsPath);
        }
        return result;
    }

    public static NativeProcess getJavaProcess(Class<?> clazz, ExecutionEnvironment env, String[] arguments) throws IOException {
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)env);
        npb.setCharset(Charset.forName("UTF-8"));
        npb.setExecutable("java");
        ArrayList<String> args = new ArrayList<String>();
        args.add("-cp");
        if (env.isLocal()) {
            args.add(localAbsPath == null ? "." : localAbsPath);
        } else {
            String libDir = HostInfoProvider.getLibDir((ExecutionEnvironment)env);
            if (!libDir.endsWith("/")) {
                libDir = libDir + "/";
            }
            String resource = libDir + relativePath;
            args.add(resource);
        }
        args.add(clazz.getName());
        args.addAll(Arrays.asList(arguments));
        npb.setArguments(args.toArray(new String[args.size()]));
        return npb.call();
    }

    static {
        String[] paths = RemoteJarServiceProvider.findPaths();
        relativePath = paths[0];
        localAbsPath = paths[1];
    }
}

