/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.resourcesloader;

import java.io.InputStream;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.xml.cookies.CheckXMLCookie;
import org.netbeans.api.xml.cookies.ValidateXMLCookie;
import org.netbeans.modules.j2ee.sun.dd.api.DDProvider;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.AdminObjectResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JmsResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.MailResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.PersistenceManagerFactoryResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.Resources;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ConnPoolBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ConnPoolBeanDataNode;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.DataSourceBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.DataSourceBeanDataNode;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.JMSBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.JMSBeanDataNode;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.JavaMailSessionBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.JavaMailSessionBeanDataNode;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.PersistenceManagerBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.PersistenceManagerBeanDataNode;
import org.netbeans.modules.j2ee.sun.ide.sunresources.resourcesloader.SunResourceDataLoader;
import org.netbeans.modules.j2ee.sun.ide.sunresources.resourcesloader.SunResourceDataNode;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.xml.sax.InputSource;

public class SunResourceDataObject
extends XMLDataObject
implements FileChangeListener {
    private static final Logger LOG = Logger.getLogger(SunResourceDataObject.class.getName());
    private static String JDBC_CP = "jdbc-connection-pool";
    private static String JDBC_DS = "jdbc-resource";
    private static String PMF = "persistence-manager-factory-resource";
    private static String MAIL = "mail-resource";
    private static String JMS = "jms-resource";
    private transient ValidateXMLCookie validateCookie = null;
    private transient CheckXMLCookie checkCookie = null;
    ConnPoolBean cpBean = null;
    DataSourceBean dsBean = null;
    PersistenceManagerBean pmfBean = null;
    JavaMailSessionBean mailBean = null;
    JMSBean jmsBean = null;
    String resType;

    public SunResourceDataObject(FileObject pf, SunResourceDataLoader loader) throws DataObjectExistsException {
        super(pf, (MultiFileLoader)loader);
        pf.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this), (Object)pf));
        this.resType = this.getResource(pf);
    }

    public <T extends Node.Cookie> T getCookie(Class<T> c) {
        Node.Cookie retValue = null;
        if (ValidateXMLCookie.class.isAssignableFrom(c)) {
            if (this.validateCookie == null) {
                InputSource in = DataObjectAdapters.inputSource((DataObject)this);
                this.validateCookie = new ValidateXMLSupport(in);
            }
            return (T)this.validateCookie;
        }
        if (CheckXMLCookie.class.isAssignableFrom(c)) {
            if (this.checkCookie == null) {
                InputSource in = DataObjectAdapters.inputSource((DataObject)this);
                this.checkCookie = new CheckXMLSupport(in);
            }
            return (T)this.checkCookie;
        }
        if (retValue == null) {
            retValue = super.getCookie(c);
        }
        return (T)retValue;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected Node createNodeDelegate() {
        if (this.resType != null) {
            if (this.resType.equals(JDBC_CP)) {
                ConnPoolBeanDataNode node = new ConnPoolBeanDataNode(this, this.getPool());
                return node;
            }
            if (this.resType.equals(JDBC_DS)) {
                DataSourceBeanDataNode node = new DataSourceBeanDataNode(this, this.getDataSource());
                return node;
            }
            if (this.resType.equals(PMF)) {
                PersistenceManagerBeanDataNode node = new PersistenceManagerBeanDataNode(this, this.getPersistenceManager());
                return node;
            }
            if (this.resType.equals(MAIL)) {
                JavaMailSessionBeanDataNode node = new JavaMailSessionBeanDataNode(this, this.getMailSession());
                return node;
            }
            if (this.resType.equals(JMS)) {
                JMSBeanDataNode node = new JMSBeanDataNode(this, this.getJMS());
                return node;
            }
            String mess = NbBundle.getMessage(SunResourceDataObject.class, (String)"Info_notSunResource");
            LOG.log(Level.INFO, mess);
            return new SunResourceDataNode(this);
        }
        return new SunResourceDataNode(this);
    }

    private String getResource(FileObject primaryFile) {
        String type = null;
        try {
            if (!primaryFile.isFolder() && primaryFile.isValid()) {
                AdminObjectResource[] aoResources;
                JmsResource[] jmsResources;
                MailResource[] mailResources;
                PersistenceManagerFactoryResource[] pmfResources;
                JdbcResource[] dataSources;
                InputStream in = primaryFile.getInputStream();
                Resources resources = DDProvider.getDefault().getResourcesGraph(in);
                JdbcConnectionPool[] pools = resources.getJdbcConnectionPool();
                if (pools.length != 0) {
                    ConnPoolBean currCPBean = ConnPoolBean.createBean(pools[0]);
                    type = JDBC_CP;
                    this.setPool(currCPBean);
                }
                if ((dataSources = resources.getJdbcResource()).length != 0) {
                    DataSourceBean currDSBean = DataSourceBean.createBean(dataSources[0]);
                    type = JDBC_DS;
                    this.setDataSource(currDSBean);
                }
                if ((pmfResources = resources.getPersistenceManagerFactoryResource()).length != 0) {
                    PersistenceManagerBean currPMFBean = PersistenceManagerBean.createBean(pmfResources[0]);
                    type = PMF;
                    this.setPersistenceManager(currPMFBean);
                }
                if ((mailResources = resources.getMailResource()).length != 0) {
                    JavaMailSessionBean currMailBean = JavaMailSessionBean.createBean(mailResources[0]);
                    type = MAIL;
                    this.setMailSession(currMailBean);
                }
                if ((jmsResources = resources.getJmsResource()).length != 0) {
                    JMSBean currJmsBean = JMSBean.createBean(jmsResources[0]);
                    type = JMS;
                    this.setJMS(currJmsBean);
                }
                if ((aoResources = resources.getAdminObjectResource()).length != 0) {
                    JMSBean currJmsBean = JMSBean.createBean(aoResources[0]);
                    type = JMS;
                    this.setJMS(currJmsBean);
                }
                ConnectorResource[] connResources = resources.getConnectorResource();
                ConnectorConnectionPool[] connPoolResources = resources.getConnectorConnectionPool();
                if (connResources.length != 0 && connPoolResources.length != 0) {
                    JMSBean currJmsBean = JMSBean.createBean(resources);
                    type = JMS;
                    this.setJMS(currJmsBean);
                }
            }
        }
        catch (NullPointerException npe) {
            LOG.log(Level.SEVERE, "Unable to load *.sun-resource file", npe);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Unable to load *.sun-resource file", ex);
        }
        return type;
    }

    private void setPool(ConnPoolBean in_cpBean) {
        this.cpBean = in_cpBean;
    }

    private ConnPoolBean getPool() {
        return this.cpBean;
    }

    private void setDataSource(DataSourceBean in_dsBean) {
        this.dsBean = in_dsBean;
    }

    private DataSourceBean getDataSource() {
        return this.dsBean;
    }

    private void setPersistenceManager(PersistenceManagerBean in_pmfBean) {
        this.pmfBean = in_pmfBean;
    }

    private PersistenceManagerBean getPersistenceManager() {
        return this.pmfBean;
    }

    private void setMailSession(JavaMailSessionBean in_mailBean) {
        this.mailBean = in_mailBean;
    }

    private JavaMailSessionBean getMailSession() {
        return this.mailBean;
    }

    private void setJMS(JMSBean in_jmsBean) {
        this.jmsBean = in_jmsBean;
    }

    private JMSBean getJMS() {
        return this.jmsBean;
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        this.updateDataObject();
    }

    public void fileChanged(FileEvent fe) {
        this.updateDataObject();
    }

    public void fileDataCreated(FileEvent fe) {
        this.updateDataObject();
    }

    public void fileDeleted(FileEvent fe) {
        this.updateDataObject();
    }

    public void fileFolderCreated(FileEvent fe) {
        this.updateDataObject();
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.updateDataObject();
    }

    private void updateDataObject() {
        this.resType = this.getResource(this.getPrimaryFile());
    }

    public String getResourceType() {
        return this.resType;
    }
}

