/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.httpclient.impl.client;

import org.apache.maven.wagon.providers.http.httpclient.HttpVersion;
import org.apache.maven.wagon.providers.http.httpclient.annotation.ThreadSafe;
import org.apache.maven.wagon.providers.http.httpclient.client.protocol.RequestAddCookies;
import org.apache.maven.wagon.providers.http.httpclient.client.protocol.RequestAuthCache;
import org.apache.maven.wagon.providers.http.httpclient.client.protocol.RequestClientConnControl;
import org.apache.maven.wagon.providers.http.httpclient.client.protocol.RequestDefaultHeaders;
import org.apache.maven.wagon.providers.http.httpclient.client.protocol.RequestProxyAuthentication;
import org.apache.maven.wagon.providers.http.httpclient.client.protocol.RequestTargetAuthentication;
import org.apache.maven.wagon.providers.http.httpclient.client.protocol.ResponseAuthCache;
import org.apache.maven.wagon.providers.http.httpclient.client.protocol.ResponseProcessCookies;
import org.apache.maven.wagon.providers.http.httpclient.conn.ClientConnectionManager;
import org.apache.maven.wagon.providers.http.httpclient.impl.client.AbstractHttpClient;
import org.apache.maven.wagon.providers.http.httpclient.params.HttpConnectionParams;
import org.apache.maven.wagon.providers.http.httpclient.params.HttpParams;
import org.apache.maven.wagon.providers.http.httpclient.params.HttpProtocolParams;
import org.apache.maven.wagon.providers.http.httpclient.params.SyncBasicHttpParams;
import org.apache.maven.wagon.providers.http.httpclient.protocol.BasicHttpProcessor;
import org.apache.maven.wagon.providers.http.httpclient.protocol.RequestContent;
import org.apache.maven.wagon.providers.http.httpclient.protocol.RequestExpectContinue;
import org.apache.maven.wagon.providers.http.httpclient.protocol.RequestTargetHost;
import org.apache.maven.wagon.providers.http.httpclient.protocol.RequestUserAgent;
import org.apache.maven.wagon.providers.http.httpclient.util.VersionInfo;

@ThreadSafe
public class DefaultHttpClient
extends AbstractHttpClient {
    public DefaultHttpClient(ClientConnectionManager conman, HttpParams params) {
        super(conman, params);
    }

    public DefaultHttpClient(ClientConnectionManager conman) {
        super(conman, null);
    }

    public DefaultHttpClient(HttpParams params) {
        super(null, params);
    }

    public DefaultHttpClient() {
        super(null, null);
    }

    protected HttpParams createHttpParams() {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        DefaultHttpClient.setDefaultHttpParams(params);
        return params;
    }

    public static void setDefaultHttpParams(HttpParams params) {
        HttpProtocolParams.setVersion(params, HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset(params, "ISO-8859-1");
        HttpConnectionParams.setTcpNoDelay(params, true);
        HttpConnectionParams.setSocketBufferSize(params, 8192);
        VersionInfo vi = VersionInfo.loadVersionInfo("org.apache.maven.wagon.providers.http.httpclient.client", DefaultHttpClient.class.getClassLoader());
        String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
        HttpProtocolParams.setUserAgent(params, "Apache-HttpClient/" + release + " (java 1.5)");
    }

    protected BasicHttpProcessor createHttpProcessor() {
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor(new RequestDefaultHeaders());
        httpproc.addInterceptor(new RequestContent());
        httpproc.addInterceptor(new RequestTargetHost());
        httpproc.addInterceptor(new RequestClientConnControl());
        httpproc.addInterceptor(new RequestUserAgent());
        httpproc.addInterceptor(new RequestExpectContinue());
        httpproc.addInterceptor(new RequestAddCookies());
        httpproc.addInterceptor(new ResponseProcessCookies());
        httpproc.addInterceptor(new RequestAuthCache());
        httpproc.addInterceptor(new ResponseAuthCache());
        httpproc.addInterceptor(new RequestTargetAuthentication());
        httpproc.addInterceptor(new RequestProxyAuthentication());
        return httpproc;
    }
}

