/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.SystemDialog;

public class Resource {
    XMultiServiceFactory xMSF;
    String Module;
    XIndexAccess xStringIndexAccess;
    XIndexAccess xStringListIndexAccess;

    public Resource(XMultiServiceFactory xMultiServiceFactory, String string, String string2) {
        this.xMSF = xMultiServiceFactory;
        this.Module = string2;
        try {
            Object[] objectArray = new Object[]{this.Module};
            XInterface xInterface = (XInterface)this.xMSF.createInstanceWithArguments("org.libreoffice.resource.ResourceIndexAccess", objectArray);
            if (xInterface == null) {
                throw new Exception("could not initialize ResourceIndexAccess");
            }
            XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xInterface);
            if (xNameAccess == null) {
                throw new Exception("ResourceIndexAccess is no XNameAccess");
            }
            this.xStringIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xNameAccess.getByName("String"));
            this.xStringListIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xNameAccess.getByName("StringList"));
            if (this.xStringListIndexAccess == null) {
                throw new Exception("could not initialize xStringListIndexAccess");
            }
            if (this.xStringIndexAccess == null) {
                throw new Exception("could not initialize xStringIndexAccess");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Resource.showCommonResourceError(this.xMSF);
        }
    }

    public String getResText(int n) {
        try {
            return (String)this.xStringIndexAccess.getByIndex(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException("Resource with ID not " + String.valueOf(n) + "not found");
        }
    }

    public PropertyValue[] getStringList(int n) {
        try {
            return (PropertyValue[])this.xStringListIndexAccess.getByIndex(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException("Resource with ID not " + String.valueOf(n) + "not found");
        }
    }

    public String[] getResArray(int n, int n2) {
        try {
            String[] stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = this.getResText(n + i);
            }
            return stringArray;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw new IllegalArgumentException("Resource with ID not" + String.valueOf(n) + "not found");
        }
    }

    public static void showCommonResourceError(XMultiServiceFactory xMultiServiceFactory) {
        String string = Configuration.getProductName(xMultiServiceFactory);
        String string2 = "The files required could not be found.\nPlease start the %PRODUCTNAME Setup and choose 'Repair'.";
        string2 = JavaTools.replaceSubString(string2, string, "%PRODUCTNAME");
        SystemDialog.showMessageBox(xMultiServiceFactory, "ErrorBox", 0x400000, string2);
    }
}

