/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.DebugHelper;
import com.sun.star.wizards.common.NumericalHelper;
import com.sun.star.wizards.common.PropertyNames;
import java.util.HashMap;

public class PropertySetHelper {
    protected XPropertySet m_xPropertySet;
    private HashMap<String, Object> m_aHashMap;

    public PropertySetHelper(Object object) {
        if (object == null) {
            return;
        }
        this.m_xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
    }

    private HashMap<String, Object> getHashMap() {
        if (this.m_aHashMap == null) {
            this.m_aHashMap = new HashMap();
        }
        return this.m_aHashMap;
    }

    public void setPropertyValueDontThrow(String string, Object object) {
        try {
            this.setPropertyValue(string, object);
        }
        catch (Exception exception) {
            DebugHelper.writeInfo("Don't throw the exception with property name(" + string + " ) : " + exception.getMessage());
        }
    }

    public void setPropertyValue(String string, Object object) throws Exception {
        if (this.m_xPropertySet != null) {
            try {
                this.m_xPropertySet.setPropertyValue(string, object);
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.writeInfo(unknownPropertyException.getMessage());
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)unknownPropertyException));
            }
            catch (PropertyVetoException propertyVetoException) {
                DebugHelper.writeInfo(propertyVetoException.getMessage());
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)propertyVetoException));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.writeInfo(illegalArgumentException.getMessage());
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.writeInfo(wrappedTargetException.getMessage());
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)wrappedTargetException));
            }
        } else {
            this.getHashMap().put(string, object);
        }
    }

    public int getPropertyValueAsInteger(String string, int n) {
        Object object = null;
        int n2 = n;
        if (this.m_xPropertySet != null) {
            try {
                object = this.m_xPropertySet.getPropertyValue(string);
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.writeInfo(unknownPropertyException.getMessage());
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.writeInfo(wrappedTargetException.getMessage());
            }
        }
        if (object != null) {
            try {
                n2 = NumericalHelper.toInt(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.writeInfo("can't convert a object to integer.");
            }
        }
        return n2;
    }

    public short getPropertyValueAsShort(String string, short s) {
        Object object = null;
        short s2 = s;
        if (this.m_xPropertySet != null) {
            try {
                object = this.m_xPropertySet.getPropertyValue(string);
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.writeInfo(unknownPropertyException.getMessage());
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.writeInfo(wrappedTargetException.getMessage());
            }
        }
        if (object != null) {
            try {
                s2 = NumericalHelper.toShort(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.writeInfo("can't convert a object to short.");
            }
        }
        return s2;
    }

    public double getPropertyValueAsDouble(String string, double d) {
        Object object = null;
        double d2 = d;
        if (this.m_xPropertySet != null) {
            try {
                object = this.m_xPropertySet.getPropertyValue(string);
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.writeInfo(unknownPropertyException.getMessage());
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.writeInfo(wrappedTargetException.getMessage());
            }
        }
        if (object == null && this.getHashMap().containsKey(string)) {
            object = this.getHashMap().get(string);
        }
        if (object != null) {
            try {
                d2 = NumericalHelper.toDouble(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.writeInfo("can't convert a object to integer.");
            }
        }
        return d2;
    }

    public boolean getPropertyValueAsBoolean(String string, boolean bl) {
        Object object = null;
        boolean bl2 = bl;
        if (this.m_xPropertySet != null) {
            try {
                object = this.m_xPropertySet.getPropertyValue(string);
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.writeInfo(unknownPropertyException.getMessage());
                DebugHelper.writeInfo("UnknownPropertyException caught: Name:=" + string);
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.writeInfo(wrappedTargetException.getMessage());
            }
        }
        if (object != null) {
            try {
                bl2 = NumericalHelper.toBoolean(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.writeInfo("can't convert a object to boolean.");
            }
        }
        return bl2;
    }

    public String getPropertyValueAsString(String string, String string2) {
        Object object = null;
        String string3 = string2;
        if (this.m_xPropertySet != null) {
            try {
                object = this.m_xPropertySet.getPropertyValue(string);
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.writeInfo(unknownPropertyException.getMessage());
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.writeInfo(wrappedTargetException.getMessage());
            }
        }
        if (object != null) {
            try {
                string3 = AnyConverter.toString(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.writeInfo("can't convert a object to string.");
            }
        }
        return string3;
    }

    public Object getPropertyValueAsObject(String string) {
        Object object = null;
        if (this.m_xPropertySet != null) {
            try {
                object = this.m_xPropertySet.getPropertyValue(string);
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.writeInfo(unknownPropertyException.getMessage());
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.writeInfo(wrappedTargetException.getMessage());
            }
        }
        return object;
    }

    public static void showProperties(Object object) {
        PropertySetHelper propertySetHelper = new PropertySetHelper(object);
        propertySetHelper.showProperties();
    }

    public void showProperties() {
        String string = PropertyNames.EMPTY_STRING;
        if (this.m_xPropertySet != null) {
            XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)this.m_xPropertySet);
            if (xServiceInfo != null) {
                string = xServiceInfo.getImplementationName();
            }
            XPropertySetInfo xPropertySetInfo = this.m_xPropertySet.getPropertySetInfo();
            Property[] propertyArray = xPropertySetInfo.getProperties();
            DebugHelper.writeInfo("Show all properties of Implementation of :'" + string + "'");
            for (int i = 0; i < propertyArray.length; ++i) {
                DebugHelper.writeInfo(" - " + propertyArray[i].Name);
            }
        } else {
            DebugHelper.writeInfo("The given object don't support XPropertySet interface.");
        }
    }
}

