/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.sdbcx.comp.hsqldb;

import com.sun.star.sdbcx.comp.hsqldb.NativeStorageAccess;
import java.io.IOException;
import org.hsqldb.lib.Storage;

public class StorageAccess
implements Storage {
    String key;
    String name;
    boolean readonly;
    NativeStorageAccess access;

    public StorageAccess(String string, Boolean bl, Object object) throws IOException {
        this.key = (String)object;
        this.name = string;
        this.readonly = bl;
        try {
            this.access = new NativeStorageAccess(string, this.readonly ? "r" : "rw", object);
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    @Override
    public void close() throws IOException {
        this.access.close(this.name, this.key);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.access.getFilePointer(this.name, this.key);
    }

    @Override
    public long length() throws IOException {
        return this.access.length(this.name, this.key);
    }

    @Override
    public int read() throws IOException {
        return this.access.read(this.name, this.key);
    }

    @Override
    public void read(byte[] byArray, int n, int n2) throws IOException {
        this.access.read(this.name, this.key, byArray, n, n2);
    }

    @Override
    public int readInt() throws IOException {
        byte[] byArray = new byte[4];
        int n = this.access.read(this.name, this.key, byArray, 0, 4);
        if (n != 4) {
            throw new IOException();
        }
        n = 0;
        int n2 = byArray[n++] & 0xFF;
        int n3 = byArray[n++] & 0xFF;
        int n4 = byArray[n++] & 0xFF;
        int n5 = byArray[n] & 0xFF;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    @Override
    public void seek(long l) throws IOException {
        this.access.seek(this.name, this.key, l);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.access.write(this.name, this.key, byArray, n, n2);
    }

    @Override
    public void writeInt(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n >>> 0 & 0xFF)};
        this.write(byArray, 0, 4);
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public boolean wasNio() {
        return false;
    }

    @Override
    public void writeLong(long l) throws IOException {
        byte[] byArray = new byte[]{(byte)(l >>> 56 & 0xFFL), (byte)(l >>> 48 & 0xFFL), (byte)(l >>> 40 & 0xFFL), (byte)(l >>> 32 & 0xFFL), (byte)(l >>> 24 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l >>> 0 & 0xFFL)};
        this.write(byArray, 0, 8);
    }
}

