/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.awt.XDialog;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.XComponentContext;
import com.sun.star.wiki.Helper;
import com.sun.star.wiki.MainThreadDialogExecutor;
import com.sun.star.wiki.WikiDialog;
import com.sun.star.wiki.WikiEditSettingDialog;
import com.sun.star.wiki.WikiEditorImpl;
import java.util.Hashtable;

public class WikiPropDialog
extends WikiDialog {
    WikiEditorImpl m_aWikiEditor;
    private final String sSendMethod = "Send";
    private final String sWikiListMethod = "WikiListChange";
    private final String sArticleTextMethod = "ArticleTextChange";
    private final String sAddWikiMethod = "AddWiki";
    String[] m_pMethods = new String[]{"Send", "WikiListChange", "ArticleTextChange", "AddWiki"};
    private String m_sWikiTitle = "";
    protected String m_sWikiEngineURL = "";
    protected String m_sWikiComment = "";
    protected boolean m_bWikiMinorEdit = false;

    public WikiPropDialog(XComponentContext xComponentContext, String string, WikiEditorImpl wikiEditorImpl) {
        super(xComponentContext, string);
        super.setMethods(this.m_pMethods);
        if (wikiEditorImpl != null) {
            this.InsertThrobber(224, 122, 10, 10);
            this.m_aWikiEditor = wikiEditorImpl;
        }
        this.InitStrings(xComponentContext);
        this.InitShowBrowser(xComponentContext);
        this.InitControls(xComponentContext);
    }

    private void InitControls(XComponentContext xComponentContext) {
        try {
            this.GetPropSet("CommentText").setPropertyValue("AutoVScroll", (Object)Boolean.TRUE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void InitStrings(XComponentContext xComponentContext) {
        try {
            this.SetTitle(Helper.GetLocalizedString(xComponentContext, 6));
            this.GetPropSet("Label1").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xComponentContext, 20));
            this.GetPropSet("FixedLine2").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xComponentContext, 7));
            this.GetPropSet("Label2").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xComponentContext, 21));
            this.GetPropSet("Label3").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xComponentContext, 22));
            this.GetPropSet("MinorCheck").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xComponentContext, 23));
            this.GetPropSet("BrowserCheck").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xComponentContext, 24));
            this.GetPropSet("AddButton").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xComponentContext, 12));
            this.GetPropSet("SendButton").setPropertyValue("Label", (Object)Helper.GetLocalizedString(xComponentContext, 14));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void InitShowBrowser(XComponentContext xComponentContext) {
        try {
            this.GetPropSet("BrowserCheck").setPropertyValue("State", (Object)new Short(Helper.GetShowInBrowserByDefault(this.m_xContext) ? (short)1 : 0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean show() {
        this.EnableControls(true);
        boolean bl = super.show();
        if (bl && Helper.GetShowInBrowserByDefault(this.m_xContext)) {
            Helper.ShowURLInBrowser(this.m_xContext, this.m_sWikiEngineURL + "index.php?title=" + this.m_sWikiTitle);
        }
        return bl;
    }

    @Override
    public synchronized void ThreadStop(boolean bl) {
        boolean bl2 = !bl && this.m_aThread != null && !this.m_bThreadFinished;
        super.ThreadStop(bl);
        if (bl2) {
            Helper.ShowError(this.m_xContext, this.m_xDialog, 6, 30, null, false);
        }
    }

    public void fillWikiList() {
        String[] stringArray = this.m_aSettings.getWikiURLs();
        try {
            XPropertySet xPropertySet = this.GetPropSet("WikiList");
            xPropertySet.setPropertyValue("StringItemList", (Object)stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void fillDocList() {
        XPropertySet xPropertySet = this.GetPropSet("ArticleText");
        try {
            short[] sArray = (short[])this.GetPropSet("WikiList").getPropertyValue("SelectedItems");
            xPropertySet.setPropertyValue("StringItemList", (Object)this.m_aSettings.getWikiDocList(sArray[0], 5));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String GetWikiTitle() {
        return this.m_sWikiTitle;
    }

    public void SetWikiTitle(String string) {
        this.m_sWikiTitle = string;
        try {
            XPropertySet xPropertySet = this.GetPropSet("ArticleText");
            xPropertySet.setPropertyValue("Text", (Object)string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void switchSendButtonIfNecessary() {
        XPropertySet xPropertySet = this.GetPropSet("SendButton");
        if (xPropertySet != null) {
            XPropertySet xPropertySet2 = this.GetPropSet("WikiList");
            XPropertySet xPropertySet3 = this.GetPropSet("ArticleText");
            if (xPropertySet2 != null && xPropertySet3 != null) {
                try {
                    short[] sArray = (short[])this.GetPropSet("WikiList").getPropertyValue("SelectedItems");
                    String string = (String)xPropertySet3.getPropertyValue("Text");
                    if (sArray != null && sArray.length > 0 && string != null && string.length() != 0) {
                        xPropertySet.setPropertyValue("Enabled", (Object)Boolean.TRUE);
                    } else {
                        xPropertySet.setPropertyValue("Enabled", (Object)Boolean.FALSE);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void EnableControls(boolean bl) {
        try {
            String[] stringArray = new String[]{"WikiList", "ArticleText", "CommentText", "MinorCheck", "BrowserCheck", "HelpButton", "AddButton"};
            for (int i = 0; i < stringArray.length; ++i) {
                this.GetPropSet(stringArray[i]).setPropertyValue("Enabled", (Object)new Boolean(bl));
            }
            if (bl) {
                this.SetFocusTo("WikiList");
                this.switchSendButtonIfNecessary();
            } else {
                this.GetPropSet("SendButton").setPropertyValue("Enabled", (Object)new Boolean(bl));
                this.SetFocusTo("CancelButton");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean callHandlerMethod(XDialog xDialog, Object object, String string) {
        if (string.equals("Send")) {
            Object object2;
            XComponentContext xComponentContext;
            XPropertySet xPropertySet;
            Object object3;
            try {
                object3 = this.GetPropSet("WikiList");
                xPropertySet = this.GetPropSet("ArticleText");
                xComponentContext = this.GetPropSet("CommentText");
                object2 = this.GetPropSet("MinorCheck");
                XPropertySet xPropertySet2 = this.GetPropSet("BrowserCheck");
                short[] sArray = (short[])object3.getPropertyValue("SelectedItems");
                String[] stringArray = (String[])object3.getPropertyValue("StringItemList");
                this.m_sWikiEngineURL = stringArray[sArray[0]];
                this.m_aSettings.setLastUsedWikiServer(sArray[0]);
                this.m_sWikiTitle = (String)xPropertySet.getPropertyValue("Text");
                this.m_sWikiComment = (String)xComponentContext.getPropertyValue("Text");
                short s = (Short)object2.getPropertyValue("State");
                this.m_bWikiMinorEdit = s != 0;
                short s2 = (Short)xPropertySet2.getPropertyValue("State");
                Helper.SetShowInBrowserByDefault(this.m_xContext, s2 != 0);
                this.EnableControls(false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object3 = this;
            xPropertySet = xDialog;
            xComponentContext = this.m_xContext;
            this.SetThrobberVisible(true);
            this.SetThrobberActive(true);
            object2 = this.m_aSettings.getSettingByUrl(this.m_sWikiEngineURL);
            if (Helper.AllowThreadUsage(this.m_xContext)) {
                this.m_aThread = new Thread("com.sun.star.thread.WikiEditorSendingThread", (WikiPropDialog)object3, (Hashtable)object2, xComponentContext, (XDialog)xPropertySet){
                    final /* synthetic */ WikiPropDialog val$aThisDialog;
                    final /* synthetic */ Hashtable val$aWikiSettings;
                    final /* synthetic */ XComponentContext val$xContext;
                    final /* synthetic */ XDialog val$xDialogToClose;
                    {
                        this.val$aThisDialog = wikiPropDialog2;
                        this.val$aWikiSettings = hashtable;
                        this.val$xContext = xComponentContext;
                        this.val$xDialogToClose = xDialog;
                        super(string);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (WikiPropDialog.this.m_aWikiEditor != null) {
                                Thread.yield();
                                WikiPropDialog.this.m_bAction = WikiPropDialog.this.m_aWikiEditor.SendArticleImpl(this.val$aThisDialog, this.val$aWikiSettings);
                            }
                        }
                        finally {
                            WikiPropDialog.this.EnableControls(true);
                            WikiPropDialog.this.SetThrobberActive(false);
                            WikiPropDialog.this.SetThrobberVisible(false);
                            WikiPropDialog.this.ThreadStop(true);
                            if (WikiPropDialog.this.m_bAction) {
                                MainThreadDialogExecutor.Close(this.val$xContext, this.val$xDialogToClose);
                            }
                        }
                    }
                };
                this.m_aThread.start();
            } else {
                try {
                    if (this.m_aWikiEditor != null) {
                        this.m_bAction = this.m_aWikiEditor.SendArticleImpl((WikiPropDialog)object3, (Hashtable)object2);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    this.EnableControls(true);
                    this.SetThrobberActive(false);
                    this.SetThrobberVisible(false);
                    if (this.m_bAction) {
                        xPropertySet.endExecute();
                    }
                }
            }
            return true;
        }
        if (string.equals("WikiListChange")) {
            this.fillDocList();
            this.switchSendButtonIfNecessary();
            return true;
        }
        if (string.equals("ArticleTextChange")) {
            this.switchSendButtonIfNecessary();
            return true;
        }
        if (string.equals("AddWiki")) {
            WikiEditSettingDialog wikiEditSettingDialog = new WikiEditSettingDialog(this.m_xContext, "vnd.sun.star.script:WikiEditor.EditSetting?location=application");
            if (wikiEditSettingDialog.show()) {
                this.fillWikiList();
            }
            wikiEditSettingDialog.DisposeDialog();
            return true;
        }
        return false;
    }

    @Override
    public void windowClosed(EventObject eventObject) {
        this.ThreadStop(false);
    }
}

