/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.CellValue;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class LabelCell
extends CellValue {
    private byte[] cch = new byte[2];
    private byte[] rgch;

    public LabelCell(int n, int n2, String string, int n3) throws IOException {
        this.setLabel(string);
        this.setRow(n);
        this.setCol(n2);
        this.setIxfe(n3);
    }

    public LabelCell(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        super.write(outputStream);
        outputStream.write(this.cch);
        outputStream.write(this.rgch);
        Debug.log((int)4, (String)"Writing Label record");
    }

    @Override
    public short getBiffType() {
        return 4;
    }

    @Override
    public int read(InputStream inputStream) throws IOException {
        int n = super.read(inputStream);
        n += inputStream.read(this.cch);
        int n2 = EndianConverter.readShort((byte[])this.cch) * 2;
        this.rgch = new byte[n2];
        inputStream.read(this.rgch, 0, n2);
        Debug.log((int)4, (String)(" cch : " + EndianConverter.readShort((byte[])this.cch) + " rgch : " + new String(this.rgch, "UTF-16LE")));
        return n;
    }

    @Override
    public String getString() throws IOException {
        return new String(this.rgch, "UTF-16LE");
    }

    private void setLabel(String string) throws IOException {
        this.rgch = string.getBytes("UTF-16LE");
        this.cch = EndianConverter.writeShort((short)((short)string.length()));
    }
}

