/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public abstract class CellValue
implements BIFFRecord {
    protected byte[] rw = new byte[2];
    protected byte col;
    protected byte[] ixfe = new byte[2];

    public int getRow() {
        return EndianConverter.readShort((byte[])this.rw) + 1;
    }

    public void setRow(int n) {
        this.rw = EndianConverter.writeShort((short)((short)(n - 1)));
    }

    public int getIxfe() {
        return EndianConverter.readShort((byte[])this.ixfe);
    }

    public void setIxfe(int n) {
        this.ixfe = EndianConverter.writeShort((short)((short)n));
    }

    public int getCol() {
        return this.col + 1;
    }

    public void setCol(int n) {
        this.col = (byte)(n - 1);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.rw);
        outputStream.write(this.col);
        outputStream.write(this.ixfe);
    }

    @Override
    public int read(InputStream inputStream) throws IOException {
        int n = inputStream.read(this.rw);
        this.col = (byte)(this.col + inputStream.read());
        ++n;
        Debug.log((int)4, (String)("\tRow : " + EndianConverter.readShort((byte[])this.rw) + " Column : " + this.col + " ixfe : " + EndianConverter.readShort((byte[])this.ixfe)));
        return n += inputStream.read(this.ixfe);
    }

    public abstract String getString() throws IOException;
}

