/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Target;
import gnu.kawa.reflect.LazyType;
import gnu.kawa.reflect.OccurrenceType;
import gnu.mapping.Values;

public class StackTarget
extends Target {
    Type type;

    public StackTarget(Type type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public static Target getInstance(Type type) {
        return type.isVoid() ? Target.Ignore : (type == Type.pointer_type ? Target.pushObject : new StackTarget(type));
    }

    protected StackTarget getClonedInstance(Type type) {
        return new StackTarget(type);
    }

    public static void forceLazyIfNeeded(Compilation comp, Type stackType, Type type) {
        CodeAttr code = comp.getCode();
        if (LazyType.maybeLazy(stackType) && !LazyType.maybeLazy(type) && type.getRawType().compare(stackType.getRawType()) < 0) {
            Method forceMethod = stackType instanceof LazyType ? LazyType.lazyType.getDeclaredMethod("getValue", 0) : ClassType.make("gnu.mapping.Promise").getDeclaredStaticMethod("force", 1);
            code.emitInvoke(forceMethod);
            stackType = stackType instanceof LazyType ? ((LazyType)stackType).getValueType() : Type.objectType;
        }
    }

    protected boolean compileFromStack0(Compilation comp, Type stackType) {
        return StackTarget.compileFromStack0(comp, stackType, this.type);
    }

    static boolean compileFromStack0(Compilation comp, Type stackType, Type type) {
        CodeAttr code = comp.getCode();
        StackTarget.forceLazyIfNeeded(comp, stackType, type);
        if (type == stackType || !code.reachableHere()) {
            return true;
        }
        if (stackType.isVoid()) {
            comp.compileConstant(Values.empty);
            stackType = Type.pointer_type;
        } else if (stackType instanceof PrimType && type instanceof PrimType) {
            code.emitConvert(stackType, type);
            return true;
        }
        if (stackType instanceof ArrayType) {
            if (type == Type.pointer_type || "java.lang.Cloneable".equals(type.getName())) {
                return true;
            }
        } else {
            type.emitConvertFromPrimitive(stackType, code);
            stackType = code.topType();
        }
        return !CodeAttr.castNeeded(stackType.getRawType(), type.getRawType());
    }

    public static void convert(Compilation comp, Type stackType, Type targetType) {
        if (!StackTarget.compileFromStack0(comp, stackType, targetType)) {
            StackTarget.emitCoerceFromObject(targetType, comp);
        }
    }

    protected static void emitCoerceFromObject(Type type, Compilation comp) {
        CodeAttr code = comp.getCode();
        if (type instanceof OccurrenceType) {
            comp.compileConstant(type, Target.pushObject);
            code.emitSwap();
            code.emitInvokeVirtual(ClassType.make("gnu.bytecode.Type").getDeclaredMethod("coerceFromObject", 1));
        } else {
            comp.usedClass(type);
            type.emitCoerceFromObject(code);
        }
    }

    @Override
    public void compileFromStack(Compilation comp, Type stackType) {
        if (this.type instanceof LazyType && !(stackType instanceof LazyType)) {
            LazyType ltype = (LazyType)this.type;
            if (!LazyType.maybeLazy(stackType)) {
                this.getClonedInstance(ltype.getValueType()).compileFromStack(comp, stackType);
            }
            Method wrapMethod = ClassType.make("gnu.mapping.Promise").getDeclaredStaticMethod("coerceToLazy", 1);
            comp.getCode().emitInvokeStatic(wrapMethod);
            comp.getCode().emitCheckcast(ltype.getRawType());
        } else if (!this.compileFromStack0(comp, stackType)) {
            this.doCoerce(comp);
        }
    }

    protected void doCoerce(Compilation comp) {
        StackTarget.emitCoerceFromObject(this.type, comp);
    }
}

